# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Metadata(object):
    """Metadata - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'owner_reference_id': 'str',
        'owner_user_name': 'str',
        'project_reference_id': 'str',
        'project_name': 'str',
        'category_ids': 'list[str]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'owner_reference_id': 'ownerReferenceId',
        'owner_user_name': 'ownerUserName',
        'project_reference_id': 'projectReferenceId',
        'project_name': 'projectName',
        'category_ids': 'categoryIds',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, owner_reference_id=None, owner_user_name=None, project_reference_id=None, project_name=None, category_ids=None, *args, **kwargs):  # noqa: E501
        """Metadata - a model defined in Swagger
            \nMetadata associated with this resource. 
        """
        self.__owner_reference_id = None
        self.__owner_user_name = None
        self.__project_reference_id = None
        self.__project_name = None
        self.__category_ids = None
        self.discriminator = None
        if owner_reference_id is not None:
            self.__owner_reference_id = owner_reference_id
        if owner_user_name is not None:
            self.__owner_user_name = owner_user_name
        if project_reference_id is not None:
            self.__project_reference_id = project_reference_id
        if project_name is not None:
            self.__project_name = project_name
        if category_ids is not None:
            self.__category_ids = category_ids
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'common.v1.config.Metadata'

    def _initialize_fq_object_type(self):
        return 'common.v1.r0.a3.config.Metadata'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def owner_reference_id(self):
        """`{ str }`
            \nA globally unique identifier that represents the owner of this resource. 
        """ # noqa: E501
        return self.__owner_reference_id

    @owner_reference_id.setter
    def owner_reference_id(self, owner_reference_id):
        if owner_reference_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', owner_reference_id):  # noqa: E501
            raise ValueError(r"Invalid value for `owner_reference_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__owner_reference_id = owner_reference_id

    @property
    def owner_user_name(self):
        """`{ str }`
            \nThe userName of the owner of this resource. 
        """ # noqa: E501
        return self.__owner_user_name

    @owner_user_name.setter
    def owner_user_name(self, owner_user_name):
        if owner_user_name is not None and len(owner_user_name) > 128:
            raise ValueError("Invalid value for `owner_user_name`, length must be less than or equal to `128`")  # noqa: E501

        self.__owner_user_name = owner_user_name

    @property
    def project_reference_id(self):
        """`{ str }`
            \nA globally unique identifier that represents the project this resource belongs to. 
        """ # noqa: E501
        return self.__project_reference_id

    @project_reference_id.setter
    def project_reference_id(self, project_reference_id):
        if project_reference_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', project_reference_id):  # noqa: E501
            raise ValueError(r"Invalid value for `project_reference_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__project_reference_id = project_reference_id

    @property
    def project_name(self):
        """`{ str }`
            \nThe name of the project this resource belongs to. 
        """ # noqa: E501
        return self.__project_name

    @project_name.setter
    def project_name(self, project_name):
        if project_name is not None and len(project_name) > 128:
            raise ValueError("Invalid value for `project_name`, length must be less than or equal to `128`")  # noqa: E501

        self.__project_name = project_name

    @property
    def category_ids(self):
        """`{ list[str] }`
            \nA list of globally unique identifiers that represent all the categories the resource is associated with. 
        """ # noqa: E501
        return self.__category_ids

    @category_ids.setter
    def category_ids(self, category_ids):

        self.__category_ids = category_ids

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Metadata, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Metadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

