from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ValueSet_ParameterSchema:
    """
    A value set specifies a set of codes drawn from one or more code systems.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A value set specifies a set of codes drawn from one or more code systems.


        name: The name of the parameter.

        valueString: The value of the parameter.

        valueBoolean: The value of the parameter.

        valueInteger: The value of the parameter.

        valueDecimal: The value of the parameter.

        valueUri: The value of the parameter.

        valueCode: The value of the parameter.

        """
        if (
            max_recursion_limit
            and nesting_list.count("ValueSet_Parameter") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ValueSet_Parameter"]
        schema = StructType(
            [
                # The name of the parameter.
                StructField("name", StringType(), True),
                # The value of the parameter.
                StructField("valueString", StringType(), True),
                # The value of the parameter.
                StructField("valueBoolean", BooleanType(), True),
                # The value of the parameter.
                StructField("valueInteger", IntegerType(), True),
                # The value of the parameter.
                StructField("valueDecimal", IntegerType(), True),
                # The value of the parameter.
                StructField("valueUri", StringType(), True),
                # The value of the parameter.
                StructField("valueCode", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
