from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class PeriodSchema:
    """
    A time period defined by a start and end date and optionally time.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A time period defined by a start and end date and optionally time.


        start: The start of the period. The boundary is inclusive.

        end: The end of the period. If the end of the period is missing, it means that the
            period is ongoing. The start may be in the past, and the end date in the
            future, which means that period is expected/planned to end at that time.

        """
        if (
            max_recursion_limit and nesting_list.count("Period") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Period"]
        schema = StructType(
            [
                # The start of the period. The boundary is inclusive.
                StructField("start", StringType(), True),
                # The end of the period. If the end of the period is missing, it means that the
                # period is ongoing. The start may be in the past, and the end date in the
                # future, which means that period is expected/planned to end at that time.
                StructField("end", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
