from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class PatientSchema:
    """
    Demographics and other administrative information about an individual or
    animal receiving care or other health-related services.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Demographics and other administrative information about an individual or
        animal receiving care or other health-related services.


        resourceType: This is a Patient resource

        identifier: An identifier for this patient.

        active: Whether this patient record is in active use.

        name: A name associated with the individual.

        telecom: A contact detail (e.g. a telephone number or an email address) by which the
            individual may be contacted.

        gender: Administrative Gender - the gender that the patient is considered to have for
            administration and record keeping purposes.

        birthDate: The date of birth for the individual.

        deceasedBoolean: Indicates if the individual is deceased or not.

        deceasedDateTime: Indicates if the individual is deceased or not.

        address: Addresses for the individual.

        maritalStatus: This field contains a patient's most recent marital (civil) status.

        multipleBirthBoolean: Indicates whether the patient is part of a multiple (bool) or indicates the
            actual birth order (integer).

        multipleBirthInteger: Indicates whether the patient is part of a multiple (bool) or indicates the
            actual birth order (integer).

        photo: Image of the patient.

        contact: A contact party (e.g. guardian, partner, friend) for the patient.

        animal: This patient is known to be an animal.

        communication: Languages which may be used to communicate with the patient about his or her
            health.

        generalPractitioner: Patient's nominated care provider.

        managingOrganization: Organization that is the custodian of the patient record.

        link: Link to another patient resource that concerns the same actual patient.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.humanname import HumanNameSchema
        from spark_fhir_schemas.stu3.complex_types.contactpoint import (
            ContactPointSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.address import AddressSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.patient_contact import (
            Patient_ContactSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.patient_animal import (
            Patient_AnimalSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.patient_communication import (
            Patient_CommunicationSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.patient_link import (
            Patient_LinkSchema,
        )

        if (
            max_recursion_limit and nesting_list.count("Patient") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Patient"]
        schema = StructType(
            [
                # This is a Patient resource
                StructField("resourceType", StringType(), True),
                # An identifier for this patient.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Whether this patient record is in active use.
                StructField("active", BooleanType(), True),
                # A name associated with the individual.
                StructField(
                    "name",
                    ArrayType(
                        HumanNameSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A contact detail (e.g. a telephone number or an email address) by which the
                # individual may be contacted.
                StructField(
                    "telecom",
                    ArrayType(
                        ContactPointSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Administrative Gender - the gender that the patient is considered to have for
                # administration and record keeping purposes.
                StructField("gender", StringType(), True),
                # The date of birth for the individual.
                StructField("birthDate", StringType(), True),
                # Indicates if the individual is deceased or not.
                StructField("deceasedBoolean", BooleanType(), True),
                # Indicates if the individual is deceased or not.
                StructField("deceasedDateTime", StringType(), True),
                # Addresses for the individual.
                StructField(
                    "address",
                    ArrayType(
                        AddressSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # This field contains a patient's most recent marital (civil) status.
                StructField(
                    "maritalStatus",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Indicates whether the patient is part of a multiple (bool) or indicates the
                # actual birth order (integer).
                StructField("multipleBirthBoolean", BooleanType(), True),
                # Indicates whether the patient is part of a multiple (bool) or indicates the
                # actual birth order (integer).
                StructField("multipleBirthInteger", IntegerType(), True),
                # Image of the patient.
                StructField(
                    "photo",
                    ArrayType(
                        AttachmentSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A contact party (e.g. guardian, partner, friend) for the patient.
                StructField(
                    "contact",
                    ArrayType(
                        Patient_ContactSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # This patient is known to be an animal.
                StructField(
                    "animal",
                    Patient_AnimalSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Languages which may be used to communicate with the patient about his or her
                # health.
                StructField(
                    "communication",
                    ArrayType(
                        Patient_CommunicationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Patient's nominated care provider.
                StructField(
                    "generalPractitioner",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Organization that is the custodian of the patient record.
                StructField(
                    "managingOrganization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Link to another patient resource that concerns the same actual patient.
                StructField(
                    "link",
                    ArrayType(
                        Patient_LinkSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
