from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MeasureReport_StratifierSchema:
    """
    The MeasureReport resource contains the results of evaluating a measure.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        The MeasureReport resource contains the results of evaluating a measure.


        identifier: The identifier of this stratifier, as defined in the measure definition.

        stratum: This element contains the results for a single stratum within the stratifier.
            For example, when stratifying on administrative gender, there will be four
            strata, one for each possible gender value.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.measurereport_stratum import (
            MeasureReport_StratumSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("MeasureReport_Stratifier") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MeasureReport_Stratifier"]
        schema = StructType(
            [
                # The identifier of this stratifier, as defined in the measure definition.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # This element contains the results for a single stratum within the stratifier.
                # For example, when stratifying on administrative gender, there will be four
                # strata, one for each possible gender value.
                StructField(
                    "stratum",
                    ArrayType(
                        MeasureReport_StratumSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
