from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImagingManifest_InstanceSchema:
    """
    A text description of the DICOM SOP instances selected in the ImagingManifest;
    or the reason for, or significance of, the selection.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A text description of the DICOM SOP instances selected in the ImagingManifest;
        or the reason for, or significance of, the selection.


        sopClass: SOP class UID of the selected instance.

        uid: SOP Instance UID of the selected instance.

        """
        if (
            max_recursion_limit
            and nesting_list.count("ImagingManifest_Instance") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImagingManifest_Instance"]
        schema = StructType(
            [
                # SOP class UID of the selected instance.
                StructField("sopClass", StringType(), True),
                # SOP Instance UID of the selected instance.
                StructField("uid", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
