from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class EpisodeOfCare_DiagnosisSchema:
    """
    An association between a patient and an organization / healthcare provider(s)
    during which time encounters may occur. The managing organization assumes a
    level of responsibility for the patient during this time.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        An association between a patient and an organization / healthcare provider(s)
        during which time encounters may occur. The managing organization assumes a
        level of responsibility for the patient during this time.


        condition: A list of conditions/problems/diagnoses that this episode of care is intended
            to be providing care for.

        role: Role that this diagnosis has within the episode of care (e.g. admission,
            billing, discharge …).

        rank: Ranking of the diagnosis (for each role type).

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("EpisodeOfCare_Diagnosis") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["EpisodeOfCare_Diagnosis"]
        schema = StructType(
            [
                # A list of conditions/problems/diagnoses that this episode of care is intended
                # to be providing care for.
                StructField(
                    "condition",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Role that this diagnosis has within the episode of care (e.g. admission,
                # billing, discharge …).
                StructField(
                    "role",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Ranking of the diagnosis (for each role type).
                StructField("rank", IntegerType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
