from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DataRequirement_CodeFilterSchema:
    """
    Describes a required data item for evaluation in terms of the type of data,
    and optional code or date-based filters of the data.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes a required data item for evaluation in terms of the type of data,
        and optional code or date-based filters of the data.


        path: The code-valued attribute of the filter. The specified path must be resolvable
            from the type of the required data. The path is allowed to contain qualifiers
            (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-
            cardinality sub-elements. Note that the index must be an integer constant. The
            path must resolve to an element of type code, Coding, or CodeableConcept.

        valueSetString: The valueset for the code filter. The valueSet and value elements are
            exclusive. If valueSet is specified, the filter will return only those data
            items for which the value of the code-valued element specified in the path is
            a member of the specified valueset.

        valueSetReference: The valueset for the code filter. The valueSet and value elements are
            exclusive. If valueSet is specified, the filter will return only those data
            items for which the value of the code-valued element specified in the path is
            a member of the specified valueset.

        valueCode: The codes for the code filter. Only one of valueSet, valueCode, valueCoding,
            or valueCodeableConcept may be specified. If values are given, the filter will
            return only those data items for which the code-valued attribute specified by
            the path has a value that is one of the specified codes.

        valueCoding: The Codings for the code filter. Only one of valueSet, valueCode,
            valueConding, or valueCodeableConcept may be specified. If values are given,
            the filter will return only those data items for which the code-valued
            attribute specified by the path has a value that is one of the specified
            Codings.

        valueCodeableConcept: The CodeableConcepts for the code filter. Only one of valueSet, valueCode,
            valueConding, or valueCodeableConcept may be specified. If values are given,
            the filter will return only those data items for which the code-valued
            attribute specified by the path has a value that is one of the specified
            CodeableConcepts.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("DataRequirement_CodeFilter") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DataRequirement_CodeFilter"]
        schema = StructType(
            [
                # The code-valued attribute of the filter. The specified path must be resolvable
                # from the type of the required data. The path is allowed to contain qualifiers
                # (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-
                # cardinality sub-elements. Note that the index must be an integer constant. The
                # path must resolve to an element of type code, Coding, or CodeableConcept.
                StructField("path", StringType(), True),
                # The valueset for the code filter. The valueSet and value elements are
                # exclusive. If valueSet is specified, the filter will return only those data
                # items for which the value of the code-valued element specified in the path is
                # a member of the specified valueset.
                StructField("valueSetString", StringType(), True),
                # The valueset for the code filter. The valueSet and value elements are
                # exclusive. If valueSet is specified, the filter will return only those data
                # items for which the value of the code-valued element specified in the path is
                # a member of the specified valueset.
                StructField(
                    "valueSetReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The codes for the code filter. Only one of valueSet, valueCode, valueCoding,
                # or valueCodeableConcept may be specified. If values are given, the filter will
                # return only those data items for which the code-valued attribute specified by
                # the path has a value that is one of the specified codes.
                # The Codings for the code filter. Only one of valueSet, valueCode,
                # valueConding, or valueCodeableConcept may be specified. If values are given,
                # the filter will return only those data items for which the code-valued
                # attribute specified by the path has a value that is one of the specified
                # Codings.
                StructField(
                    "valueCoding",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The CodeableConcepts for the code filter. Only one of valueSet, valueCode,
                # valueConding, or valueCodeableConcept may be specified. If values are given,
                # the filter will return only those data items for which the code-valued
                # attribute specified by the path has a value that is one of the specified
                # CodeableConcepts.
                StructField(
                    "valueCodeableConcept",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
