from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Claim_InsuranceSchema:
    """
    A provider issued list of services and products provided, or to be provided,
    to a patient which is provided to an insurer for payment recovery.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A provider issued list of services and products provided, or to be provided,
        to a patient which is provided to an insurer for payment recovery.


        sequence: Sequence of coverage which serves to provide a link and convey coordination of
            benefit order.

        focal: A flag to indicate that this Coverage is the focus for adjudication. The
            Coverage against which the claim is to be adjudicated.

        coverage: Reference to the program or plan identification, underwriter or payor.

        businessArrangement: The contract number of a business agreement which describes the terms and
            conditions.

        preAuthRef: A list of references from the Insurer to which these services pertain.

        claimResponse: The Coverages adjudication details.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Claim_Insurance") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Claim_Insurance"]
        schema = StructType(
            [
                # Sequence of coverage which serves to provide a link and convey coordination of
                # benefit order.
                StructField("sequence", IntegerType(), True),
                # A flag to indicate that this Coverage is the focus for adjudication. The
                # Coverage against which the claim is to be adjudicated.
                StructField("focal", BooleanType(), True),
                # Reference to the program or plan identification, underwriter or payor.
                StructField(
                    "coverage",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The contract number of a business agreement which describes the terms and
                # conditions.
                StructField("businessArrangement", StringType(), True),
                # A list of references from the Insurer to which these services pertain.
                # The Coverages adjudication details.
                StructField(
                    "claimResponse",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
