from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class AppointmentResponseSchema:
    """
    A reply to an appointment request for a patient and/or practitioner(s), such
    as a confirmation or rejection.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A reply to an appointment request for a patient and/or practitioner(s), such
        as a confirmation or rejection.


        resourceType: This is a AppointmentResponse resource

        identifier: This records identifiers associated with this appointment response concern
            that are defined by business processes and/ or used to refer to it when a
            direct URL reference to the resource itself is not appropriate.

        appointment: Appointment that this response is replying to.

        start: Date/Time that the appointment is to take place, or requested new start time.

        end: This may be either the same as the appointment request to confirm the details
            of the appointment, or alternately a new time to request a re-negotiation of
            the end time.

        participantType: Role of participant in the appointment.

        actor: A Person, Location/HealthcareService or Device that is participating in the
            appointment.

        participantStatus: Participation status of the participant. When the status is declined or
            tentative if the start/end times are different to the appointment, then these
            times should be interpreted as a requested time change. When the status is
            accepted, the times can either be the time of the appointment (as a
            confirmation of the time) or can be empty.

        comment: Additional comments about the appointment.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("AppointmentResponse") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["AppointmentResponse"]
        schema = StructType(
            [
                # This is a AppointmentResponse resource
                StructField("resourceType", StringType(), True),
                # This records identifiers associated with this appointment response concern
                # that are defined by business processes and/ or used to refer to it when a
                # direct URL reference to the resource itself is not appropriate.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Appointment that this response is replying to.
                StructField(
                    "appointment",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Date/Time that the appointment is to take place, or requested new start time.
                StructField("start", StringType(), True),
                # This may be either the same as the appointment request to confirm the details
                # of the appointment, or alternately a new time to request a re-negotiation of
                # the end time.
                StructField("end", StringType(), True),
                # Role of participant in the appointment.
                StructField(
                    "participantType",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A Person, Location/HealthcareService or Device that is participating in the
                # appointment.
                StructField(
                    "actor",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Participation status of the participant. When the status is declined or
                # tentative if the start/end times are different to the appointment, then these
                # times should be interpreted as a requested time change. When the status is
                # accepted, the times can either be the time of the appointment (as a
                # confirmation of the time) or can be empty.
                StructField("participantStatus", StringType(), True),
                # Additional comments about the appointment.
                StructField("comment", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
