#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

import os
from singa_auto.admin.app import create_app
from singa_auto.utils.log import configure_logging
from singa_auto.admin import Admin
from datetime import datetime

curr_time = datetime.now().strftime("%d-%m-%Y_%I-%M-%S_%p")
flask_admin_logname = 'flask-web-admin' + '-' + curr_time

configure_logging(process_name=flask_admin_logname)

if __name__ == "__main__":
    # Run seed logic for admin at start-up
    admin = Admin()
    admin.seed()
    app = create_app()
    # Run Flask app
    app.run(host='0.0.0.0', port=os.getenv('ADMIN_PORT', 3000), threaded=True)
