#!/usr/bin/env bash
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# Read from shell configuration file


if [ $HOST_WORKDIR_PATH ];then
	echo "HOST_WORKDIR_PATH is exist, and echo to = $HOST_WORKDIR_PATH"
else
	export HOST_WORKDIR_PATH=$PWD
fi

source $HOST_WORKDIR_PATH/scripts/kubernetes/.env.sh
source $HOST_WORKDIR_PATH/scripts/base_utils.sh

title "Using K8S"

bash $HOST_WORKDIR_PATH/scripts/base_build_image.sh

# Spark app requires a spark cluster, k8s can provide that,
title "Building SINGA-Auto SparkApp's image..."
docker build -t $SINGA_AUTO_IMAGE_SPARKAPP:$SINGA_AUTO_VERSION -f ./log_minitor/dockerfiles/spark.Dockerfile \
      --build-arg SPAEK_DOCKER_JARS_PATH=$SPAEK_DOCKER_JARS_PATH $PWD
