from ..abc.processor import Processor


class StringToBytesParser(Processor):

	ConfigDefaults = {
		'encoding': 'utf-8',
	}

	def __init__(self, app, pipeline, id=None, config=None):
		super().__init__(app, pipeline, id, config)
		self.Encoding = self.Config['encoding']

	def process(self, context, event):
		assert isinstance(event, str)
		return event.encode(self.Encoding)


class BytesToStringParser(Processor):

	ConfigDefaults = {
		'encoding': 'utf-8',
	}

	def __init__(self, app, pipeline, id=None, config=None):
		super().__init__(app, pipeline, id, config)
		self.Encoding = self.Config['encoding']

	def process(self, context, event):
		assert isinstance(event, bytes)
		return event.decode(self.Encoding)
