# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['integrity']

package_data = \
{'': ['*']}

install_requires = \
['beet>=0.56.0,<0.57.0', 'mecha>=0.43.3,<0.44.0']

setup_kwargs = {
    'name': 'integrity',
    'version': '0.4.0',
    'description': 'Development facilities for the bolt environment',
    'long_description': '# Integrity\n\n[![GitHub Actions](https://github.com/thewii/integrity/workflows/CI/badge.svg)](https://github.com/thewii/integrity/actions)\n[![PyPI](https://img.shields.io/pypi/v/integrity.svg)](https://pypi.org/project/integrity/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/integrity.svg)](https://pypi.org/project/integrity/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n[![Discord](https://img.shields.io/discord/900530660677156924?color=7289DA&label=discord&logo=discord&logoColor=fff)](https://discord.gg/98MdSGMm8j)\n\n> Development facilities for the bolt environment\n\n```python\nfrom integrity import Component\n\nfrom ./settings import settings\nfrom ./blocks import blocks\nfrom ./player import player\n\nmain = Component()\n\nfunction main.on("main"):\n    if score settings.data.activated obj matches 1:\n        main.run("active")\n\nfunction main.on("active"):\n    as @a at @s:\n        player.run("main")\n\nfunction blocks.on("placed_by_player"):\n    if block ~ ~ ~ stone expand:\n        say Placed stone!\n        player.run("placed_stone")\n\n```\n\n## Installation\n\nThe package can be installed with `pip`. Note, you must have\nboth `beet` and `mecha` installed to use this package.\n\n```bash\n$ pip install integrity\n```\n\n## Getting Started\n\nTo use this package, we must add the plugin to the `require`\nsection in the `beet` project file alongside with `mecha` and\n`mecha.contrib.bolt`.\n\n```yaml\nrequire:\n    - mecha.contrib.bolt\n    - integrity\npipeline:\n    - mecha\n```\n\nNow that we\'ve enabled `integrity`, we can import the module\ndirectly inside a bolt script\n\n```python\nfrom integrity import Component\n\nfoo = Component("foo")\n```\n\n## Features\n\n### Components\n\nWhen developing a data pack with `bolt`, it\'s possible to\ndefine several nested resources (such as functions and tags)\nin a single bolt script. However, as the data pack grows in size,\nstructuring all of these resources can get pretty cumbersome,\nsince most of the time you\'d be working with absolute and\nrelative paths. That being said, `integrity` provides an elegant\nway of working with nested resources: through components.\n\nA `Component` object is a container of nested resources, but can\nalso hold data and bolt functions. To create a component, simply\nimport and call the `Component` factory method:\n\n```python\nfrom integrity import Component\n\nmy_component = Component("demo")\n```\n\nWhen creating a component, we can provide a unique name as a parameter. In this\ncase, `my_component` is called `demo`.\n\n> **Note:** A component\'s name must be **unique in the module scope**.\n\nWith a `Component` object in hands, we can start defining its properties\nthrough the API.\n\n#### **Component.on(function_name: str): str**\n\nCreates and returns a [resource location](https://minecraft.fandom.com/wiki/Resource_location) associated with the given\n`function_name` value. The returned `str` value can be used to define a nested\nfunction:\n\n```python\n# main.mcfunction\n\nfrom integrity import Component\n\nclock = Component("golden_clock")\n\n\ntick_function_path = clock.on("tick")\n\nfunction tick_function_path:\n    say "Clock ticks"\n\n\nfunction clock.on("midnight"):\n    say "It\'s midnight"\n\n\nfunction ./tick:\n    clock.run("tick")\n```\n\nThis example would generate the following file structure:\n\n```yaml\nroot:\n    - tick.mcfunction\n    - main.mcfunction\n    - main:\n        - components:\n            - golden_clock:\n                - tick.mcfunction\n                - midnight.mcfunction\n```\n\n> **Note:** This structure might change in the future and/or will be\ncustomizable.\n\n#### **Component.run(function_name: str)**\n\nGenerates a `function` command that calls the function with\nthe specified `function_name` value. The command is generated regardless\nif the function exists.\n\n```python\n\nfrom integrity import Component\n\nbeam = Component("beam")\n\nfunction beam.on("raycast"):\n    unless block ~ ~ ~ air:\n        beam.run("hit")\n    if block ~ ~ ~ air:\n        beam.run("raycast")\n\nfunction beam.on("hit"):\n    setblock ~ ~ ~ air destroy\n\nfunction beam.on("tick"):\n    if entity @s[tag=right_clicked]:\n        beam.run("raycast")\n    tag @s remove right_clicked\n\n\nfunction ./tick:\n    beam.run("clear") # not implemented yet\n    as @a at @s:\n        beam.run("tick")\n```\n\n#### **Component.data**\n\nA `dict` object to store anything that might belong to a specific component.\nAll components are created with an empty `data` field.\n\n```python\nfrom integrity import Component\n\nplayer = Component("player")\nplayer.data["entity_id"] = "minecraft:player"\n\npig = Component("pig")\nplayer.data["entity_id"] = "minecraft:pig"\n\nplayer.data # { "entity_id": "minecraft:player" }\npig.data # { "entity_id": "minecraft:pig" }\n```\n\n## Contributing\n\nContributions are welcome. Make sure to first open an issue\ndiscussing the problem or the new feature before creating a\npull request. The project uses [`poetry`](https://python-poetry.org).\n\n```bash\n$ poetry install\n```\n\nYou can run the tests with `poetry run pytest`.\n\n```bash\n$ poetry run pytest\n```\n\nThe project must type-check with [`pyright`](https://github.com/microsoft/pyright).\nIf you\'re using VSCode the [`pylance`](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)\nextension should report diagnostics automatically. You can also install\nthe type-checker locally with `npm install` and run it from the command-line.\n\n```bash\n$ npm run watch\n$ npm run check\n```\n\nThe code follows the [`black`](https://github.com/psf/black) code style.\nImport statements are sorted with [`isort`](https://pycqa.github.io/isort/).\n\n```bash\n$ poetry run isort bolt_expressions examples tests\n$ poetry run black bolt_expressions examples tests\n$ poetry run black --check bolt_expressions examples tests\n```\n\n---\n\nLicense - [MIT](https://github.com/rx-modules/bolt-expressions/blob/main/LICENSE)\n',
    'author': 'TheWii',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/thewii/integrity',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
