# The MIT License
#
# Copyright (c) 2017 Transact Pro.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
from enum import Enum


class Status(Enum):
    INIT = 1
    SENT2BANK = 2
    DMS_HOLD_OK = 3
    DMS_HOLD_FAILED = 4
    SMS_FAILED = 5
    DMS_CHARGE_FAILED = 6
    SUCCESS = 7
    EXPIRED = 8
    HOLD_EXPIRED = 9
    REFUND_FAILED = 11
    REFUND_PENDING = 12
    REFUND_SUCCESS = 13
    CARDHOLDER_ONSITE = 14
    DMS_CANCELED_OK = 15
    DMS_CANCELED_FAILED = 16
    REVERSED = 17
    INPUT_VALIDATION_FAILED = 18
    BR_VALIDATION_FAILED = 19
    TG_SELECT_FAILED = 20
    T_SELECT_FAILED = 21
    INIT_PARAMS_INVALID = 22
    DECLINED_BY_BR_ACTION = 23
    CALLBACK_URL_GENERATED = 24
    WAITING_CARD_FORM_FILL = 25
    MPI_URL_GENERATED = 26
    WAITING_MPI = 27
    MPI_FAILED = 28
    MPI_NOT_REACHABLE = 29
    CARD_FORM_URL_SENT = 30
    MPI_AUTH_ERROR = 31
    ACQUIRER_NOT_REACHABLE = 32
    REVERSAL_FAILED = 33
    CREDIT_FAILED = 34
    P2P_FAILED = 35
    B2P_FAILED = 36
    TOKEN_CREATED = 37
    TOKEN_CREATE_FAILED = 38


class ErrorCode(Enum):
    EEC_GENERAL_ERROR = 1000

    EEC_DISABLED_ACCOUNT = 1001
    EEC_DISABLED_TERMINAL = 1002
    EEC_DISABLED_LEGAL_PERSON = 1003

    EEC_TIMEOUT_TRN = 1004
    EEC_TIMEOUT_REDIRECT = 1005
    EEC_TIMEOUT_3D = 1006
    EEC_TIMEOUT_ACQ = 1007
    EEC_TIMEOUT_INTERNAL = 1008

    EEC_HSM_ENCODE = 1009
    EEC_HSM_DECODE = 1010

    EEC_MERCHANT_COUNTERS_EXCEEDED = 1011
    EEC_ACCOUNT_COUNTERS_EXCEEDED = 1012
    EEC_TERMINAL_GROUP_COUNTERS_EXCEEDED = 1013
    EEC_TERMINAL_COUNTERS_EXCEEDED = 1014
    EEC_HSM_TOKEN = 1015

    EEC_INPUT_VALIDATION_FAILED = 1100
    EEC_FAILED_BUSINESS_RULES = 1101

    EEC_CC_BAD_NUMBER = 1102
    EEC_CC_BAD_EXPIRE = 1103
    EEC_CC_NO_CVV = 1104
    EEC_CC_BAD_CVV = 1105
    EEC_CC_EXPIRED = 1106
    EEC_CC_UNKNOWN_CARD_TYPE = 1107
    EEC_3D_ERROR_MDSTATUS = 1108
    EEC_3D_ERROR_AUTH = 1109
    EEC_CC_LIABILITY_SHIFT = 1110
    EEC_CC_NOT_VALIDATED = 1111
    EEC_3D_DATA_CORRUPTED = 1112

    EEC_WRONG_GW_UNIQ_ID = 1151
    EEC_UNACCEPTABLE_GW_UNIQ_ID = 1152
    EEC_GW_UNIQ_ID_CONFLICT = 1153
    EEC_TRANSACTION_TYPE_INVALID = 1154
    EEC_TRANSACTION_STATE_INVALID = 1155
    EEC_TRANSACTION_ALREADY_FINISHED = 1156
    EEC_NO_PARENT_TRANSACTION_PROVIDED = 1157
    EEC_DYNAMIC_DESCRIPTOR_ERROR = 1158
    EEC_UCOF_ERROR = 1159
    EEC_SUSPECTED_FRAUD = 1160

    EEC_TERMINAL_NOT_FOUND = 1200
    EEC_ALL_TERMINAL_COUNTERS_EXCEEDED = 1201
    EEC_TERMINAL_GROUP_NOT_FOUND = 1202
    EEC_ALL_TERMINAL_GROUP_COUNTERS_EXCEEDED = 1203

    EEC_TERMINAL_NOT_SUPPORTING_MOTO = 1204
    EEC_TERMINAL_NOT_SUPPORTING_RECURRENTS = 1205

    EEC_DECLINED_BY_ACQUIRER = 1301
    EEC_ACQUIRER_ERROR = 1302
    EEC_ACQUIRER_SOFT_DECLINE = 1303

    EEC_INVALID_FORM_ID = 1400
    EEC_FORM_UNAVAILABLE = 1401

    EEC_CARD_VERIFICATION_NO_CARD_DATA = 1500
    EEC_CARD_VERIFICATION_ALREADY_VERIFIED = 1501

    EEC_RBS_INVALID_ORDER_NUMBER = 2000
    EEC_RBS_INVALID_DESCRIPTION = 2001
