# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/007_metrics.ipynb (unless otherwise specified).

__all__ = ['MatthewsCorrCoefBinary', 'get_task_metrics']

# Cell
from .imports import *
from fastai.metrics import *

# Cell
mk_class('ActivationType', **{o:o.lower() for o in ['No', 'Sigmoid', 'Softmax', 'BinarySoftmax']},
         doc="All possible activation classes for `AccumMetric")

# Cell
def MatthewsCorrCoefBinary(thresh=.5, sample_weight=None):
    "Matthews correlation coefficient for single-label classification problems"
    return skm_to_fastai(skm.matthews_corrcoef, activation=ActivationType.BinarySoftmax, thresh=thresh, sample_weight=sample_weight)

# Cell
def get_task_metrics(dls, binary_metrics=None, multi_class_metrics=None, regression_metrics=None, verbose=True):
    if dls.c == 2:
        pv('binary-classification task', verbose)
        return binary_metrics
    elif dls.c > 2:
        pv('multi-class task', verbose)
        return multi_class_metrics
    else:
        pv('regression task', verbose)
        return regression_metrics