# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetStudioResult',
    'AwaitableGetStudioResult',
    'get_studio',
    'get_studio_output',
]

@pulumi.output_type
class GetStudioResult:
    def __init__(__self__, admin_role_arn=None, display_name=None, home_region=None, sso_client_id=None, studio_encryption_configuration=None, studio_id=None, studio_url=None, user_role_arn=None):
        if admin_role_arn and not isinstance(admin_role_arn, str):
            raise TypeError("Expected argument 'admin_role_arn' to be a str")
        pulumi.set(__self__, "admin_role_arn", admin_role_arn)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if home_region and not isinstance(home_region, str):
            raise TypeError("Expected argument 'home_region' to be a str")
        pulumi.set(__self__, "home_region", home_region)
        if sso_client_id and not isinstance(sso_client_id, str):
            raise TypeError("Expected argument 'sso_client_id' to be a str")
        pulumi.set(__self__, "sso_client_id", sso_client_id)
        if studio_encryption_configuration and not isinstance(studio_encryption_configuration, dict):
            raise TypeError("Expected argument 'studio_encryption_configuration' to be a dict")
        pulumi.set(__self__, "studio_encryption_configuration", studio_encryption_configuration)
        if studio_id and not isinstance(studio_id, str):
            raise TypeError("Expected argument 'studio_id' to be a str")
        pulumi.set(__self__, "studio_id", studio_id)
        if studio_url and not isinstance(studio_url, str):
            raise TypeError("Expected argument 'studio_url' to be a str")
        pulumi.set(__self__, "studio_url", studio_url)
        if user_role_arn and not isinstance(user_role_arn, str):
            raise TypeError("Expected argument 'user_role_arn' to be a str")
        pulumi.set(__self__, "user_role_arn", user_role_arn)

    @property
    @pulumi.getter(name="adminRoleArn")
    def admin_role_arn(self) -> Optional[str]:
        """
        <p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>
        """
        return pulumi.get(self, "admin_role_arn")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        <p>A friendly name for the studio.</p>
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> Optional[str]:
        """
        <p>The Amazon Web Services Region where the studio resource is located.</p>
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter(name="ssoClientId")
    def sso_client_id(self) -> Optional[str]:
        """
        <p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>
        """
        return pulumi.get(self, "sso_client_id")

    @property
    @pulumi.getter(name="studioEncryptionConfiguration")
    def studio_encryption_configuration(self) -> Optional['outputs.StudioEncryptionConfiguration']:
        return pulumi.get(self, "studio_encryption_configuration")

    @property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> Optional[str]:
        return pulumi.get(self, "studio_id")

    @property
    @pulumi.getter(name="studioUrl")
    def studio_url(self) -> Optional[str]:
        """
        <p>The address of the web page for the studio.</p>
        """
        return pulumi.get(self, "studio_url")

    @property
    @pulumi.getter(name="userRoleArn")
    def user_role_arn(self) -> Optional[str]:
        """
        <p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>
        """
        return pulumi.get(self, "user_role_arn")


class AwaitableGetStudioResult(GetStudioResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStudioResult(
            admin_role_arn=self.admin_role_arn,
            display_name=self.display_name,
            home_region=self.home_region,
            sso_client_id=self.sso_client_id,
            studio_encryption_configuration=self.studio_encryption_configuration,
            studio_id=self.studio_id,
            studio_url=self.studio_url,
            user_role_arn=self.user_role_arn)


def get_studio(studio_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStudioResult:
    """
    Represents a studio that contains other Nimble Studio resources
    """
    __args__ = dict()
    __args__['studioId'] = studio_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:nimblestudio:getStudio', __args__, opts=opts, typ=GetStudioResult).value

    return AwaitableGetStudioResult(
        admin_role_arn=__ret__.admin_role_arn,
        display_name=__ret__.display_name,
        home_region=__ret__.home_region,
        sso_client_id=__ret__.sso_client_id,
        studio_encryption_configuration=__ret__.studio_encryption_configuration,
        studio_id=__ret__.studio_id,
        studio_url=__ret__.studio_url,
        user_role_arn=__ret__.user_role_arn)


@_utilities.lift_output_func(get_studio)
def get_studio_output(studio_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStudioResult]:
    """
    Represents a studio that contains other Nimble Studio resources
    """
    ...
