# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IPAMArgs', 'IPAM']

@pulumi.input_type
class IPAMArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMIpamOperatingRegionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMTagArgs']]]] = None):
        """
        The set of arguments for constructing a IPAM resource.
        :param pulumi.Input[Sequence[pulumi.Input['IPAMIpamOperatingRegionArgs']]] operating_regions: The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input['IPAMTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if operating_regions is not None:
            pulumi.set(__self__, "operating_regions", operating_regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPAMIpamOperatingRegionArgs']]]]:
        """
        The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @operating_regions.setter
    def operating_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMIpamOperatingRegionArgs']]]]):
        pulumi.set(self, "operating_regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPAMTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMTagArgs']]]]):
        pulumi.set(self, "tags", value)


class IPAM(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMIpamOperatingRegionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Schema of AWS::EC2::IPAM Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMIpamOperatingRegionArgs']]]] operating_regions: The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IPAMArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema of AWS::EC2::IPAM Type

        :param str resource_name: The name of the resource.
        :param IPAMArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IPAMArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMIpamOperatingRegionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IPAMArgs.__new__(IPAMArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["operating_regions"] = operating_regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["ipam_id"] = None
            __props__.__dict__["private_default_scope_id"] = None
            __props__.__dict__["public_default_scope_id"] = None
            __props__.__dict__["scope_count"] = None
        super(IPAM, __self__).__init__(
            'aws-native:ec2:IPAM',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IPAM':
        """
        Get an existing IPAM resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IPAMArgs.__new__(IPAMArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["ipam_id"] = None
        __props__.__dict__["operating_regions"] = None
        __props__.__dict__["private_default_scope_id"] = None
        __props__.__dict__["public_default_scope_id"] = None
        __props__.__dict__["scope_count"] = None
        __props__.__dict__["tags"] = None
        return IPAM(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> pulumi.Output[str]:
        """
        Id of the IPAM.
        """
        return pulumi.get(self, "ipam_id")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> pulumi.Output[Optional[Sequence['outputs.IPAMIpamOperatingRegion']]]:
        """
        The regions IPAM is enabled for. Allows pools to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> pulumi.Output[str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "private_default_scope_id")

    @property
    @pulumi.getter(name="publicDefaultScopeId")
    def public_default_scope_id(self) -> pulumi.Output[str]:
        """
        The Id of the default scope for publicly routable IP space, created with this IPAM.
        """
        return pulumi.get(self, "public_default_scope_id")

    @property
    @pulumi.getter(name="scopeCount")
    def scope_count(self) -> pulumi.Output[int]:
        """
        The number of scopes that currently exist in this IPAM.
        """
        return pulumi.get(self, "scope_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.IPAMTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

