# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetTypeActivationResult',
    'AwaitableGetTypeActivationResult',
    'get_type_activation',
    'get_type_activation_output',
]

@pulumi.output_type
class GetTypeActivationResult:
    def __init__(__self__, arn=None, auto_update=None, major_version=None, version_bump=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_update and not isinstance(auto_update, bool):
            raise TypeError("Expected argument 'auto_update' to be a bool")
        pulumi.set(__self__, "auto_update", auto_update)
        if major_version and not isinstance(major_version, str):
            raise TypeError("Expected argument 'major_version' to be a str")
        pulumi.set(__self__, "major_version", major_version)
        if version_bump and not isinstance(version_bump, str):
            raise TypeError("Expected argument 'version_bump' to be a str")
        pulumi.set(__self__, "version_bump", version_bump)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the extension.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[bool]:
        """
        Whether to automatically update the extension in this account and region when a new minor version is published by the extension publisher. Major versions released by the publisher must be manually updated.
        """
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> Optional[str]:
        """
        The Major Version of the type you want to enable
        """
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="versionBump")
    def version_bump(self) -> Optional['TypeActivationVersionBump']:
        """
        Manually updates a previously-enabled type to a new major or minor version, if available. You can also use this parameter to update the value of AutoUpdateEnabled
        """
        return pulumi.get(self, "version_bump")


class AwaitableGetTypeActivationResult(GetTypeActivationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTypeActivationResult(
            arn=self.arn,
            auto_update=self.auto_update,
            major_version=self.major_version,
            version_bump=self.version_bump)


def get_type_activation(arn: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTypeActivationResult:
    """
    Enable a resource that has been published in the CloudFormation Registry.


    :param str arn: The Amazon Resource Name (ARN) of the extension.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudformation:getTypeActivation', __args__, opts=opts, typ=GetTypeActivationResult).value

    return AwaitableGetTypeActivationResult(
        arn=__ret__.arn,
        auto_update=__ret__.auto_update,
        major_version=__ret__.major_version,
        version_bump=__ret__.version_bump)


@_utilities.lift_output_func(get_type_activation)
def get_type_activation_output(arn: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTypeActivationResult]:
    """
    Enable a resource that has been published in the CloudFormation Registry.


    :param str arn: The Amazon Resource Name (ARN) of the extension.
    """
    ...
