# RA, 2021-03-16

import matplotlib.pyplot
import pathlib
import contextlib


def main():
    tree = {}

    def cap(t: str):
        return t[0].upper() + t[1:]

    for (k, v) in sorted(dict(matplotlib.pyplot.rcParams).items()):
        kk = k.split('.')
        [kk, leaf] = [list(map(cap, kk[0:-1])), kk[-1]]

        node = tree
        for c in kk:
            if c not in node:
                node[c] = {}
            node = node[c]

        leaf = leaf.replace('-', '_')

        node[leaf] = f"'{k}' # {repr(v)}"

    def out(name, tree: dict, indent=0):
        tabs = '\t' * indent
        print(f"{tabs}class {name}:")
        indent += 1
        for (k, v) in tree.items():
            if isinstance(v, dict):
                out(k, v, indent)
            else:
                tabs = '\t' * indent
                print(f"{tabs}{k} = {v}")

    with open("param.py", mode='w') as fd:
        with contextlib.redirect_stdout(fd):
            print(f"# autogenerated with {pathlib.Path(__file__).name}")
            print("")
            out("rcParam", tree)


if __name__ == '__main__':
    main()

