<img align="right" src="https://raw.githubusercontent.com/radish-bdd/radish/master/artwork/radish-bdd-logo-trans-bg.png">

# radish - the root from red to green
> Awesome python BDD tool http://radish-bdd.io

***

[![PyPI License](https://img.shields.io/pypi/l/radish-bdd.svg)](https://github.com/radish-bdd/radish/blob/master/LICENSE)
[![Gitter](https://badges.gitter.im/radish-bdd/radish.svg)](https://gitter.im/radish-bdd/radish?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
<br>
[![Actions Status](https://github.com/radish-bdd/radish/workflows/CI/badge.svg)](https://github.com/radish-bdd/radish/actions?branch=stable)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)
<br>
[![PyPI version](https://badge.fury.io/py/radish-bdd.svg)](https://badge.fury.io/py/radish-bdd)
[![PyPI](https://img.shields.io/pypi/pyversions/radish-bdd.svg)](https://pypi.python.org/pypi/radish-bdd)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/radish-bdd)](https://pypi.python.org/pypi/radish-bdd)
[![PyPI](https://img.shields.io/pypi/wheel/radish-bdd.svg)](https://pypi.python.org/pypi/radish-bdd)

***

# What is radish?

radish is a Behavior Driven Development tool completely written in python.
It supports all *gherkin* language features.
In addition to that, radish implements a few *unconventional* BDD features such as **Preconditions**, **Scenario Loops**, **Constants** and **Expressions**.

# Supported platforms

radish is supported on Windows, Mac and Linux

# Installation

radish is available as `pip` package:

```bash
pip install radish-bdd
```
**Note**: Make sure you have enough privileges to install radish on your system.

# Getting started

radish is very easy to use. Take the 5 minutes and follow the *Getting started* instruction on the radish website: http://radish-bdd.io/#gettingstarted

# Documentation

The whole documentation of radish is available on [Read The Docs](http://radish.readthedocs.org).

# Contribution

Yes, we are looking for some contributors and people who spread out a word about radish.
Help us to improve these piece of software. You don't know what to do?
Just have a look at the Issues or create a new one.
Please have a look at the [Contributing Guidelines](https://github.com/radish-bdd/radish/blob/master/CONTRIBUTING.md), too.

# Release

```
vim CHANGELOG.md docs/conf.py radish/__init__.py
git commit -am "release: x.x.x" && git tag x.x.x
rm -rf dist
python3 setup.py sdist bdist_wheel
python3 -m twine upload dist/*
```

# Special Thanks

A special thanks goes to [Hassan Ashraf](mailto:info@cyberavanza.com) from the company [Cyber Avanza](http://www.cyberavanza.com) for creating an awesome logo for free! I really appreciate their work and time!

***

*<p align="center">This project is published under [MIT](LICENSE).<br>A [Timo Furrer](https://tuxtimo.me) project.<br>- :tada: -</p>*
