## Introduction

CommonMark Website (CMW) is a command-line utility designed to simplify the
creation and management of websites using markdown files. It eliminates the
repetitive task of updating raw HTML pages by allowing you to configure your
site through `config.yaml` and generate HTML automatically.

## Getting started

Installation:

    pip install cmw

Initializing a new project:

    mkdir my-project
    cd my-project
    cmw init

This creates two files: config.yaml, and index.md. Edit them as you see fit.

You can preview the site by running:

    cmw server

Doing this will convert the markdown files into HTML and launch a development
server for live viewing in your browser. If you just want to generate HTML
files without a server, run `cmw` without any arguments.

## Syntax

### 1. Section Wrapping from H2 to the next H2

When rendering markdown, any content starting from an H2 (##) heading up to the
next H2 will be automatically wrapped in a `<section>` tag. This enables
logical grouping of content for better structure and styling.

Example:

    ## Section 1

    Some content here.

    ### Subheading

    More content here.

    ## Section 2

    New section content here.

Output:

    <section id="section-1">
        <h2>Section 1</h2>
        <p>Some content here.</p>
        <h3>Subheading</h3>
        <p>More content here.</p>
    </section>
    <section id="section-2">
        <h2>Section 2</h2>
        <p>New section content here.</p>
    </section>

Note that the id of the section is automatically generated by lowercasing the
alphanumeric parts of the H2 section title and then joining with dashes (-).

### 2. Class wrapping

You can wrap any text inside a div with with a custom class by using the
following syntax:

    .center: This text will be centered.

    .center:
        This paragraph will be centered.

        And so will this paragraph.

The above example will output the following code:

    <div class="center">
        This text will be centered.
    </div>
    <div>
        <p>This paragraph will be centered.</p>

        <p>And so will this paragraph.</p>
    </div>

Divs with custom classes can be nested, for example:

    .box: .center: This is nested inside multiple divs.

Or classes can be combined in a single div, for example:

    .highlight.center.tags: HTML, CSS, Python, Markdown

You can use any class name, but there are three in-built class names with
custom behaviour: .center, .tags, and .box.

### 3. Tags

`.tags` will style some comma-separated tags each with a light grey background.

Example:

    .tags: HTML, CSS, YAML, Markdown

Will render as:

.tags: HTML, CSS, YAML, Markdown

### 3. Box Layout (3-Column Responsive)

You can use the box: directive to wrap content inside a box, which will be part
of a responsive 3-column layout.

Example:

    .box:
        !/project-1-logo.png

        ### Project 1

        Description of project 1
    .box:
        !/project-2-logo.png

        ### Project 2

        Description of project 2
    .box:
        !/project-3-logo.png

        ### Project 3

        Description of project 3

Output:

    <div class='boxes'>
        <div class='box'>
            <img src="!/project-1-logo.png" />
            <h3>Project 1</h3>
            <p>Description of project 1</p>
        </div>
        <div class='box'>
            <img src="!/project-2-logo.png" />
            <h3>Project 2</h3>
            <p>Description of project 2</p>
        </div>
        <div class='box'>
            <img src="!/project-3-logo.png" />
            <h3>Project 3</h3>
            <p>Description of project 3</p>
        </div>
    </div>

### 4. img replacement

To include an image, just write it's pathname ending in .webp, .jpg, or .png.

Example:

    center: !/path/to/my/image.png

Output:

    <div class="center">
       <img src="!/path/to/my/image.png" />
    </div>

To output the actual pathname, prefix it with an exclamation mark.

Example:

    The file can be found at !!/path/to/my/image.png

Output:

    <p>The file can be found at !/path/to/my/image.png</p>
