# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['VPCRouter']


class VPCRouter(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dhcp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpServerArgs']]]]] = None,
                 dhcp_static_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpStaticMappingArgs']]]]] = None,
                 firewalls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterFirewallArgs']]]]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 internet_connection: Optional[pulumi.Input[bool]] = None,
                 l2tp: Optional[pulumi.Input[pulumi.InputType['VPCRouterL2tpArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 port_forwardings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPortForwardingArgs']]]]] = None,
                 pptp: Optional[pulumi.Input[pulumi.InputType['VPCRouterPptpArgs']]] = None,
                 private_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPrivateNetworkInterfaceArgs']]]]] = None,
                 public_network_interface: Optional[pulumi.Input[pulumi.InputType['VPCRouterPublicNetworkInterfaceArgs']]] = None,
                 site_to_site_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterSiteToSiteVpnArgs']]]]] = None,
                 static_nats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticNatArgs']]]]] = None,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticRouteArgs']]]]] = None,
                 syslog_host: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterUserArgs']]]]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud VPC Router.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        standard = sakuracloud.VPCRouter("standard",
            description="description",
            tags=[
                "tag1",
                "tag2",
            ],
            internet_connection=True)
        foobar_internet = sakuracloud.Internet("foobarInternet")
        foobar_switch = sakuracloud.Switch("foobarSwitch")
        premium = sakuracloud.VPCRouter("premium",
            description="description",
            tags=[
                "tag1",
                "tag2",
            ],
            plan="premium",
            internet_connection=True,
            public_network_interface=sakuracloud.VPCRouterPublicNetworkInterfaceArgs(
                switch_id=foobar_internet.switch_id,
                vip=foobar_internet.ip_addresses[0],
                ip_addresses=[
                    foobar_internet.ip_addresses[1],
                    foobar_internet.ip_addresses[2],
                ],
                aliases=[foobar_internet.ip_addresses[3]],
                vrid=1,
            ),
            private_network_interfaces=[sakuracloud.VPCRouterPrivateNetworkInterfaceArgs(
                index=1,
                switch_id=foobar_switch.id,
                vip="192.168.11.1",
                ip_addresses=[
                    "192.168.11.2",
                    "192.168.11.3",
                ],
                netmask=24,
            )],
            dhcp_servers=[sakuracloud.VPCRouterDhcpServerArgs(
                interface_index=1,
                range_start="192.168.11.11",
                range_stop="192.168.11.20",
                dns_servers=[
                    "8.8.8.8",
                    "8.8.4.4",
                ],
            )],
            dhcp_static_mappings=[sakuracloud.VPCRouterDhcpStaticMappingArgs(
                ip_address="192.168.11.10",
                mac_address="aa:bb:cc:aa:bb:cc",
            )],
            firewalls=[sakuracloud.VPCRouterFirewallArgs(
                interface_index=1,
                direction="send",
                expressions=[
                    sakuracloud.VPCRouterFirewallExpressionArgs(
                        protocol="tcp",
                        source_network="",
                        source_port="80",
                        destination_network="",
                        destination_port="",
                        allow=True,
                        logging=True,
                        description="desc",
                    ),
                    sakuracloud.VPCRouterFirewallExpressionArgs(
                        protocol="ip",
                        source_network="",
                        source_port="",
                        destination_network="",
                        destination_port="",
                        allow=False,
                        logging=True,
                        description="desc",
                    ),
                ],
            )],
            l2tp=sakuracloud.VPCRouterL2tpArgs(
                pre_shared_secret="example",
                range_start="192.168.11.21",
                range_stop="192.168.11.30",
            ),
            port_forwardings=[sakuracloud.VPCRouterPortForwardingArgs(
                protocol="udp",
                public_port=10022,
                private_ip="192.168.11.11",
                private_port=22,
                description="desc",
            )],
            pptp=sakuracloud.VPCRouterPptpArgs(
                range_start="192.168.11.31",
                range_stop="192.168.11.40",
            ),
            site_to_site_vpns=[sakuracloud.VPCRouterSiteToSiteVpnArgs(
                peer="10.0.0.1",
                remote_id="10.0.0.1",
                pre_shared_secret="example",
                routes=["10.0.0.0/8"],
                local_prefixes=["192.168.21.0/24"],
            )],
            static_nats=[sakuracloud.VPCRouterStaticNatArgs(
                public_ip=foobar_internet.ip_addresses[3],
                private_ip="192.168.11.12",
                description="desc",
            )],
            static_routes=[sakuracloud.VPCRouterStaticRouteArgs(
                prefix="172.16.0.0/16",
                next_hop="192.168.11.99",
            )],
            users=[sakuracloud.VPCRouterUserArgs(
                name="username",
                password="password",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the expression. The length of this value must be in the range [`0`-`512`].
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpServerArgs']]]] dhcp_servers: One or more `dhcp_server` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpStaticMappingArgs']]]] dhcp_static_mappings: One or more `dhcp_static_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterFirewallArgs']]]] firewalls: One or more `firewall` blocks as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the VPCRouter.
        :param pulumi.Input[bool] internet_connection: The flag to enable connecting to the Internet from the VPC Router. Default:`true`.
        :param pulumi.Input[pulumi.InputType['VPCRouterL2tpArgs']] l2tp: A `l2tp` block as defined below.
        :param pulumi.Input[str] name: The name of the VPCRouter. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] plan: The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]. Changing this forces a new resource to be created. Default:`standard`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPortForwardingArgs']]]] port_forwardings: One or more `port_forwarding` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['VPCRouterPptpArgs']] pptp: A `pptp` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPrivateNetworkInterfaceArgs']]]] private_network_interfaces: A list of additional network interface setting. This doesn't include primary network interface setting.
        :param pulumi.Input[pulumi.InputType['VPCRouterPublicNetworkInterfaceArgs']] public_network_interface: An `public_network_interface` block as defined below. This block is required when `plan` is not `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterSiteToSiteVpnArgs']]]] site_to_site_vpns: One or more `site_to_site_vpn` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticNatArgs']]]] static_nats: One or more `static_nat` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticRouteArgs']]]] static_routes: One or more `static_route` blocks as defined below.
        :param pulumi.Input[str] syslog_host: The ip address of the syslog host to which the VPC Router sends logs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the VPCRouter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterUserArgs']]]] users: One or more `user` blocks as defined below.
        :param pulumi.Input[int] version: The version of the VPC Router. Changing this forces a new resource to be created. Default:`2`.
        :param pulumi.Input[str] zone: The name of zone that the VPCRouter will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['dhcp_servers'] = dhcp_servers
            __props__['dhcp_static_mappings'] = dhcp_static_mappings
            __props__['firewalls'] = firewalls
            __props__['icon_id'] = icon_id
            __props__['internet_connection'] = internet_connection
            __props__['l2tp'] = l2tp
            __props__['name'] = name
            __props__['plan'] = plan
            __props__['port_forwardings'] = port_forwardings
            __props__['pptp'] = pptp
            __props__['private_network_interfaces'] = private_network_interfaces
            __props__['public_network_interface'] = public_network_interface
            __props__['site_to_site_vpns'] = site_to_site_vpns
            __props__['static_nats'] = static_nats
            __props__['static_routes'] = static_routes
            __props__['syslog_host'] = syslog_host
            __props__['tags'] = tags
            __props__['users'] = users
            __props__['version'] = version
            __props__['zone'] = zone
            __props__['public_ip'] = None
            __props__['public_netmask'] = None
        super(VPCRouter, __self__).__init__(
            'sakuracloud:index/vPCRouter:VPCRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            dhcp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpServerArgs']]]]] = None,
            dhcp_static_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpStaticMappingArgs']]]]] = None,
            firewalls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterFirewallArgs']]]]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            internet_connection: Optional[pulumi.Input[bool]] = None,
            l2tp: Optional[pulumi.Input[pulumi.InputType['VPCRouterL2tpArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            port_forwardings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPortForwardingArgs']]]]] = None,
            pptp: Optional[pulumi.Input[pulumi.InputType['VPCRouterPptpArgs']]] = None,
            private_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPrivateNetworkInterfaceArgs']]]]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            public_netmask: Optional[pulumi.Input[int]] = None,
            public_network_interface: Optional[pulumi.Input[pulumi.InputType['VPCRouterPublicNetworkInterfaceArgs']]] = None,
            site_to_site_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterSiteToSiteVpnArgs']]]]] = None,
            static_nats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticNatArgs']]]]] = None,
            static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticRouteArgs']]]]] = None,
            syslog_host: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterUserArgs']]]]] = None,
            version: Optional[pulumi.Input[int]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'VPCRouter':
        """
        Get an existing VPCRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the expression. The length of this value must be in the range [`0`-`512`].
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpServerArgs']]]] dhcp_servers: One or more `dhcp_server` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterDhcpStaticMappingArgs']]]] dhcp_static_mappings: One or more `dhcp_static_mapping` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterFirewallArgs']]]] firewalls: One or more `firewall` blocks as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the VPCRouter.
        :param pulumi.Input[bool] internet_connection: The flag to enable connecting to the Internet from the VPC Router. Default:`true`.
        :param pulumi.Input[pulumi.InputType['VPCRouterL2tpArgs']] l2tp: A `l2tp` block as defined below.
        :param pulumi.Input[str] name: The name of the VPCRouter. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] plan: The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]. Changing this forces a new resource to be created. Default:`standard`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPortForwardingArgs']]]] port_forwardings: One or more `port_forwarding` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['VPCRouterPptpArgs']] pptp: A `pptp` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterPrivateNetworkInterfaceArgs']]]] private_network_interfaces: A list of additional network interface setting. This doesn't include primary network interface setting.
        :param pulumi.Input[str] public_ip: The public IP address used for the static NAT.
        :param pulumi.Input[int] public_netmask: The bit length of the subnet to assign to the public network interface.
        :param pulumi.Input[pulumi.InputType['VPCRouterPublicNetworkInterfaceArgs']] public_network_interface: An `public_network_interface` block as defined below. This block is required when `plan` is not `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterSiteToSiteVpnArgs']]]] site_to_site_vpns: One or more `site_to_site_vpn` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticNatArgs']]]] static_nats: One or more `static_nat` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterStaticRouteArgs']]]] static_routes: One or more `static_route` blocks as defined below.
        :param pulumi.Input[str] syslog_host: The ip address of the syslog host to which the VPC Router sends logs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the VPCRouter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPCRouterUserArgs']]]] users: One or more `user` blocks as defined below.
        :param pulumi.Input[int] version: The version of the VPC Router. Changing this forces a new resource to be created. Default:`2`.
        :param pulumi.Input[str] zone: The name of zone that the VPCRouter will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["dhcp_servers"] = dhcp_servers
        __props__["dhcp_static_mappings"] = dhcp_static_mappings
        __props__["firewalls"] = firewalls
        __props__["icon_id"] = icon_id
        __props__["internet_connection"] = internet_connection
        __props__["l2tp"] = l2tp
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["port_forwardings"] = port_forwardings
        __props__["pptp"] = pptp
        __props__["private_network_interfaces"] = private_network_interfaces
        __props__["public_ip"] = public_ip
        __props__["public_netmask"] = public_netmask
        __props__["public_network_interface"] = public_network_interface
        __props__["site_to_site_vpns"] = site_to_site_vpns
        __props__["static_nats"] = static_nats
        __props__["static_routes"] = static_routes
        __props__["syslog_host"] = syslog_host
        __props__["tags"] = tags
        __props__["users"] = users
        __props__["version"] = version
        __props__["zone"] = zone
        return VPCRouter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the expression. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dhcpServers")
    def dhcp_servers(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterDhcpServer']]]:
        """
        One or more `dhcp_server` blocks as defined below.
        """
        return pulumi.get(self, "dhcp_servers")

    @property
    @pulumi.getter(name="dhcpStaticMappings")
    def dhcp_static_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterDhcpStaticMapping']]]:
        """
        One or more `dhcp_static_mapping` blocks as defined below.
        """
        return pulumi.get(self, "dhcp_static_mappings")

    @property
    @pulumi.getter
    def firewalls(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterFirewall']]]:
        """
        One or more `firewall` blocks as defined below.
        """
        return pulumi.get(self, "firewalls")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the VPCRouter.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="internetConnection")
    def internet_connection(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable connecting to the Internet from the VPC Router. Default:`true`.
        """
        return pulumi.get(self, "internet_connection")

    @property
    @pulumi.getter
    def l2tp(self) -> pulumi.Output[Optional['outputs.VPCRouterL2tp']]:
        """
        A `l2tp` block as defined below.
        """
        return pulumi.get(self, "l2tp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the VPCRouter. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]. Changing this forces a new resource to be created. Default:`standard`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="portForwardings")
    def port_forwardings(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterPortForwarding']]]:
        """
        One or more `port_forwarding` blocks as defined below.
        """
        return pulumi.get(self, "port_forwardings")

    @property
    @pulumi.getter
    def pptp(self) -> pulumi.Output[Optional['outputs.VPCRouterPptp']]:
        """
        A `pptp` block as defined below.
        """
        return pulumi.get(self, "pptp")

    @property
    @pulumi.getter(name="privateNetworkInterfaces")
    def private_network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterPrivateNetworkInterface']]]:
        """
        A list of additional network interface setting. This doesn't include primary network interface setting.
        """
        return pulumi.get(self, "private_network_interfaces")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public IP address used for the static NAT.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicNetmask")
    def public_netmask(self) -> pulumi.Output[int]:
        """
        The bit length of the subnet to assign to the public network interface.
        """
        return pulumi.get(self, "public_netmask")

    @property
    @pulumi.getter(name="publicNetworkInterface")
    def public_network_interface(self) -> pulumi.Output[Optional['outputs.VPCRouterPublicNetworkInterface']]:
        """
        An `public_network_interface` block as defined below. This block is required when `plan` is not `standard`.
        """
        return pulumi.get(self, "public_network_interface")

    @property
    @pulumi.getter(name="siteToSiteVpns")
    def site_to_site_vpns(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterSiteToSiteVpn']]]:
        """
        One or more `site_to_site_vpn` blocks as defined below.
        """
        return pulumi.get(self, "site_to_site_vpns")

    @property
    @pulumi.getter(name="staticNats")
    def static_nats(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterStaticNat']]]:
        """
        One or more `static_nat` blocks as defined below.
        """
        return pulumi.get(self, "static_nats")

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterStaticRoute']]]:
        """
        One or more `static_route` blocks as defined below.
        """
        return pulumi.get(self, "static_routes")

    @property
    @pulumi.getter(name="syslogHost")
    def syslog_host(self) -> pulumi.Output[Optional[str]]:
        """
        The ip address of the syslog host to which the VPC Router sends logs.
        """
        return pulumi.get(self, "syslog_host")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the VPCRouter.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.VPCRouterUser']]]:
        """
        One or more `user` blocks as defined below.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[int]]:
        """
        The version of the VPC Router. Changing this forces a new resource to be created. Default:`2`.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the VPCRouter will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

