# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['SimpleMonitor']


class SimpleMonitor(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delay_loop: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['SimpleMonitorHealthCheckArgs']]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 notify_email_enabled: Optional[pulumi.Input[bool]] = None,
                 notify_email_html: Optional[pulumi.Input[bool]] = None,
                 notify_interval: Optional[pulumi.Input[int]] = None,
                 notify_slack_enabled: Optional[pulumi.Input[bool]] = None,
                 notify_slack_webhook: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Simple Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar = sakuracloud.SimpleMonitor("foobar",
            delay_loop=60,
            description="description",
            health_check=sakuracloud.SimpleMonitorHealthCheckArgs(
                contains_string="ok",
                host_header="example.com",
                http2=True,
                path="/",
                port=443,
                protocol="https",
                sni=True,
                status=200,
            ),
            notify_email_enabled=True,
            notify_email_html=True,
            notify_slack_enabled=True,
            notify_slack_webhook="https://hooks.slack.com/services/xxx/xxx/xxx",
            tags=[
                "tag1",
                "tag2",
            ],
            target="www.example.com")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] delay_loop: The interval in seconds between checks. This must be in the range [`60`-`3600`]. Default:`60`.
        :param pulumi.Input[str] description: The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] enabled: The flag to enable monitoring by the simple monitor. Default:`true`.
        :param pulumi.Input[pulumi.InputType['SimpleMonitorHealthCheckArgs']] health_check: A `health_check` block as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the SimpleMonitor.
        :param pulumi.Input[bool] notify_email_enabled: The flag to enable notification by email. Default:`true`.
        :param pulumi.Input[bool] notify_email_html: The flag to enable HTML format instead of text format.
        :param pulumi.Input[int] notify_interval: The interval in hours between notification. This must be in the range [`1`-`72`]. Default:`2`.
        :param pulumi.Input[bool] notify_slack_enabled: The flag to enable notification by slack/discord.
        :param pulumi.Input[str] notify_slack_webhook: The webhook URL for sending notification by slack/discord.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the SimpleMonitor.
        :param pulumi.Input[str] target: The monitoring target of the simple monitor. This must be IP address or FQDN. Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['delay_loop'] = delay_loop
            __props__['description'] = description
            __props__['enabled'] = enabled
            if health_check is None and not opts.urn:
                raise TypeError("Missing required property 'health_check'")
            __props__['health_check'] = health_check
            __props__['icon_id'] = icon_id
            __props__['notify_email_enabled'] = notify_email_enabled
            __props__['notify_email_html'] = notify_email_html
            __props__['notify_interval'] = notify_interval
            __props__['notify_slack_enabled'] = notify_slack_enabled
            __props__['notify_slack_webhook'] = notify_slack_webhook
            __props__['tags'] = tags
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__['target'] = target
        super(SimpleMonitor, __self__).__init__(
            'sakuracloud:index/simpleMonitor:SimpleMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delay_loop: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['SimpleMonitorHealthCheckArgs']]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            notify_email_enabled: Optional[pulumi.Input[bool]] = None,
            notify_email_html: Optional[pulumi.Input[bool]] = None,
            notify_interval: Optional[pulumi.Input[int]] = None,
            notify_slack_enabled: Optional[pulumi.Input[bool]] = None,
            notify_slack_webhook: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target: Optional[pulumi.Input[str]] = None) -> 'SimpleMonitor':
        """
        Get an existing SimpleMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] delay_loop: The interval in seconds between checks. This must be in the range [`60`-`3600`]. Default:`60`.
        :param pulumi.Input[str] description: The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] enabled: The flag to enable monitoring by the simple monitor. Default:`true`.
        :param pulumi.Input[pulumi.InputType['SimpleMonitorHealthCheckArgs']] health_check: A `health_check` block as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the SimpleMonitor.
        :param pulumi.Input[bool] notify_email_enabled: The flag to enable notification by email. Default:`true`.
        :param pulumi.Input[bool] notify_email_html: The flag to enable HTML format instead of text format.
        :param pulumi.Input[int] notify_interval: The interval in hours between notification. This must be in the range [`1`-`72`]. Default:`2`.
        :param pulumi.Input[bool] notify_slack_enabled: The flag to enable notification by slack/discord.
        :param pulumi.Input[str] notify_slack_webhook: The webhook URL for sending notification by slack/discord.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the SimpleMonitor.
        :param pulumi.Input[str] target: The monitoring target of the simple monitor. This must be IP address or FQDN. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["delay_loop"] = delay_loop
        __props__["description"] = description
        __props__["enabled"] = enabled
        __props__["health_check"] = health_check
        __props__["icon_id"] = icon_id
        __props__["notify_email_enabled"] = notify_email_enabled
        __props__["notify_email_html"] = notify_email_html
        __props__["notify_interval"] = notify_interval
        __props__["notify_slack_enabled"] = notify_slack_enabled
        __props__["notify_slack_webhook"] = notify_slack_webhook
        __props__["tags"] = tags
        __props__["target"] = target
        return SimpleMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> pulumi.Output[Optional[int]]:
        """
        The interval in seconds between checks. This must be in the range [`60`-`3600`]. Default:`60`.
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the SimpleMonitor. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable monitoring by the simple monitor. Default:`true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.SimpleMonitorHealthCheck']:
        """
        A `health_check` block as defined below.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the SimpleMonitor.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="notifyEmailEnabled")
    def notify_email_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable notification by email. Default:`true`.
        """
        return pulumi.get(self, "notify_email_enabled")

    @property
    @pulumi.getter(name="notifyEmailHtml")
    def notify_email_html(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable HTML format instead of text format.
        """
        return pulumi.get(self, "notify_email_html")

    @property
    @pulumi.getter(name="notifyInterval")
    def notify_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval in hours between notification. This must be in the range [`1`-`72`]. Default:`2`.
        """
        return pulumi.get(self, "notify_interval")

    @property
    @pulumi.getter(name="notifySlackEnabled")
    def notify_slack_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable notification by slack/discord.
        """
        return pulumi.get(self, "notify_slack_enabled")

    @property
    @pulumi.getter(name="notifySlackWebhook")
    def notify_slack_webhook(self) -> pulumi.Output[Optional[str]]:
        """
        The webhook URL for sending notification by slack/discord.
        """
        return pulumi.get(self, "notify_slack_webhook")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the SimpleMonitor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[str]:
        """
        The monitoring target of the simple monitor. This must be IP address or FQDN. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

