# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Server']


class Server(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdrom_id: Optional[pulumi.Input[str]] = None,
                 commitment: Optional[pulumi.Input[str]] = None,
                 core: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_edit_parameter: Optional[pulumi.Input[pulumi.InputType['ServerDiskEditParameterArgs']]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_shutdown: Optional[pulumi.Input[bool]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 interface_driver: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkInterfaceArgs']]]]] = None,
                 private_host_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar_packet_filter = sakuracloud.get_packet_filter(filter=sakuracloud.GetPacketFilterFilterArgs(
            names=["foobar"],
        ))
        ubuntu = sakuracloud.get_archive(os_type="ubuntu2004")
        foobar_disk = sakuracloud.Disk("foobarDisk", source_archive_id=ubuntu.id)
        foobar_server = sakuracloud.Server("foobarServer",
            disks=[foobar_disk.id],
            description="description",
            tags=[
                "tag1",
                "tag2",
            ],
            network_interfaces=[sakuracloud.ServerNetworkInterfaceArgs(
                upstream="shared",
                packet_filter_id=foobar_packet_filter.id,
            )],
            disk_edit_parameter=sakuracloud.ServerDiskEditParameterArgs(
                hostname="hostname",
                password="password",
                disable_pw_auth=True,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cdrom_id: The id of the CD-ROM to attach to the Server.
        :param pulumi.Input[str] commitment: The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]. Default:`standard`.
        :param pulumi.Input[int] core: The number of virtual CPUs. Default:`1`.
        :param pulumi.Input[str] description: The description of the Server. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[pulumi.InputType['ServerDiskEditParameterArgs']] disk_edit_parameter: A `disk_edit_parameter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks: A list of disk id connected to the server.
        :param pulumi.Input[bool] force_shutdown: The flag to use force shutdown when need to reboot/shutdown while applying.
        :param pulumi.Input[str] icon_id: The icon id to attach to the Server.
        :param pulumi.Input[str] interface_driver: The driver name of network interface. This must be one of [`virtio`/`e1000`]. Default:`virtio`.
        :param pulumi.Input[int] memory: The size of memory in GiB. Default:`1`.
        :param pulumi.Input[str] name: The name of the Server. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkInterfaceArgs']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[str] private_host_id: The id of the PrivateHost which the Server is assigned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Server.
        :param pulumi.Input[str] zone: The name of zone that the Server will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cdrom_id'] = cdrom_id
            __props__['commitment'] = commitment
            __props__['core'] = core
            __props__['description'] = description
            __props__['disk_edit_parameter'] = disk_edit_parameter
            __props__['disks'] = disks
            __props__['force_shutdown'] = force_shutdown
            __props__['icon_id'] = icon_id
            __props__['interface_driver'] = interface_driver
            __props__['memory'] = memory
            __props__['name'] = name
            __props__['network_interfaces'] = network_interfaces
            __props__['private_host_id'] = private_host_id
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['dns_servers'] = None
            __props__['gateway'] = None
            __props__['hostname'] = None
            __props__['ip_address'] = None
            __props__['netmask'] = None
            __props__['network_address'] = None
            __props__['private_host_name'] = None
        super(Server, __self__).__init__(
            'sakuracloud:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdrom_id: Optional[pulumi.Input[str]] = None,
            commitment: Optional[pulumi.Input[str]] = None,
            core: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_edit_parameter: Optional[pulumi.Input[pulumi.InputType['ServerDiskEditParameterArgs']]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_shutdown: Optional[pulumi.Input[bool]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            interface_driver: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            memory: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            netmask: Optional[pulumi.Input[int]] = None,
            network_address: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkInterfaceArgs']]]]] = None,
            private_host_id: Optional[pulumi.Input[str]] = None,
            private_host_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cdrom_id: The id of the CD-ROM to attach to the Server.
        :param pulumi.Input[str] commitment: The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]. Default:`standard`.
        :param pulumi.Input[int] core: The number of virtual CPUs. Default:`1`.
        :param pulumi.Input[str] description: The description of the Server. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[pulumi.InputType['ServerDiskEditParameterArgs']] disk_edit_parameter: A `disk_edit_parameter` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks: A list of disk id connected to the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: A list of IP address of DNS server in the zone.
        :param pulumi.Input[bool] force_shutdown: The flag to use force shutdown when need to reboot/shutdown while applying.
        :param pulumi.Input[str] gateway: The gateway address used by the Server.
        :param pulumi.Input[str] hostname: The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Server.
        :param pulumi.Input[str] interface_driver: The driver name of network interface. This must be one of [`virtio`/`e1000`]. Default:`virtio`.
        :param pulumi.Input[str] ip_address: The IP address to assign to the Server.
        :param pulumi.Input[int] memory: The size of memory in GiB. Default:`1`.
        :param pulumi.Input[str] name: The name of the Server. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the Server.
        :param pulumi.Input[str] network_address: The network address which the `ip_address` belongs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerNetworkInterfaceArgs']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[str] private_host_id: The id of the PrivateHost which the Server is assigned.
        :param pulumi.Input[str] private_host_name: The id of the PrivateHost which the Server is assigned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Server.
        :param pulumi.Input[str] zone: The name of zone that the Server will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cdrom_id"] = cdrom_id
        __props__["commitment"] = commitment
        __props__["core"] = core
        __props__["description"] = description
        __props__["disk_edit_parameter"] = disk_edit_parameter
        __props__["disks"] = disks
        __props__["dns_servers"] = dns_servers
        __props__["force_shutdown"] = force_shutdown
        __props__["gateway"] = gateway
        __props__["hostname"] = hostname
        __props__["icon_id"] = icon_id
        __props__["interface_driver"] = interface_driver
        __props__["ip_address"] = ip_address
        __props__["memory"] = memory
        __props__["name"] = name
        __props__["netmask"] = netmask
        __props__["network_address"] = network_address
        __props__["network_interfaces"] = network_interfaces
        __props__["private_host_id"] = private_host_id
        __props__["private_host_name"] = private_host_name
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cdromId")
    def cdrom_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the CD-ROM to attach to the Server.
        """
        return pulumi.get(self, "cdrom_id")

    @property
    @pulumi.getter
    def commitment(self) -> pulumi.Output[Optional[str]]:
        """
        The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]. Default:`standard`.
        """
        return pulumi.get(self, "commitment")

    @property
    @pulumi.getter
    def core(self) -> pulumi.Output[Optional[int]]:
        """
        The number of virtual CPUs. Default:`1`.
        """
        return pulumi.get(self, "core")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Server. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEditParameter")
    def disk_edit_parameter(self) -> pulumi.Output[Optional['outputs.ServerDiskEditParameter']]:
        """
        A `disk_edit_parameter` block as defined below.
        """
        return pulumi.get(self, "disk_edit_parameter")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of disk id connected to the server.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IP address of DNS server in the zone.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="forceShutdown")
    def force_shutdown(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to use force shutdown when need to reboot/shutdown while applying.
        """
        return pulumi.get(self, "force_shutdown")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        """
        The gateway address used by the Server.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the Server.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="interfaceDriver")
    def interface_driver(self) -> pulumi.Output[Optional[str]]:
        """
        The driver name of network interface. This must be one of [`virtio`/`e1000`]. Default:`virtio`.
        """
        return pulumi.get(self, "interface_driver")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address to assign to the Server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[int]]:
        """
        The size of memory in GiB. Default:`1`.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Server. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[int]:
        """
        The bit length of the subnet to assign to the Server.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> pulumi.Output[str]:
        """
        The network address which the `ip_address` belongs.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServerNetworkInterface']]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="privateHostId")
    def private_host_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the PrivateHost which the Server is assigned.
        """
        return pulumi.get(self, "private_host_id")

    @property
    @pulumi.getter(name="privateHostName")
    def private_host_name(self) -> pulumi.Output[str]:
        """
        The id of the PrivateHost which the Server is assigned.
        """
        return pulumi.get(self, "private_host_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the Server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the Server will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

