# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ProxyLB']


class ProxyLB(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bind_ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBBindPortArgs']]]]] = None,
                 certificate: Optional[pulumi.Input[pulumi.InputType['ProxyLBCertificateArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gzip: Optional[pulumi.Input[bool]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['ProxyLBHealthCheckArgs']]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBRuleArgs']]]]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBServerArgs']]]]] = None,
                 sorry_server: Optional[pulumi.Input[pulumi.InputType['ProxyLBSorryServerArgs']]] = None,
                 sticky_session: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vip_failover: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud ProxyLB.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar_server = sakuracloud.Server("foobarServer", network_interfaces=[sakuracloud.ServerNetworkInterfaceArgs(
            upstream="shared",
        )])
        foobar_proxy_lb = sakuracloud.ProxyLB("foobarProxyLB",
            plan=100,
            vip_failover=True,
            sticky_session=True,
            gzip=True,
            timeout=10,
            region="is1",
            health_check=sakuracloud.ProxyLBHealthCheckArgs(
                protocol="http",
                delay_loop=10,
                host_header="example.com",
                path="/",
            ),
            sorry_server=sakuracloud.ProxyLBSorryServerArgs(
                ip_address="192.0.2.1",
                port=80,
            ),
            bind_ports=[sakuracloud.ProxyLBBindPortArgs(
                proxy_mode="http",
                port=80,
                response_headers=[sakuracloud.ProxyLBBindPortResponseHeaderArgs(
                    header="Cache-Control",
                    value="public, max-age=10",
                )],
            )],
            servers=[sakuracloud.ProxyLBServerArgs(
                ip_address=foobar_server.ip_address,
                port=80,
                group="group1",
            )],
            rules=[sakuracloud.ProxyLBRuleArgs(
                host="www.example.com",
                path="/",
                group="group1",
            )],
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBBindPortArgs']]]] bind_ports: One or more `bind_port` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['ProxyLBCertificateArgs']] certificate: An `certificate` block as defined below.
        :param pulumi.Input[str] description: The description of the ProxyLB. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] gzip: The flag to enable gzip compression.
               ---
        :param pulumi.Input[pulumi.InputType['ProxyLBHealthCheckArgs']] health_check: A `health_check` block as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the ProxyLB.
        :param pulumi.Input[str] name: The name of the ProxyLB. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[int] plan: The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]. Default:`100`.
        :param pulumi.Input[str] region: The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]. Changing this forces a new resource to be created. Default:`is1`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBRuleArgs']]]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBServerArgs']]]] servers: One or more `server` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['ProxyLBSorryServerArgs']] sorry_server: A `sorry_server` block as defined below.
        :param pulumi.Input[bool] sticky_session: The flag to enable sticky session.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ProxyLB.
        :param pulumi.Input[int] timeout: The timeout duration in seconds. Default:`10`.
        :param pulumi.Input[bool] vip_failover: The flag to enable VIP fail-over. Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if bind_ports is None and not opts.urn:
                raise TypeError("Missing required property 'bind_ports'")
            __props__['bind_ports'] = bind_ports
            __props__['certificate'] = certificate
            __props__['description'] = description
            __props__['gzip'] = gzip
            if health_check is None and not opts.urn:
                raise TypeError("Missing required property 'health_check'")
            __props__['health_check'] = health_check
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['plan'] = plan
            __props__['region'] = region
            __props__['rules'] = rules
            __props__['servers'] = servers
            __props__['sorry_server'] = sorry_server
            __props__['sticky_session'] = sticky_session
            __props__['tags'] = tags
            __props__['timeout'] = timeout
            __props__['vip_failover'] = vip_failover
            __props__['fqdn'] = None
            __props__['proxy_networks'] = None
            __props__['vip'] = None
        super(ProxyLB, __self__).__init__(
            'sakuracloud:index/proxyLB:ProxyLB',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bind_ports: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBBindPortArgs']]]]] = None,
            certificate: Optional[pulumi.Input[pulumi.InputType['ProxyLBCertificateArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            gzip: Optional[pulumi.Input[bool]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['ProxyLBHealthCheckArgs']]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[int]] = None,
            proxy_networks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBRuleArgs']]]]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBServerArgs']]]]] = None,
            sorry_server: Optional[pulumi.Input[pulumi.InputType['ProxyLBSorryServerArgs']]] = None,
            sticky_session: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            vip: Optional[pulumi.Input[str]] = None,
            vip_failover: Optional[pulumi.Input[bool]] = None) -> 'ProxyLB':
        """
        Get an existing ProxyLB resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBBindPortArgs']]]] bind_ports: One or more `bind_port` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['ProxyLBCertificateArgs']] certificate: An `certificate` block as defined below.
        :param pulumi.Input[str] description: The description of the ProxyLB. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] fqdn: The FQDN for accessing to the ProxyLB. This is typically used as value of CNAME record.
        :param pulumi.Input[bool] gzip: The flag to enable gzip compression.
               ---
        :param pulumi.Input[pulumi.InputType['ProxyLBHealthCheckArgs']] health_check: A `health_check` block as defined below.
        :param pulumi.Input[str] icon_id: The icon id to attach to the ProxyLB.
        :param pulumi.Input[str] name: The name of the ProxyLB. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[int] plan: The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]. Default:`100`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] proxy_networks: A list of CIDR block used by the ProxyLB to access the server.
        :param pulumi.Input[str] region: The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]. Changing this forces a new resource to be created. Default:`is1`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBRuleArgs']]]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProxyLBServerArgs']]]] servers: One or more `server` blocks as defined below.
        :param pulumi.Input[pulumi.InputType['ProxyLBSorryServerArgs']] sorry_server: A `sorry_server` block as defined below.
        :param pulumi.Input[bool] sticky_session: The flag to enable sticky session.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ProxyLB.
        :param pulumi.Input[int] timeout: The timeout duration in seconds. Default:`10`.
        :param pulumi.Input[str] vip: The virtual IP address assigned to the ProxyLB.
        :param pulumi.Input[bool] vip_failover: The flag to enable VIP fail-over. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bind_ports"] = bind_ports
        __props__["certificate"] = certificate
        __props__["description"] = description
        __props__["fqdn"] = fqdn
        __props__["gzip"] = gzip
        __props__["health_check"] = health_check
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["proxy_networks"] = proxy_networks
        __props__["region"] = region
        __props__["rules"] = rules
        __props__["servers"] = servers
        __props__["sorry_server"] = sorry_server
        __props__["sticky_session"] = sticky_session
        __props__["tags"] = tags
        __props__["timeout"] = timeout
        __props__["vip"] = vip
        __props__["vip_failover"] = vip_failover
        return ProxyLB(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bindPorts")
    def bind_ports(self) -> pulumi.Output[Sequence['outputs.ProxyLBBindPort']]:
        """
        One or more `bind_port` blocks as defined below.
        """
        return pulumi.get(self, "bind_ports")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output['outputs.ProxyLBCertificate']:
        """
        An `certificate` block as defined below.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the ProxyLB. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN for accessing to the ProxyLB. This is typically used as value of CNAME record.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def gzip(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable gzip compression.
        ---
        """
        return pulumi.get(self, "gzip")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.ProxyLBHealthCheck']:
        """
        A `health_check` block as defined below.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the ProxyLB.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ProxyLB. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[int]]:
        """
        The plan name of the ProxyLB. This must be one of [`100`/`500`/`1000`/`5000`/`10000`/`50000`/`100000`]. Default:`100`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="proxyNetworks")
    def proxy_networks(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of CIDR block used by the ProxyLB to access the server.
        """
        return pulumi.get(self, "proxy_networks")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The name of region that the proxy LB is in. This must be one of [`tk1`/`is1`/`anycast`]. Changing this forces a new resource to be created. Default:`is1`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.ProxyLBRule']]]:
        """
        One or more `rule` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.ProxyLBServer']]]:
        """
        One or more `server` blocks as defined below.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="sorryServer")
    def sorry_server(self) -> pulumi.Output[Optional['outputs.ProxyLBSorryServer']]:
        """
        A `sorry_server` block as defined below.
        """
        return pulumi.get(self, "sorry_server")

    @property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable sticky session.
        """
        return pulumi.get(self, "sticky_session")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the ProxyLB.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout duration in seconds. Default:`10`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def vip(self) -> pulumi.Output[str]:
        """
        The virtual IP address assigned to the ProxyLB.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter(name="vipFailover")
    def vip_failover(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable VIP fail-over. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vip_failover")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

