# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Provider']


class Provider(pulumi.ProviderResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 api_request_rate_limit: Optional[pulumi.Input[int]] = None,
                 api_request_timeout: Optional[pulumi.Input[int]] = None,
                 api_root_url: Optional[pulumi.Input[str]] = None,
                 default_zone: Optional[pulumi.Input[str]] = None,
                 fake_mode: Optional[pulumi.Input[str]] = None,
                 fake_store_path: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 retry_wait_max: Optional[pulumi.Input[int]] = None,
                 retry_wait_min: Optional[pulumi.Input[int]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 trace: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        The provider type for the sakuracloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accept_language: The value of AcceptLanguage header used when calling SakuraCloud API. It can also be sourced from the
               `SAKURACLOUD_ACCEPT_LANGUAGE` environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[int] api_request_rate_limit: The maximum number of SakuraCloud API calls per second. It can also be sourced from the `SAKURACLOUD_RATE_LIMIT`
               environment variables, or via a shared credentials file if `profile` is specified. Default:`10`
        :param pulumi.Input[int] api_request_timeout: The timeout seconds for each SakuraCloud API call. It can also be sourced from the `SAKURACLOUD_API_REQUEST_TIMEOUT`
               environment variables, or via a shared credentials file if `profile` is specified. Default:`300`
        :param pulumi.Input[str] api_root_url: The root URL of SakuraCloud API. It can also be sourced from the `SAKURACLOUD_API_ROOT_URL` environment variables, or
               via a shared credentials file if `profile` is specified. Default:`https://secure.sakura.ad.jp/cloud/zone`
        :param pulumi.Input[str] default_zone: The name of zone to use as default for global resources. It must be provided, but it can also be sourced from the
               `SAKURACLOUD_DEFAULT_ZONE` environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[str] fake_mode: The flag to enable fake of SakuraCloud API call. It is for debugging or developping the provider. It can also be sourced
               from the `FAKE_MODE` environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[str] fake_store_path: The file path used by SakuraCloud API fake driver for storing fake data. It is for debugging or developping the
               provider. It can also be sourced from the `FAKE_STORE_PATH` environment variables, or via a shared credentials file if
               `profile` is specified
        :param pulumi.Input[str] profile: The profile name of your SakuraCloud account. Default:`default`
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns status code `423` or `503`. It can also be
               sourced from the `SAKURACLOUD_RETRY_MAX` environment variables, or via a shared credentials file if `profile` is
               specified. Default:`100`
        :param pulumi.Input[int] retry_wait_max: The maximum wait interval(in seconds) for retrying API call used when SakuraCloud API returns status code `423` or
               `503`. It can also be sourced from the `SAKURACLOUD_RETRY_WAIT_MAX` environment variables, or via a shared credentials
               file if `profile` is specified
        :param pulumi.Input[int] retry_wait_min: The minimum wait interval(in seconds) for retrying API call used when SakuraCloud API returns status code `423` or
               `503`. It can also be sourced from the `SAKURACLOUD_RETRY_WAIT_MIN` environment variables, or via a shared credentials
               file if `profile` is specified
        :param pulumi.Input[str] secret: The API secret of your SakuraCloud account. It must be provided, but it can also be sourced from the
               `SAKURACLOUD_ACCESS_TOKEN_SECRET` environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[str] token: The API token of your SakuraCloud account. It must be provided, but it can also be sourced from the
               `SAKURACLOUD_ACCESS_TOKEN` environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[str] trace: The flag to enable output trace log. It can also be sourced from the `SAKURACLOUD_TRACE` environment variables, or via a
               shared credentials file if `profile` is specified
        :param pulumi.Input[str] zone: The name of zone to use as default. It must be provided, but it can also be sourced from the `SAKURACLOUD_ZONE`
               environment variables, or via a shared credentials file if `profile` is specified
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: A list of available SakuraCloud zone name. It can also be sourced via a shared credentials file if `profile` is
               specified. Default:[`is1a`, `is1b`, `tk1a`, `tk1v`]
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accept_language'] = accept_language
            __props__['api_request_rate_limit'] = pulumi.Output.from_input(api_request_rate_limit).apply(pulumi.runtime.to_json) if api_request_rate_limit is not None else None
            __props__['api_request_timeout'] = pulumi.Output.from_input(api_request_timeout).apply(pulumi.runtime.to_json) if api_request_timeout is not None else None
            __props__['api_root_url'] = api_root_url
            __props__['default_zone'] = default_zone
            __props__['fake_mode'] = fake_mode
            __props__['fake_store_path'] = fake_store_path
            if profile is None:
                profile = (_utilities.get_env('SAKURACLOUD_PROFILE') or 'default')
            __props__['profile'] = profile
            __props__['retry_max'] = pulumi.Output.from_input(retry_max).apply(pulumi.runtime.to_json) if retry_max is not None else None
            __props__['retry_wait_max'] = pulumi.Output.from_input(retry_wait_max).apply(pulumi.runtime.to_json) if retry_wait_max is not None else None
            __props__['retry_wait_min'] = pulumi.Output.from_input(retry_wait_min).apply(pulumi.runtime.to_json) if retry_wait_min is not None else None
            if secret is None:
                secret = (_utilities.get_env('SAKURACLOUD_ACCESS_TOKEN_SECRET') or '')
            __props__['secret'] = secret
            if token is None:
                token = (_utilities.get_env('SAKURACLOUD_ACCESS_TOKEN') or '')
            __props__['token'] = token
            __props__['trace'] = trace
            if zone is None:
                zone = (_utilities.get_env('SAKURACLOUD_ZONE') or 'is1b')
            __props__['zone'] = zone
            __props__['zones'] = pulumi.Output.from_input(zones).apply(pulumi.runtime.to_json) if zones is not None else None
        super(Provider, __self__).__init__(
            'sakuracloud',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

