# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'ContainerRegistryUser',
    'DNSRecord',
    'DatabaseBackup',
    'DatabaseNetworkInterface',
    'DatabaseReadReplicaNetworkInterface',
    'GSLBHealthCheck',
    'GSLBServer',
    'LoadBalancerNetworkInterface',
    'LoadBalancerVip',
    'LoadBalancerVipServer',
    'LocalRouterNetworkInterface',
    'LocalRouterPeer',
    'LocalRouterStaticRoute',
    'LocalRouterSwitch',
    'MobileGatewayPrivateNetworkInterface',
    'MobileGatewaySim',
    'MobileGatewaySimRoute',
    'MobileGatewayStaticRoute',
    'MobileGatewayTrafficControl',
    'NFSNetworkInterface',
    'PacketFilterExpression',
    'PacketFilterRuleExpression',
    'ProxyLBACMECertificate',
    'ProxyLBACMECertificateAdditionalCertificate',
    'ProxyLBBindPort',
    'ProxyLBBindPortResponseHeader',
    'ProxyLBCertificate',
    'ProxyLBCertificateAdditionalCertificate',
    'ProxyLBHealthCheck',
    'ProxyLBRule',
    'ProxyLBServer',
    'ProxyLBSorryServer',
    'ServerDiskEditParameter',
    'ServerDiskEditParameterNote',
    'ServerNetworkInterface',
    'SimpleMonitorHealthCheck',
    'VPCRouterDhcpServer',
    'VPCRouterDhcpStaticMapping',
    'VPCRouterFirewall',
    'VPCRouterFirewallExpression',
    'VPCRouterL2tp',
    'VPCRouterPortForwarding',
    'VPCRouterPptp',
    'VPCRouterPrivateNetworkInterface',
    'VPCRouterPublicNetworkInterface',
    'VPCRouterSiteToSiteVpn',
    'VPCRouterStaticNat',
    'VPCRouterStaticRoute',
    'VPCRouterUser',
    'GetArchiveFilterResult',
    'GetArchiveFilterConditionResult',
    'GetBridgeFilterResult',
    'GetBridgeFilterConditionResult',
    'GetCDROMFilterResult',
    'GetCDROMFilterConditionResult',
    'GetContainerRegistryFilterResult',
    'GetContainerRegistryFilterConditionResult',
    'GetContainerRegistryUserResult',
    'GetDNSFilterResult',
    'GetDNSFilterConditionResult',
    'GetDNSRecordResult',
    'GetDatabaseBackupResult',
    'GetDatabaseFilterResult',
    'GetDatabaseFilterConditionResult',
    'GetDatabaseNetworkInterfaceResult',
    'GetDiskFilterResult',
    'GetDiskFilterConditionResult',
    'GetESMEFilterResult',
    'GetESMEFilterConditionResult',
    'GetGSLBFilterResult',
    'GetGSLBFilterConditionResult',
    'GetGSLBHealthCheckResult',
    'GetGSLBServerResult',
    'GetIconFilterResult',
    'GetIconFilterConditionResult',
    'GetInternetFilterResult',
    'GetInternetFilterConditionResult',
    'GetLoadBalancerFilterResult',
    'GetLoadBalancerFilterConditionResult',
    'GetLoadBalancerNetworkInterfaceResult',
    'GetLoadBalancerVipResult',
    'GetLoadBalancerVipServerResult',
    'GetLocalRouterFilterResult',
    'GetLocalRouterFilterConditionResult',
    'GetLocalRouterNetworkInterfaceResult',
    'GetLocalRouterPeerResult',
    'GetLocalRouterStaticRouteResult',
    'GetLocalRouterSwitchResult',
    'GetNFSFilterResult',
    'GetNFSFilterConditionResult',
    'GetNFSNetworkInterfaceResult',
    'GetNoteFilterResult',
    'GetNoteFilterConditionResult',
    'GetPacketFilterExpressionResult',
    'GetPacketFilterFilterResult',
    'GetPacketFilterFilterConditionResult',
    'GetPrivateHostFilterResult',
    'GetPrivateHostFilterConditionResult',
    'GetProxyLBBindPortResult',
    'GetProxyLBBindPortResponseHeaderResult',
    'GetProxyLBCertificateResult',
    'GetProxyLBCertificateAdditionalCertificateResult',
    'GetProxyLBFilterResult',
    'GetProxyLBFilterConditionResult',
    'GetProxyLBHealthCheckResult',
    'GetProxyLBRuleResult',
    'GetProxyLBServerResult',
    'GetProxyLBSorryServerResult',
    'GetSSHKeyFilterResult',
    'GetSSHKeyFilterConditionResult',
    'GetServerFilterResult',
    'GetServerFilterConditionResult',
    'GetServerNetworkInterfaceResult',
    'GetSimpleMonitorFilterResult',
    'GetSimpleMonitorFilterConditionResult',
    'GetSimpleMonitorHealthCheckResult',
    'GetSwitchFilterResult',
    'GetSwitchFilterConditionResult',
    'GetVPCRouterDhcpServerResult',
    'GetVPCRouterDhcpStaticMappingResult',
    'GetVPCRouterFilterResult',
    'GetVPCRouterFilterConditionResult',
    'GetVPCRouterFirewallResult',
    'GetVPCRouterFirewallExpressionResult',
    'GetVPCRouterL2tpResult',
    'GetVPCRouterPortForwardingResult',
    'GetVPCRouterPptpResult',
    'GetVPCRouterPrivateNetworkInterfaceResult',
    'GetVPCRouterPublicNetworkInterfaceResult',
    'GetVPCRouterSiteToSiteVpnResult',
    'GetVPCRouterStaticNatResult',
    'GetVPCRouterStaticRouteResult',
    'GetVPCRouterUserResult',
]

@pulumi.output_type
class ContainerRegistryUser(dict):
    def __init__(__self__, *,
                 name: str,
                 password: str,
                 permission: str):
        """
        :param str name: The user name used to authenticate remote access.
        :param str password: The password used to authenticate remote access.
        :param str permission: The level of access that allow to the user. This must be one of [`all`/`readwrite`/`readonly`].
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user name used to authenticate remote access.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password used to authenticate remote access.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The level of access that allow to the user. This must be one of [`all`/`readwrite`/`readonly`].
        """
        return pulumi.get(self, "permission")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DNSRecord(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 value: str,
                 port: Optional[int] = None,
                 priority: Optional[int] = None,
                 ttl: Optional[int] = None,
                 weight: Optional[int] = None):
        """
        :param str name: The name of the DNS Record. The length of this value must be in the range [`1`-`64`].
        :param str type: The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        :param str value: The value of the DNS Record.
        :param int port: The number of port. This must be in the range [`1`-`65535`].
        :param int priority: The priority of target DNS Record. This must be in the range [`0`-`65535`].
        :param int ttl: The number of the TTL.
        :param int weight: The weight of target DNS Record. This must be in the range [`0`-`65535`].
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the DNS Record. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the DNS Record.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The number of port. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of target DNS Record. This must be in the range [`0`-`65535`].
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The number of the TTL.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The weight of target DNS Record. This must be in the range [`0`-`65535`].
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseBackup(dict):
    def __init__(__self__, *,
                 time: Optional[str] = None,
                 weekdays: Optional[Sequence[str]] = None):
        """
        :param str time: The time to take backup. This must be formatted with `HH:mm`.
        :param Sequence[str] weekdays: A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time to take backup. This must be formatted with `HH:mm`.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[str]]:
        """
        A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        return pulumi.get(self, "weekdays")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseNetworkInterface(dict):
    def __init__(__self__, *,
                 gateway: str,
                 ip_address: str,
                 netmask: int,
                 switch_id: str,
                 port: Optional[int] = None,
                 source_ranges: Optional[Sequence[str]] = None):
        """
        :param str gateway: The IP address of the gateway used by Database.
        :param str ip_address: The IP address to assign to the Database.
        :param int netmask: The bit length of the subnet to assign to the Database. This must be in the range [`8`-`29`].
        :param str switch_id: The id of the switch to which the Database connects.
        :param int port: The number of the listening port. This must be in the range [`1024`-`65535`].
        :param Sequence[str] source_ranges: The range of source IP addresses that allow to access to the Database via network.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by Database.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address to assign to the Database.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet to assign to the Database. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch to which the Database connects.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The number of the listening port. This must be in the range [`1024`-`65535`].
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[Sequence[str]]:
        """
        The range of source IP addresses that allow to access to the Database via network.
        """
        return pulumi.get(self, "source_ranges")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseReadReplicaNetworkInterface(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 gateway: Optional[str] = None,
                 netmask: Optional[int] = None,
                 source_ranges: Optional[Sequence[str]] = None,
                 switch_id: Optional[str] = None):
        """
        :param str ip_address: The IP address to assign to the read-replica database.
        :param str gateway: The IP address of the gateway used by read-replica database. If `gateway` isn't specified, it will be set to the same value of the master database.
        :param int netmask: The bit length of the subnet to assign to the read-replica database. This must be in the range [`8`-`29`]. If `netmask` isn't specified, it will be set to the same value of the master database.
        :param Sequence[str] source_ranges: The range of source IP addresses that allow to access to the read-replica database via network.
        :param str switch_id: The id of the switch to which the read-replica database connects. If `switch_id` isn't specified, it will be set to the same value of the master database.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address to assign to the read-replica database.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The IP address of the gateway used by read-replica database. If `gateway` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def netmask(self) -> Optional[int]:
        """
        The bit length of the subnet to assign to the read-replica database. This must be in the range [`8`-`29`]. If `netmask` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[Sequence[str]]:
        """
        The range of source IP addresses that allow to access to the read-replica database via network.
        """
        return pulumi.get(self, "source_ranges")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[str]:
        """
        The id of the switch to which the read-replica database connects. If `switch_id` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "switch_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GSLBHealthCheck(dict):
    def __init__(__self__, *,
                 protocol: str,
                 delay_loop: Optional[int] = None,
                 host_header: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param str protocol: The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        :param int delay_loop: The interval in seconds between checks. This must be in the range [`10`-`60`].
        :param str host_header: The value of host header send when checking by HTTP/HTTPS.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param int port: The port number used when checking by TCP.
        :param str status: The response-code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "protocol", protocol)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[int]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`60`].
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number used when checking by TCP.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GSLBServer(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 enabled: Optional[bool] = None,
                 weight: Optional[int] = None):
        """
        :param str ip_address: The IP address of the server.
        :param bool enabled: The flag to enable as destination of load balancing.
        :param int weight: The weight used when weighted load balancing is enabled. This must be in the range [`1`-`10000`].
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The weight used when weighted load balancing is enabled. This must be in the range [`1`-`10000`].
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LoadBalancerNetworkInterface(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 switch_id: str,
                 vrid: int,
                 gateway: Optional[str] = None):
        """
        :param Sequence[str] ip_addresses: A list of IP address to assign to the LoadBalancer. .
        :param int netmask: The bit length of the subnet assigned to the LoadBalancer. This must be in the range [`8`-`29`].
        :param str switch_id: The id of the switch to which the LoadBalancer connects.
        :param int vrid: The Virtual Router Identifier.
        :param str gateway: The IP address of the gateway used by LoadBalancer.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        pulumi.set(__self__, "vrid", vrid)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        A list of IP address to assign to the LoadBalancer. .
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the LoadBalancer. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch to which the LoadBalancer connects.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vrid(self) -> int:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The IP address of the gateway used by LoadBalancer.
        """
        return pulumi.get(self, "gateway")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LoadBalancerVip(dict):
    def __init__(__self__, *,
                 port: int,
                 vip: str,
                 delay_loop: Optional[int] = None,
                 description: Optional[str] = None,
                 servers: Optional[Sequence['outputs.LoadBalancerVipServer']] = None,
                 sorry_server: Optional[str] = None):
        """
        :param int port: The target port number for load-balancing. This must be in the range [`1`-`65535`].
        :param str vip: The virtual IP address.
        :param int delay_loop: The interval in seconds between checks. This must be in the range [`10`-`2147483647`].
        :param str description: The description of the VIP. The length of this value must be in the range [`1`-`512`].
        :param Sequence['LoadBalancerVipServerArgs'] servers: One or more `server` blocks as defined below.
        :param str sorry_server: The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vip", vip)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if sorry_server is not None:
            pulumi.set(__self__, "sorry_server", sorry_server)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The target port number for load-balancing. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[int]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`2147483647`].
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the VIP. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def servers(self) -> Optional[Sequence['outputs.LoadBalancerVipServer']]:
        """
        One or more `server` blocks as defined below.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="sorryServer")
    def sorry_server(self) -> Optional[str]:
        """
        The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        """
        return pulumi.get(self, "sorry_server")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LoadBalancerVipServer(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 protocol: str,
                 enabled: Optional[bool] = None,
                 path: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str ip_address: The IP address of the destination server.
        :param str protocol: The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        :param bool enabled: The flag to enable as destination of load balancing.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param str status: The response code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "protocol", protocol)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the destination server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The response code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LocalRouterNetworkInterface(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 vip: str,
                 vrid: int):
        """
        :param Sequence[str] ip_addresses: A list of IP address to assign to the LocalRouter.
        :param int netmask: The bit length of the subnet assigned to the LocalRouter. This must be in the range [`8`-`29`].
        :param str vip: The virtual IP address.
        :param int vrid: The Virtual Router Identifier.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "vip", vip)
        pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        A list of IP address to assign to the LocalRouter.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the LocalRouter. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter
    def vrid(self) -> int:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LocalRouterPeer(dict):
    def __init__(__self__, *,
                 peer_id: str,
                 secret_key: str,
                 description: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str peer_id: The ID of the peer LocalRouter.
        :param str secret_key: The secret key of the peer LocalRouter.
        :param str description: The description of the LocalRouter. The length of this value must be in the range [`1`-`512`].
        :param bool enabled: The flag to enable the LocalRouter.
        """
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "secret_key", secret_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> str:
        """
        The ID of the peer LocalRouter.
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key of the peer LocalRouter.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the LocalRouter. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        The flag to enable the LocalRouter.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LocalRouterStaticRoute(dict):
    def __init__(__self__, *,
                 next_hop: str,
                 prefix: str):
        """
        :param str next_hop: The IP address of the next hop.
        :param str prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LocalRouterSwitch(dict):
    def __init__(__self__, *,
                 code: str,
                 zone_id: str,
                 category: Optional[str] = None):
        """
        :param str code: The resource ID of the Switch.
        :param str zone_id: The id of the Zone.
        :param str category: The category name of connected services (e.g. `cloud`, `vps`).
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "zone_id", zone_id)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The resource ID of the Switch.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category name of connected services (e.g. `cloud`, `vps`).
        """
        return pulumi.get(self, "category")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MobileGatewayPrivateNetworkInterface(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 netmask: int,
                 switch_id: str):
        """
        :param str ip_address: The IP address to assign to the MobileGateway.
        :param int netmask: The bit length of the subnet to assign to the MobileGateway. This must be in the range [`8`-`29`].
        :param str switch_id: The id of the switch to which the MobileGateway connects.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address to assign to the MobileGateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet to assign to the MobileGateway. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch to which the MobileGateway connects.
        """
        return pulumi.get(self, "switch_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MobileGatewaySim(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 sim_id: str):
        """
        :param str ip_address: The IP address to assign to the SIM.
        :param str sim_id: The id of the Switch connected to the MobileGateway.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "sim_id", sim_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address to assign to the SIM.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="simId")
    def sim_id(self) -> str:
        """
        The id of the Switch connected to the MobileGateway.
        """
        return pulumi.get(self, "sim_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MobileGatewaySimRoute(dict):
    def __init__(__self__, *,
                 prefix: str,
                 sim_id: str):
        """
        :param str prefix: The destination network prefix used by the sim routing. This must be specified by CIDR block formatted string.
        :param str sim_id: The id of the routing destination SIM.
        """
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "sim_id", sim_id)

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The destination network prefix used by the sim routing. This must be specified by CIDR block formatted string.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="simId")
    def sim_id(self) -> str:
        """
        The id of the routing destination SIM.
        """
        return pulumi.get(self, "sim_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MobileGatewayStaticRoute(dict):
    def __init__(__self__, *,
                 next_hop: str,
                 prefix: str):
        """
        :param str next_hop: The IP address of next hop.
        :param str prefix: The destination network prefix used by static routing. This must be specified by CIDR block formatted string.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The IP address of next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The destination network prefix used by static routing. This must be specified by CIDR block formatted string.
        """
        return pulumi.get(self, "prefix")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MobileGatewayTrafficControl(dict):
    def __init__(__self__, *,
                 quota: int,
                 auto_traffic_shaping: Optional[bool] = None,
                 band_width_limit: Optional[int] = None,
                 enable_email: Optional[bool] = None,
                 enable_slack: Optional[bool] = None,
                 slack_webhook: Optional[str] = None):
        """
        :param int quota: The threshold of monthly traffic usage to enable to the traffic shaping.
        :param bool auto_traffic_shaping: The flag to enable the traffic shaping.
        :param int band_width_limit: The bandwidth allowed when the traffic shaping is enabled.
        :param bool enable_email: The flag to enable email notification when the traffic shaping is enabled.
        :param bool enable_slack: The flag to enable slack notification when the traffic shaping is enabled.
        :param str slack_webhook: The webhook URL used when sends notification. It will only used when `enable_slack` is set `true`.
        """
        pulumi.set(__self__, "quota", quota)
        if auto_traffic_shaping is not None:
            pulumi.set(__self__, "auto_traffic_shaping", auto_traffic_shaping)
        if band_width_limit is not None:
            pulumi.set(__self__, "band_width_limit", band_width_limit)
        if enable_email is not None:
            pulumi.set(__self__, "enable_email", enable_email)
        if enable_slack is not None:
            pulumi.set(__self__, "enable_slack", enable_slack)
        if slack_webhook is not None:
            pulumi.set(__self__, "slack_webhook", slack_webhook)

    @property
    @pulumi.getter
    def quota(self) -> int:
        """
        The threshold of monthly traffic usage to enable to the traffic shaping.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="autoTrafficShaping")
    def auto_traffic_shaping(self) -> Optional[bool]:
        """
        The flag to enable the traffic shaping.
        """
        return pulumi.get(self, "auto_traffic_shaping")

    @property
    @pulumi.getter(name="bandWidthLimit")
    def band_width_limit(self) -> Optional[int]:
        """
        The bandwidth allowed when the traffic shaping is enabled.
        """
        return pulumi.get(self, "band_width_limit")

    @property
    @pulumi.getter(name="enableEmail")
    def enable_email(self) -> Optional[bool]:
        """
        The flag to enable email notification when the traffic shaping is enabled.
        """
        return pulumi.get(self, "enable_email")

    @property
    @pulumi.getter(name="enableSlack")
    def enable_slack(self) -> Optional[bool]:
        """
        The flag to enable slack notification when the traffic shaping is enabled.
        """
        return pulumi.get(self, "enable_slack")

    @property
    @pulumi.getter(name="slackWebhook")
    def slack_webhook(self) -> Optional[str]:
        """
        The webhook URL used when sends notification. It will only used when `enable_slack` is set `true`.
        """
        return pulumi.get(self, "slack_webhook")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NFSNetworkInterface(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 netmask: int,
                 switch_id: str,
                 gateway: Optional[str] = None):
        """
        :param str ip_address: The IP address to assign to the NFS.
        :param int netmask: The bit length of the subnet to assign to the NFS. This must be in the range [`8`-`29`].
        :param str switch_id: The id of the switch to which the NFS connects.
        :param str gateway: The IP address of the gateway used by NFS.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address to assign to the NFS.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet to assign to the NFS. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch to which the NFS connects.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The IP address of the gateway used by NFS.
        """
        return pulumi.get(self, "gateway")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PacketFilterExpression(dict):
    def __init__(__self__, *,
                 protocol: str,
                 allow: Optional[bool] = None,
                 description: Optional[str] = None,
                 destination_port: Optional[str] = None,
                 source_network: Optional[str] = None,
                 source_port: Optional[str] = None):
        """
        :param str protocol: The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        :param bool allow: The flag to allow the packet through the filter.
        :param str description: The description of the packetFilter. The length of this value must be in the range [`1`-`512`].
        :param str destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        :param str source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        pulumi.set(__self__, "protocol", protocol)
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def allow(self) -> Optional[bool]:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the packetFilter. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[str]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[str]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[str]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "source_port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PacketFilterRuleExpression(dict):
    def __init__(__self__, *,
                 protocol: str,
                 allow: Optional[bool] = None,
                 description: Optional[str] = None,
                 destination_port: Optional[str] = None,
                 source_network: Optional[str] = None,
                 source_port: Optional[str] = None):
        """
        :param str protocol: The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        :param bool allow: The flag to allow the packet through the filter.
        :param str description: The description of the expression.
        :param str destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        :param str source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        pulumi.set(__self__, "protocol", protocol)
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def allow(self) -> Optional[bool]:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the expression.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[str]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[str]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[str]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "source_port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBACMECertificate(dict):
    def __init__(__self__, *,
                 additional_certificates: Optional[Sequence['outputs.ProxyLBACMECertificateAdditionalCertificate']] = None,
                 intermediate_cert: Optional[str] = None,
                 private_key: Optional[str] = None,
                 server_cert: Optional[str] = None):
        """
        :param Sequence['ProxyLBACMECertificateAdditionalCertificateArgs'] additional_certificates: A list of `additional_certificate` blocks as defined below.
        :param str intermediate_cert: The intermediate certificate for a server.
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        """
        if additional_certificates is not None:
            pulumi.set(__self__, "additional_certificates", additional_certificates)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="additionalCertificates")
    def additional_certificates(self) -> Optional[Sequence['outputs.ProxyLBACMECertificateAdditionalCertificate']]:
        """
        A list of `additional_certificate` blocks as defined below.
        """
        return pulumi.get(self, "additional_certificates")

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[str]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[str]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBACMECertificateAdditionalCertificate(dict):
    def __init__(__self__, *,
                 intermediate_cert: Optional[str] = None,
                 private_key: Optional[str] = None,
                 server_cert: Optional[str] = None):
        """
        :param str intermediate_cert: The intermediate certificate for a server.
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        """
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[str]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[str]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBBindPort(dict):
    def __init__(__self__, *,
                 proxy_mode: str,
                 port: Optional[int] = None,
                 redirect_to_https: Optional[bool] = None,
                 response_headers: Optional[Sequence['outputs.ProxyLBBindPortResponseHeader']] = None,
                 support_http2: Optional[bool] = None):
        """
        :param str proxy_mode: The proxy mode. This must be one of [`http`/`https`/`tcp`].
        :param int port: The number of listening port.
        :param bool redirect_to_https: The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        :param Sequence['ProxyLBBindPortResponseHeaderArgs'] response_headers: One or more `response_header` blocks as defined below.
        :param bool support_http2: The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        pulumi.set(__self__, "proxy_mode", proxy_mode)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if redirect_to_https is not None:
            pulumi.set(__self__, "redirect_to_https", redirect_to_https)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)
        if support_http2 is not None:
            pulumi.set(__self__, "support_http2", support_http2)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> str:
        """
        The proxy mode. This must be one of [`http`/`https`/`tcp`].
        """
        return pulumi.get(self, "proxy_mode")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The number of listening port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="redirectToHttps")
    def redirect_to_https(self) -> Optional[bool]:
        """
        The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        """
        return pulumi.get(self, "redirect_to_https")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence['outputs.ProxyLBBindPortResponseHeader']]:
        """
        One or more `response_header` blocks as defined below.
        """
        return pulumi.get(self, "response_headers")

    @property
    @pulumi.getter(name="supportHttp2")
    def support_http2(self) -> Optional[bool]:
        """
        The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        return pulumi.get(self, "support_http2")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBBindPortResponseHeader(dict):
    def __init__(__self__, *,
                 header: str,
                 value: str):
        """
        :param str header: The field name of HTTP header added to response by the ProxyLB.
        :param str value: The field value of HTTP header added to response by the ProxyLB.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        """
        The field name of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The field value of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBCertificate(dict):
    def __init__(__self__, *,
                 additional_certificates: Optional[Sequence['outputs.ProxyLBCertificateAdditionalCertificate']] = None,
                 intermediate_cert: Optional[str] = None,
                 private_key: Optional[str] = None,
                 server_cert: Optional[str] = None):
        """
        :param Sequence['ProxyLBCertificateAdditionalCertificateArgs'] additional_certificates: One or more `additional_certificate` blocks as defined below.
        :param str intermediate_cert: The intermediate certificate for a server.
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        """
        if additional_certificates is not None:
            pulumi.set(__self__, "additional_certificates", additional_certificates)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="additionalCertificates")
    def additional_certificates(self) -> Optional[Sequence['outputs.ProxyLBCertificateAdditionalCertificate']]:
        """
        One or more `additional_certificate` blocks as defined below.
        """
        return pulumi.get(self, "additional_certificates")

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[str]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[str]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBCertificateAdditionalCertificate(dict):
    def __init__(__self__, *,
                 private_key: str,
                 server_cert: str,
                 intermediate_cert: Optional[str] = None):
        """
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        :param str intermediate_cert: The intermediate certificate for a server.
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "server_cert", server_cert)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> str:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[str]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBHealthCheck(dict):
    def __init__(__self__, *,
                 protocol: str,
                 delay_loop: Optional[int] = None,
                 host_header: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str protocol: The protocol used for health checks. This must be one of [`http`/`tcp`].
        :param int delay_loop: The interval in seconds between checks. This must be in the range [`10`-`60`].
        :param str host_header: The value of host header send when checking by HTTP.
        :param str path: The path used when checking by HTTP.
        :param int port: The port number used when checking by TCP.
        """
        pulumi.set(__self__, "protocol", protocol)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This must be one of [`http`/`tcp`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[int]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`60`].
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        The value of host header send when checking by HTTP.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path used when checking by HTTP.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number used when checking by TCP.
        """
        return pulumi.get(self, "port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBRule(dict):
    def __init__(__self__, *,
                 group: Optional[str] = None,
                 host: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str group: The name of load balancing group. When proxyLB received request which matched to `host` and `path`, proxyLB forwards the request to servers that having same group name. The length of this value must be in the range [`1`-`10`].
        :param str host: The value of HTTP host header that is used as condition of rule-based balancing.
        :param str path: The request path that is used as condition of rule-based balancing.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        The name of load balancing group. When proxyLB received request which matched to `host` and `path`, proxyLB forwards the request to servers that having same group name. The length of this value must be in the range [`1`-`10`].
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The value of HTTP host header that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The request path that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "path")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBServer(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 port: int,
                 enabled: Optional[bool] = None,
                 group: Optional[str] = None):
        """
        :param str ip_address: The IP address of the destination server.
        :param int port: The port number of the destination server. This must be in the range [`1`-`65535`].
        :param bool enabled: The flag to enable as destination of load balancing.
        :param str group: The name of load balancing group. This is used when using rule-based load balancing. The length of this value must be in the range [`1`-`10`].
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group is not None:
            pulumi.set(__self__, "group", group)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the destination server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the destination server. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        The name of load balancing group. This is used when using rule-based load balancing. The length of this value must be in the range [`1`-`10`].
        """
        return pulumi.get(self, "group")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProxyLBSorryServer(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 port: Optional[int] = None):
        """
        :param str ip_address: The IP address of the SorryServer. This will be used when all servers are down.
        :param int port: The port number of the SorryServer. This will be used when all servers are down.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServerDiskEditParameter(dict):
    def __init__(__self__, *,
                 change_partition_uuid: Optional[bool] = None,
                 disable_pw_auth: Optional[bool] = None,
                 enable_dhcp: Optional[bool] = None,
                 gateway: Optional[str] = None,
                 hostname: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 netmask: Optional[int] = None,
                 note_ids: Optional[Sequence[str]] = None,
                 notes: Optional[Sequence['outputs.ServerDiskEditParameterNote']] = None,
                 password: Optional[str] = None,
                 ssh_key_ids: Optional[Sequence[str]] = None,
                 ssh_keys: Optional[Sequence[str]] = None):
        """
        :param bool change_partition_uuid: The flag to change partition uuid.
        :param bool disable_pw_auth: The flag to disable password authentication.
        :param bool enable_dhcp: The flag to enable DHCP client.
        :param str gateway: The gateway address used by the Server.
        :param str hostname: The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        :param str ip_address: The IP address to assign to the Server.
        :param int netmask: The bit length of the subnet to assign to the Server.
        :param Sequence[str] note_ids: A list of the Note id.  
               Note: **The `note_ids` will be removed in a future version. Please use the `note` instead**
        :param Sequence['ServerDiskEditParameterNoteArgs'] notes: A list of the `note` block as defined below.
        :param str password: The password of default user. The length of this value must be in the range [`8`-`64`].
        :param Sequence[str] ssh_key_ids: A list of the SSHKey id.
        :param Sequence[str] ssh_keys: A list of the SSHKey text.
        """
        if change_partition_uuid is not None:
            pulumi.set(__self__, "change_partition_uuid", change_partition_uuid)
        if disable_pw_auth is not None:
            pulumi.set(__self__, "disable_pw_auth", disable_pw_auth)
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if note_ids is not None:
            pulumi.set(__self__, "note_ids", note_ids)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)

    @property
    @pulumi.getter(name="changePartitionUuid")
    def change_partition_uuid(self) -> Optional[bool]:
        """
        The flag to change partition uuid.
        """
        return pulumi.get(self, "change_partition_uuid")

    @property
    @pulumi.getter(name="disablePwAuth")
    def disable_pw_auth(self) -> Optional[bool]:
        """
        The flag to disable password authentication.
        """
        return pulumi.get(self, "disable_pw_auth")

    @property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> Optional[bool]:
        """
        The flag to enable DHCP client.
        """
        return pulumi.get(self, "enable_dhcp")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[str]:
        """
        The gateway address used by the Server.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address to assign to the Server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> Optional[int]:
        """
        The bit length of the subnet to assign to the Server.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="noteIds")
    def note_ids(self) -> Optional[Sequence[str]]:
        """
        A list of the Note id.  
        Note: **The `note_ids` will be removed in a future version. Please use the `note` instead**
        """
        return pulumi.get(self, "note_ids")

    @property
    @pulumi.getter
    def notes(self) -> Optional[Sequence['outputs.ServerDiskEditParameterNote']]:
        """
        A list of the `note` block as defined below.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password of default user. The length of this value must be in the range [`8`-`64`].
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[Sequence[str]]:
        """
        A list of the SSHKey id.
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[Sequence[str]]:
        """
        A list of the SSHKey text.
        """
        return pulumi.get(self, "ssh_keys")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServerDiskEditParameterNote(dict):
    def __init__(__self__, *,
                 id: str,
                 api_key_id: Optional[str] = None,
                 variables: Optional[Mapping[str, str]] = None):
        """
        :param str id: The id of the Note/StartupScript.
        :param str api_key_id: The id of the API key to be injected into the Note/StartupScript when editing the disk.
        :param Mapping[str, str] variables: The value of the variable that be injected into the Note/StartupScript when editing the disk.
        """
        pulumi.set(__self__, "id", id)
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Note/StartupScript.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[str]:
        """
        The id of the API key to be injected into the Note/StartupScript when editing the disk.
        """
        return pulumi.get(self, "api_key_id")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Mapping[str, str]]:
        """
        The value of the variable that be injected into the Note/StartupScript when editing the disk.
        """
        return pulumi.get(self, "variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServerNetworkInterface(dict):
    def __init__(__self__, *,
                 upstream: str,
                 mac_address: Optional[str] = None,
                 packet_filter_id: Optional[str] = None,
                 user_ip_address: Optional[str] = None):
        """
        :param str upstream: The upstream type or upstream switch id. This must be one of [`shared`/`disconnect`/`<switch id>`].
        :param str mac_address: The MAC address.
        :param str packet_filter_id: The id of the packet filter to attach to the network interface.
        :param str user_ip_address: The IP address for only display. This value doesn't affect actual NIC settings.
        """
        pulumi.set(__self__, "upstream", upstream)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if packet_filter_id is not None:
            pulumi.set(__self__, "packet_filter_id", packet_filter_id)
        if user_ip_address is not None:
            pulumi.set(__self__, "user_ip_address", user_ip_address)

    @property
    @pulumi.getter
    def upstream(self) -> str:
        """
        The upstream type or upstream switch id. This must be one of [`shared`/`disconnect`/`<switch id>`].
        """
        return pulumi.get(self, "upstream")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        The MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="packetFilterId")
    def packet_filter_id(self) -> Optional[str]:
        """
        The id of the packet filter to attach to the network interface.
        """
        return pulumi.get(self, "packet_filter_id")

    @property
    @pulumi.getter(name="userIpAddress")
    def user_ip_address(self) -> Optional[str]:
        """
        The IP address for only display. This value doesn't affect actual NIC settings.
        """
        return pulumi.get(self, "user_ip_address")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SimpleMonitorHealthCheck(dict):
    def __init__(__self__, *,
                 protocol: str,
                 community: Optional[str] = None,
                 contains_string: Optional[str] = None,
                 excepcted_data: Optional[str] = None,
                 host_header: Optional[str] = None,
                 http2: Optional[bool] = None,
                 oid: Optional[str] = None,
                 password: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 qname: Optional[str] = None,
                 remaining_days: Optional[int] = None,
                 sni: Optional[bool] = None,
                 snmp_version: Optional[str] = None,
                 status: Optional[int] = None,
                 username: Optional[str] = None):
        """
        :param str protocol: The protocol used for health checks. This must be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        :param str community: The SNMP community string used when checking by SNMP.
        :param str contains_string: The string that should be included in the response body when checking for HTTP/HTTPS.
        :param str excepcted_data: The expected value used when checking by DNS.
        :param str host_header: The value of host header send when checking by HTTP/HTTPS.
        :param bool http2: The flag to enable HTTP/2 when checking by HTTPS.
        :param str oid: The SNMP OID used when checking by SNMP.
        :param str password: The password for basic auth used when checking by HTTP/HTTPS.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param int port: The target port number.
        :param str qname: The FQDN used when checking by DNS.
        :param int remaining_days: The number of remaining days until certificate expiration used when checking SSL certificates. This must be in the range [`1`-`9999`].
        :param bool sni: The flag to enable SNI when checking by HTTP/HTTPS.
        :param str snmp_version: The SNMP version used when checking by SNMP. This must be one of `1`/`2c`.
        :param int status: The response-code to expect when checking by HTTP/HTTPS.
        :param str username: The user name for basic auth used when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "protocol", protocol)
        if community is not None:
            pulumi.set(__self__, "community", community)
        if contains_string is not None:
            pulumi.set(__self__, "contains_string", contains_string)
        if excepcted_data is not None:
            pulumi.set(__self__, "excepcted_data", excepcted_data)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http2 is not None:
            pulumi.set(__self__, "http2", http2)
        if oid is not None:
            pulumi.set(__self__, "oid", oid)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if qname is not None:
            pulumi.set(__self__, "qname", qname)
        if remaining_days is not None:
            pulumi.set(__self__, "remaining_days", remaining_days)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)
        if snmp_version is not None:
            pulumi.set(__self__, "snmp_version", snmp_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def community(self) -> Optional[str]:
        """
        The SNMP community string used when checking by SNMP.
        """
        return pulumi.get(self, "community")

    @property
    @pulumi.getter(name="containsString")
    def contains_string(self) -> Optional[str]:
        """
        The string that should be included in the response body when checking for HTTP/HTTPS.
        """
        return pulumi.get(self, "contains_string")

    @property
    @pulumi.getter(name="excepctedData")
    def excepcted_data(self) -> Optional[str]:
        """
        The expected value used when checking by DNS.
        """
        return pulumi.get(self, "excepcted_data")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def http2(self) -> Optional[bool]:
        """
        The flag to enable HTTP/2 when checking by HTTPS.
        """
        return pulumi.get(self, "http2")

    @property
    @pulumi.getter
    def oid(self) -> Optional[str]:
        """
        The SNMP OID used when checking by SNMP.
        """
        return pulumi.get(self, "oid")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The target port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def qname(self) -> Optional[str]:
        """
        The FQDN used when checking by DNS.
        """
        return pulumi.get(self, "qname")

    @property
    @pulumi.getter(name="remainingDays")
    def remaining_days(self) -> Optional[int]:
        """
        The number of remaining days until certificate expiration used when checking SSL certificates. This must be in the range [`1`-`9999`].
        """
        return pulumi.get(self, "remaining_days")

    @property
    @pulumi.getter
    def sni(self) -> Optional[bool]:
        """
        The flag to enable SNI when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> Optional[str]:
        """
        The SNMP version used when checking by SNMP. This must be one of `1`/`2c`.
        """
        return pulumi.get(self, "snmp_version")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The user name for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterDhcpServer(dict):
    def __init__(__self__, *,
                 interface_index: int,
                 range_start: str,
                 range_stop: str,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        :param int interface_index: The index of the network interface on which to enable the DHCP service. This must be in the range [`1`-`7`].
        :param str range_start: The start value of IP address range to assign to DHCP client.
        :param str range_stop: The end value of IP address range to assign to DHCP client.
        :param Sequence[str] dns_servers: A list of IP address of DNS server to assign to DHCP client.
        """
        pulumi.set(__self__, "interface_index", interface_index)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> int:
        """
        The index of the network interface on which to enable the DHCP service. This must be in the range [`1`-`7`].
        """
        return pulumi.get(self, "interface_index")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_stop")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        A list of IP address of DNS server to assign to DHCP client.
        """
        return pulumi.get(self, "dns_servers")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterDhcpStaticMapping(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 mac_address: str):
        """
        :param str ip_address: The static IP address to assign to DHCP client.
        :param str mac_address: The source MAC address of static mapping.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The static IP address to assign to DHCP client.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The source MAC address of static mapping.
        """
        return pulumi.get(self, "mac_address")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterFirewall(dict):
    def __init__(__self__, *,
                 direction: str,
                 expressions: Sequence['outputs.VPCRouterFirewallExpression'],
                 interface_index: Optional[int] = None):
        """
        :param str direction: The direction to apply the firewall. This must be one of [`send`/`receive`].
        :param Sequence['VPCRouterFirewallExpressionArgs'] expressions: One or more `expression` blocks as defined below.
        :param int interface_index: The index of the network interface on which to enable filtering. This must be in the range [`0`-`7`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "expressions", expressions)
        if interface_index is not None:
            pulumi.set(__self__, "interface_index", interface_index)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction to apply the firewall. This must be one of [`send`/`receive`].
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.VPCRouterFirewallExpression']:
        """
        One or more `expression` blocks as defined below.
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> Optional[int]:
        """
        The index of the network interface on which to enable filtering. This must be in the range [`0`-`7`].
        """
        return pulumi.get(self, "interface_index")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterFirewallExpression(dict):
    def __init__(__self__, *,
                 allow: bool,
                 protocol: str,
                 description: Optional[str] = None,
                 destination_network: Optional[str] = None,
                 destination_port: Optional[str] = None,
                 logging: Optional[bool] = None,
                 source_network: Optional[str] = None,
                 source_port: Optional[str] = None):
        """
        :param bool allow: The flag to allow the packet through the filter.
        :param str protocol: The protocol used for filtering. This must be one of [`tcp`/`udp`/`icmp`/`ip`].
        :param str description: The description of the expression. The length of this value must be in the range [`0`-`512`].
        :param str destination_network: A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        :param bool logging: The flag to enable packet logging when matching the expression.
        :param str source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        pulumi.set(__self__, "allow", allow)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_network is not None:
            pulumi.set(__self__, "destination_network", destination_network)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def allow(self) -> bool:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for filtering. This must be one of [`tcp`/`udp`/`icmp`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the expression. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationNetwork")
    def destination_network(self) -> Optional[str]:
        """
        A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "destination_network")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[str]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def logging(self) -> Optional[bool]:
        """
        The flag to enable packet logging when matching the expression.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[str]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[str]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "source_port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterL2tp(dict):
    def __init__(__self__, *,
                 pre_shared_secret: str,
                 range_start: str,
                 range_stop: str):
        """
        :param str pre_shared_secret: The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        :param str range_start: The start value of IP address range to assign to DHCP client.
        :param str range_stop: The end value of IP address range to assign to DHCP client.
        """
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> str:
        """
        The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        """
        return pulumi.get(self, "pre_shared_secret")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_stop")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterPortForwarding(dict):
    def __init__(__self__, *,
                 private_ip: str,
                 private_port: int,
                 protocol: str,
                 public_port: int,
                 description: Optional[str] = None):
        """
        :param str private_ip: The destination ip address of the port forwarding.
        :param int private_port: The destination port number of the port forwarding. This will be a port number on a private network.
        :param str protocol: The protocol used for port forwarding. This must be one of [`tcp`/`udp`].
        :param int public_port: The source port number of the port forwarding. This must be a port number on a public network.
        :param str description: The description of the port forwarding. The length of this value must be in the range [`0`-`512`].
        """
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "private_port", private_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_port", public_port)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The destination ip address of the port forwarding.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> int:
        """
        The destination port number of the port forwarding. This will be a port number on a private network.
        """
        return pulumi.get(self, "private_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for port forwarding. This must be one of [`tcp`/`udp`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> int:
        """
        The source port number of the port forwarding. This must be a port number on a public network.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the port forwarding. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterPptp(dict):
    def __init__(__self__, *,
                 range_start: str,
                 range_stop: str):
        """
        :param str range_start: The start value of IP address range to assign to PPTP client.
        :param str range_stop: The end value of IP address range to assign to PPTP client.
        """
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_stop")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterPrivateNetworkInterface(dict):
    def __init__(__self__, *,
                 index: int,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 switch_id: str,
                 vip: Optional[str] = None):
        """
        :param int index: The index of the network interface. This must be in the range [`1`-`7`].
        :param Sequence[str] ip_addresses: A list of ip address to assign to the network interface. This is required only one value when `plan` is `standard`, two values otherwise.
        :param int netmask: The bit length of the subnet to assign to the network interface.
        :param str switch_id: The id of the connected switch.
        :param str vip: The virtual IP address to assign to the network interface. This is only required when `plan` is not `standard`.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if vip is not None:
            pulumi.set(__self__, "vip", vip)

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        The index of the network interface. This must be in the range [`1`-`7`].
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        A list of ip address to assign to the network interface. This is required only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet to assign to the network interface.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the connected switch.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vip(self) -> Optional[str]:
        """
        The virtual IP address to assign to the network interface. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterPublicNetworkInterface(dict):
    def __init__(__self__, *,
                 aliases: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 switch_id: Optional[str] = None,
                 vip: Optional[str] = None,
                 vrid: Optional[int] = None):
        """
        :param Sequence[str] aliases: A list of ip alias to assign to the VPC Router. This can only be specified if `plan` is not `standard`.
        :param Sequence[str] ip_addresses: The list of the IP address to assign to the VPC Router. This is required only one value when `plan` is `standard`, two values otherwise.
        :param str switch_id: The id of the switch to connect. This is only required when when `plan` is not `standard`.
        :param str vip: The virtual IP address of the VPC Router. This is only required when `plan` is not `standard`.
        :param int vrid: The Virtual Router Identifier. This is only required when `plan` is not `standard`.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)
        if vip is not None:
            pulumi.set(__self__, "vip", vip)
        if vrid is not None:
            pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        """
        A list of ip alias to assign to the VPC Router. This can only be specified if `plan` is not `standard`.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        The list of the IP address to assign to the VPC Router. This is required only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[str]:
        """
        The id of the switch to connect. This is only required when when `plan` is not `standard`.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vip(self) -> Optional[str]:
        """
        The virtual IP address of the VPC Router. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter
    def vrid(self) -> Optional[int]:
        """
        The Virtual Router Identifier. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vrid")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterSiteToSiteVpn(dict):
    def __init__(__self__, *,
                 local_prefixes: Sequence[str],
                 peer: str,
                 pre_shared_secret: str,
                 remote_id: str,
                 routes: Sequence[str]):
        """
        :param Sequence[str] local_prefixes: A list of CIDR block of the network under the VPC Router.
        :param str peer: The IP address of the opposing appliance connected to the VPC Router.
        :param str pre_shared_secret: The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        :param str remote_id: The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        :param Sequence[str] routes: A list of CIDR block of VPN connected networks.
        """
        pulumi.set(__self__, "local_prefixes", local_prefixes)
        pulumi.set(__self__, "peer", peer)
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "remote_id", remote_id)
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="localPrefixes")
    def local_prefixes(self) -> Sequence[str]:
        """
        A list of CIDR block of the network under the VPC Router.
        """
        return pulumi.get(self, "local_prefixes")

    @property
    @pulumi.getter
    def peer(self) -> str:
        """
        The IP address of the opposing appliance connected to the VPC Router.
        """
        return pulumi.get(self, "peer")

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> str:
        """
        The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        """
        return pulumi.get(self, "pre_shared_secret")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> str:
        """
        The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        """
        return pulumi.get(self, "remote_id")

    @property
    @pulumi.getter
    def routes(self) -> Sequence[str]:
        """
        A list of CIDR block of VPN connected networks.
        """
        return pulumi.get(self, "routes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterStaticNat(dict):
    def __init__(__self__, *,
                 private_ip: str,
                 public_ip: str,
                 description: Optional[str] = None):
        """
        :param str private_ip: The private IP address used for the static NAT.
        :param str public_ip: The public IP address used for the static NAT.
        :param str description: The description of the static nat. The length of this value must be in the range [`0`-`512`].
        """
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address used for the static NAT.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address used for the static NAT.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the static nat. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterStaticRoute(dict):
    def __init__(__self__, *,
                 next_hop: str,
                 prefix: str):
        """
        :param str next_hop: The IP address of the next hop.
        :param str prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VPCRouterUser(dict):
    def __init__(__self__, *,
                 name: str,
                 password: str):
        """
        :param str name: The user name used to authenticate remote access.
        :param str password: The password used to authenticate remote access.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user name used to authenticate remote access.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password used to authenticate remote access.
        """
        return pulumi.get(self, "password")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetArchiveFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetArchiveFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetArchiveFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetArchiveFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetArchiveFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBridgeFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetBridgeFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetBridgeFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetBridgeFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class GetBridgeFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetCDROMFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetCDROMFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetCDROMFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetCDROMFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetCDROMFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetContainerRegistryFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetContainerRegistryFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetContainerRegistryFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetContainerRegistryFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetContainerRegistryFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetContainerRegistryUserResult(dict):
    def __init__(__self__, *,
                 name: str,
                 permission: str):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param str permission: The level of access that allow to the user. This will be one of [`all`/`readwrite`/`readonly`].
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The level of access that allow to the user. This will be one of [`all`/`readwrite`/`readonly`].
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class GetDNSFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetDNSFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDNSFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetDNSFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDNSFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDNSRecordResult(dict):
    def __init__(__self__, *,
                 name: str,
                 port: int,
                 priority: int,
                 ttl: int,
                 type: str,
                 value: str,
                 weight: int):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param int port: The number of port.
        :param int priority: The priority of target DNS Record.
        :param int ttl: The number of the TTL.
        :param str type: The type of DNS Record. This will be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        :param str value: The value of the DNS Record.
        :param int weight: The weight of target DNS Record.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The number of port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of target DNS Record.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The number of the TTL.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of DNS Record. This will be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the DNS Record.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of target DNS Record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetDatabaseBackupResult(dict):
    def __init__(__self__, *,
                 time: str,
                 weekdays: Sequence[str]):
        """
        :param str time: The time to take backup. This will be formatted with `HH:mm`.
        :param Sequence[str] weekdays: The list of name of weekday that doing backup. This will be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        pulumi.set(__self__, "time", time)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time to take backup. This will be formatted with `HH:mm`.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def weekdays(self) -> Sequence[str]:
        """
        The list of name of weekday that doing backup. This will be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class GetDatabaseFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetDatabaseFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDatabaseFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetDatabaseFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDatabaseFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDatabaseNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 gateway: str,
                 ip_address: str,
                 netmask: int,
                 port: int,
                 source_ranges: Sequence[str],
                 switch_id: str):
        """
        :param str gateway: The IP address of the gateway used by Database.
        :param str ip_address: The IP address assigned to the Database.
        :param int netmask: The bit length of the subnet assigned to the Database.
        :param int port: The number of the listening port.
        :param Sequence[str] source_ranges: The range of source IP addresses that allow to access to the Database via network.
        :param str switch_id: The id of the switch connected from the Database.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source_ranges", source_ranges)
        pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by Database.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address assigned to the Database.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the Database.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The number of the listening port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Sequence[str]:
        """
        The range of source IP addresses that allow to access to the Database via network.
        """
        return pulumi.get(self, "source_ranges")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the Database.
        """
        return pulumi.get(self, "switch_id")


@pulumi.output_type
class GetDiskFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetDiskFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDiskFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetDiskFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDiskFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetESMEFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetESMEFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetESMEFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetESMEFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetESMEFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetGSLBFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetGSLBFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetGSLBFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetGSLBFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetGSLBFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetGSLBHealthCheckResult(dict):
    def __init__(__self__, *,
                 delay_loop: int,
                 host_header: str,
                 path: str,
                 port: int,
                 protocol: str,
                 status: str):
        """
        :param int delay_loop: The interval in seconds between checks.
        :param str host_header: The value of host header send when checking by HTTP/HTTPS.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param int port: The port number used when checking by TCP.
        :param str protocol: The protocol used for health checks. This will be one of [`http`/`https`/`tcp`/`ping`].
        :param str status: The response-code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "delay_loop", delay_loop)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> int:
        """
        The interval in seconds between checks.
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> str:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number used when checking by TCP.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This will be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGSLBServerResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 ip_address: str,
                 weight: int):
        """
        :param bool enabled: The flag to enable as destination of load balancing.
        :param str ip_address: The IP address of the server.
        :param int weight: The weight used when weighted load balancing is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight used when weighted load balancing is enabled.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetIconFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetIconFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetIconFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetIconFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetIconFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInternetFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetInternetFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetInternetFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetInternetFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInternetFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetLoadBalancerFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetLoadBalancerFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetLoadBalancerFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetLoadBalancerFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLoadBalancerFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetLoadBalancerNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 gateway: str,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 switch_id: str,
                 vrid: int):
        """
        :param str gateway: The IP address of the gateway used by LoadBalancer.
        :param Sequence[str] ip_addresses: The list of IP address assigned to the LoadBalancer.
        :param int netmask: The bit length of the subnet assigned to the LoadBalancer.
        :param str switch_id: The id of the switch connected from the LoadBalancer.
        :param int vrid: The Virtual Router Identifier.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by LoadBalancer.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of IP address assigned to the LoadBalancer.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the LoadBalancer.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the LoadBalancer.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vrid(self) -> int:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")


@pulumi.output_type
class GetLoadBalancerVipResult(dict):
    def __init__(__self__, *,
                 delay_loop: int,
                 description: str,
                 port: int,
                 servers: Sequence['outputs.GetLoadBalancerVipServerResult'],
                 sorry_server: str,
                 vip: str):
        """
        :param int delay_loop: The interval in seconds between checks.
        :param str description: The description of the VIP.
        :param int port: The target port number for load-balancing.
        :param Sequence['GetLoadBalancerVipServerArgs'] servers: A list of `server` blocks as defined below.
        :param str sorry_server: The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        :param str vip: The virtual IP address.
        """
        pulumi.set(__self__, "delay_loop", delay_loop)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "sorry_server", sorry_server)
        pulumi.set(__self__, "vip", vip)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> int:
        """
        The interval in seconds between checks.
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the VIP.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The target port number for load-balancing.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetLoadBalancerVipServerResult']:
        """
        A list of `server` blocks as defined below.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="sorryServer")
    def sorry_server(self) -> str:
        """
        The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        """
        return pulumi.get(self, "sorry_server")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")


@pulumi.output_type
class GetLoadBalancerVipServerResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 ip_address: str,
                 path: str,
                 protocol: str,
                 status: str):
        """
        :param bool enabled: The flag to enable as destination of load balancing.
        :param str ip_address: The IP address of the destination server.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param str protocol: The protocol used for health checks. This will be one of [`http`/`https`/`tcp`/`ping`].
        :param str status: The response code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the destination server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This will be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The response code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetLocalRouterFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetLocalRouterFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetLocalRouterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetLocalRouterFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLocalRouterFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetLocalRouterNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 vip: str,
                 vrid: int):
        """
        :param Sequence[str] ip_addresses: The list of IP address assigned to the LocalRouter.
        :param int netmask: The bit length of the subnet assigned to the LocalRouter.
        :param str vip: The virtual IP address.
        :param int vrid: The Virtual Router Identifier.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "vip", vip)
        pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of IP address assigned to the LocalRouter.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the LocalRouter.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter
    def vrid(self) -> int:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")


@pulumi.output_type
class GetLocalRouterPeerResult(dict):
    def __init__(__self__, *,
                 description: str,
                 enabled: bool,
                 peer_id: str,
                 secret_key: str):
        """
        :param str description: The description of the LocalRouter.
        :param bool enabled: The flag to enable the LocalRouter.
        :param str peer_id: The ID of the peer LocalRouter.
        :param str secret_key: The secret key of the peer LocalRouter.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the LocalRouter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The flag to enable the LocalRouter.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> str:
        """
        The ID of the peer LocalRouter.
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key of the peer LocalRouter.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class GetLocalRouterStaticRouteResult(dict):
    def __init__(__self__, *,
                 next_hop: str,
                 prefix: str):
        """
        :param str next_hop: The IP address of the next hop.
        :param str prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetLocalRouterSwitchResult(dict):
    def __init__(__self__, *,
                 category: str,
                 code: str,
                 zone_id: str):
        """
        :param str category: The category name of connected services (e.g. `cloud`, `vps`).
        :param str code: The resource ID of the Switch.
        :param str zone_id: The id of the Zone.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category name of connected services (e.g. `cloud`, `vps`).
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The resource ID of the Switch.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetNFSFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetNFSFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetNFSFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetNFSFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetNFSFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetNFSNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 gateway: str,
                 ip_address: str,
                 netmask: int,
                 switch_id: str):
        """
        :param str gateway: The IP address of the gateway used by NFS.
        :param str ip_address: The IP address assigned to the NFS.
        :param int netmask: The bit length of the subnet assigned to the NFS.
        :param str switch_id: The id of the switch connected from the NFS.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by NFS.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address assigned to the NFS.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the NFS.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the NFS.
        """
        return pulumi.get(self, "switch_id")


@pulumi.output_type
class GetNoteFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetNoteFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetNoteFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetNoteFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetNoteFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPacketFilterExpressionResult(dict):
    def __init__(__self__, *,
                 allow: bool,
                 description: str,
                 destination_port: str,
                 protocol: str,
                 source_network: str,
                 source_port: str):
        """
        :param bool allow: The flag to allow the packet through the filter.
        :param str description: The description of the expression.
        :param str destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        :param str protocol: The protocol used for filtering. This will be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        :param str source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        pulumi.set(__self__, "allow", allow)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_network", source_network)
        pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def allow(self) -> bool:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the expression.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> str:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for filtering. This will be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> str:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> str:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class GetPacketFilterFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetPacketFilterFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetPacketFilterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetPacketFilterFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class GetPacketFilterFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPrivateHostFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetPrivateHostFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetPrivateHostFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetPrivateHostFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetPrivateHostFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetProxyLBBindPortResult(dict):
    def __init__(__self__, *,
                 port: int,
                 proxy_mode: str,
                 redirect_to_https: bool,
                 response_headers: Sequence['outputs.GetProxyLBBindPortResponseHeaderResult'],
                 support_http2: bool):
        """
        :param int port: The port number of the SorryServer. This will be used when all servers are down.
        :param str proxy_mode: The proxy mode. This will be one of [`http`/`https`/`tcp`].
        :param bool redirect_to_https: The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        :param Sequence['GetProxyLBBindPortResponseHeaderArgs'] response_headers: A list of `response_header` blocks as defined below.
        :param bool support_http2: The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proxy_mode", proxy_mode)
        pulumi.set(__self__, "redirect_to_https", redirect_to_https)
        pulumi.set(__self__, "response_headers", response_headers)
        pulumi.set(__self__, "support_http2", support_http2)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> str:
        """
        The proxy mode. This will be one of [`http`/`https`/`tcp`].
        """
        return pulumi.get(self, "proxy_mode")

    @property
    @pulumi.getter(name="redirectToHttps")
    def redirect_to_https(self) -> bool:
        """
        The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        """
        return pulumi.get(self, "redirect_to_https")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Sequence['outputs.GetProxyLBBindPortResponseHeaderResult']:
        """
        A list of `response_header` blocks as defined below.
        """
        return pulumi.get(self, "response_headers")

    @property
    @pulumi.getter(name="supportHttp2")
    def support_http2(self) -> bool:
        """
        The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        return pulumi.get(self, "support_http2")


@pulumi.output_type
class GetProxyLBBindPortResponseHeaderResult(dict):
    def __init__(__self__, *,
                 header: str,
                 value: str):
        """
        :param str header: The field name of HTTP header added to response by the ProxyLB.
        :param str value: The field value of HTTP header added to response by the ProxyLB.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        """
        The field name of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The field value of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProxyLBCertificateResult(dict):
    def __init__(__self__, *,
                 additional_certificates: Sequence['outputs.GetProxyLBCertificateAdditionalCertificateResult'],
                 intermediate_cert: str,
                 private_key: str,
                 server_cert: str):
        """
        :param str intermediate_cert: The intermediate certificate for a server.
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        """
        pulumi.set(__self__, "additional_certificates", additional_certificates)
        pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="additionalCertificates")
    def additional_certificates(self) -> Sequence['outputs.GetProxyLBCertificateAdditionalCertificateResult']:
        return pulumi.get(self, "additional_certificates")

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> str:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> str:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")


@pulumi.output_type
class GetProxyLBCertificateAdditionalCertificateResult(dict):
    def __init__(__self__, *,
                 intermediate_cert: str,
                 private_key: str,
                 server_cert: str):
        """
        :param str intermediate_cert: The intermediate certificate for a server.
        :param str private_key: The private key for a server.
        :param str server_cert: The certificate for a server.
        """
        pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> str:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> str:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")


@pulumi.output_type
class GetProxyLBFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetProxyLBFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetProxyLBFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetProxyLBFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetProxyLBFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetProxyLBHealthCheckResult(dict):
    def __init__(__self__, *,
                 delay_loop: int,
                 host_header: str,
                 path: str,
                 port: int,
                 protocol: str):
        """
        :param int delay_loop: The interval in seconds between checks.
        :param str host_header: The value of host header send when checking by HTTP.
        :param str path: The request path that is used as condition of rule-based balancing.
        :param int port: The port number of the SorryServer. This will be used when all servers are down.
        :param str protocol: The protocol used for health checks. This will be one of [`http`/`tcp`].
        """
        pulumi.set(__self__, "delay_loop", delay_loop)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> int:
        """
        The interval in seconds between checks.
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> str:
        """
        The value of host header send when checking by HTTP.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The request path that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This will be one of [`http`/`tcp`].
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetProxyLBRuleResult(dict):
    def __init__(__self__, *,
                 group: str,
                 host: str,
                 path: str):
        """
        :param str group: The name of load balancing group. This is used when using rule-based load balancing.
        :param str host: The value of HTTP host header that is used as condition of rule-based balancing.
        :param str path: The request path that is used as condition of rule-based balancing.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The name of load balancing group. This is used when using rule-based load balancing.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The value of HTTP host header that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The request path that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetProxyLBServerResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 group: str,
                 ip_address: str,
                 port: int):
        """
        :param bool enabled: The flag to enable as destination of load balancing.
        :param str group: The name of load balancing group. This is used when using rule-based load balancing.
        :param str ip_address: The IP address of the SorryServer. This will be used when all servers are down.
        :param int port: The port number of the SorryServer. This will be used when all servers are down.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The name of load balancing group. This is used when using rule-based load balancing.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetProxyLBSorryServerResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 port: int):
        """
        :param str ip_address: The IP address of the SorryServer. This will be used when all servers are down.
        :param int port: The port number of the SorryServer. This will be used when all servers are down.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetSSHKeyFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetSSHKeyFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSSHKeyFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetSSHKeyFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class GetSSHKeyFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetServerFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetServerFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetServerFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetServerFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetServerFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetServerNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 mac_address: str,
                 packet_filter_id: str,
                 upstream: str,
                 user_ip_address: str):
        """
        :param str mac_address: The MAC address.
        :param str packet_filter_id: The id of the packet filter attached to the network interface.
        :param str upstream: The upstream type or upstream switch id. This will be one of [`shared`/`disconnect`/`<switch id>`].
        :param str user_ip_address: The IP address for only display. This value doesn't affect actual NIC settings.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "packet_filter_id", packet_filter_id)
        pulumi.set(__self__, "upstream", upstream)
        pulumi.set(__self__, "user_ip_address", user_ip_address)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="packetFilterId")
    def packet_filter_id(self) -> str:
        """
        The id of the packet filter attached to the network interface.
        """
        return pulumi.get(self, "packet_filter_id")

    @property
    @pulumi.getter
    def upstream(self) -> str:
        """
        The upstream type or upstream switch id. This will be one of [`shared`/`disconnect`/`<switch id>`].
        """
        return pulumi.get(self, "upstream")

    @property
    @pulumi.getter(name="userIpAddress")
    def user_ip_address(self) -> str:
        """
        The IP address for only display. This value doesn't affect actual NIC settings.
        """
        return pulumi.get(self, "user_ip_address")


@pulumi.output_type
class GetSimpleMonitorFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetSimpleMonitorFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSimpleMonitorFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetSimpleMonitorFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetSimpleMonitorFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSimpleMonitorHealthCheckResult(dict):
    def __init__(__self__, *,
                 community: str,
                 contains_string: str,
                 excepcted_data: str,
                 host_header: str,
                 http2: bool,
                 oid: str,
                 password: str,
                 path: str,
                 port: int,
                 protocol: str,
                 qname: str,
                 remaining_days: int,
                 sni: bool,
                 snmp_version: str,
                 status: int,
                 username: str):
        """
        :param str community: The SNMP community string used when checking by SNMP.
        :param str contains_string: The string that should be included in the response body when checking for HTTP/HTTPS.
        :param str excepcted_data: The expected value used when checking by DNS.
        :param str host_header: The value of host header send when checking by HTTP/HTTPS.
        :param bool http2: The flag to enable HTTP/2 when checking by HTTPS.
        :param str oid: The SNMP OID used when checking by SNMP.
        :param str password: The password for basic auth used when checking by HTTP/HTTPS.
        :param str path: The path used when checking by HTTP/HTTPS.
        :param int port: The target port number.
        :param str protocol: The protocol used for health checks. This will be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        :param str qname: The FQDN used when checking by DNS.
        :param int remaining_days: The number of remaining days until certificate expiration used when checking SSL certificates.
        :param bool sni: The flag to enable SNI when checking by HTTP/HTTPS.
        :param str snmp_version: The SNMP version used when checking by SNMP.
        :param int status: The response-code to expect when checking by HTTP/HTTPS.
        :param str username: The user name for basic auth used when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "community", community)
        pulumi.set(__self__, "contains_string", contains_string)
        pulumi.set(__self__, "excepcted_data", excepcted_data)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "http2", http2)
        pulumi.set(__self__, "oid", oid)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "qname", qname)
        pulumi.set(__self__, "remaining_days", remaining_days)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "snmp_version", snmp_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def community(self) -> str:
        """
        The SNMP community string used when checking by SNMP.
        """
        return pulumi.get(self, "community")

    @property
    @pulumi.getter(name="containsString")
    def contains_string(self) -> str:
        """
        The string that should be included in the response body when checking for HTTP/HTTPS.
        """
        return pulumi.get(self, "contains_string")

    @property
    @pulumi.getter(name="excepctedData")
    def excepcted_data(self) -> str:
        """
        The expected value used when checking by DNS.
        """
        return pulumi.get(self, "excepcted_data")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> str:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def http2(self) -> bool:
        """
        The flag to enable HTTP/2 when checking by HTTPS.
        """
        return pulumi.get(self, "http2")

    @property
    @pulumi.getter
    def oid(self) -> str:
        """
        The SNMP OID used when checking by SNMP.
        """
        return pulumi.get(self, "oid")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The target port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks. This will be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def qname(self) -> str:
        """
        The FQDN used when checking by DNS.
        """
        return pulumi.get(self, "qname")

    @property
    @pulumi.getter(name="remainingDays")
    def remaining_days(self) -> int:
        """
        The number of remaining days until certificate expiration used when checking SSL certificates.
        """
        return pulumi.get(self, "remaining_days")

    @property
    @pulumi.getter
    def sni(self) -> bool:
        """
        The flag to enable SNI when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> str:
        """
        The SNMP version used when checking by SNMP.
        """
        return pulumi.get(self, "snmp_version")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSwitchFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetSwitchFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSwitchFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetSwitchFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetSwitchFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVPCRouterDhcpServerResult(dict):
    def __init__(__self__, *,
                 dns_servers: Sequence[str],
                 interface_index: int,
                 range_start: str,
                 range_stop: str):
        """
        :param Sequence[str] dns_servers: A list of IP address of DNS server to assign to DHCP client.
        :param int interface_index: The index of the network interface on which to enable filtering. This will be between `0`-`7`.
        :param str range_start: The start value of IP address range to assign to PPTP client.
        :param str range_stop: The end value of IP address range to assign to PPTP client.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "interface_index", interface_index)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        A list of IP address of DNS server to assign to DHCP client.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> int:
        """
        The index of the network interface on which to enable filtering. This will be between `0`-`7`.
        """
        return pulumi.get(self, "interface_index")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_stop")


@pulumi.output_type
class GetVPCRouterDhcpStaticMappingResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 mac_address: str):
        """
        :param str ip_address: The static IP address to assign to DHCP client.
        :param str mac_address: The source MAC address of static mapping.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The static IP address to assign to DHCP client.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The source MAC address of static mapping.
        """
        return pulumi.get(self, "mac_address")


@pulumi.output_type
class GetVPCRouterFilterResult(dict):
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.GetVPCRouterFilterConditionResult']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetVPCRouterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetVPCRouterFilterConditionResult']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetVPCRouterFilterConditionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVPCRouterFirewallResult(dict):
    def __init__(__self__, *,
                 direction: str,
                 expressions: Sequence['outputs.GetVPCRouterFirewallExpressionResult'],
                 interface_index: int):
        """
        :param str direction: The direction to apply the firewall. This will be one of [`send`/`receive`].
        :param Sequence['GetVPCRouterFirewallExpressionArgs'] expressions: A list of `expression` blocks as defined below.
        :param int interface_index: The index of the network interface on which to enable filtering. This will be between `0`-`7`.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "expressions", expressions)
        pulumi.set(__self__, "interface_index", interface_index)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction to apply the firewall. This will be one of [`send`/`receive`].
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.GetVPCRouterFirewallExpressionResult']:
        """
        A list of `expression` blocks as defined below.
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> int:
        """
        The index of the network interface on which to enable filtering. This will be between `0`-`7`.
        """
        return pulumi.get(self, "interface_index")


@pulumi.output_type
class GetVPCRouterFirewallExpressionResult(dict):
    def __init__(__self__, *,
                 allow: bool,
                 description: str,
                 destination_network: str,
                 destination_port: str,
                 logging: bool,
                 protocol: str,
                 source_network: str,
                 source_port: str):
        """
        :param bool allow: The flag to allow the packet through the filter.
        :param str description: The description of the static NAT.
        :param str destination_network: A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        :param bool logging: The flag to enable packet logging when matching the expression.
        :param str protocol: The protocol used for port forwarding. This will be one of [`tcp`/`udp`].
        :param str source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param str source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        pulumi.set(__self__, "allow", allow)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_network", destination_network)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_network", source_network)
        pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def allow(self) -> bool:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the static NAT.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationNetwork")
    def destination_network(self) -> str:
        """
        A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "destination_network")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> str:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def logging(self) -> bool:
        """
        The flag to enable packet logging when matching the expression.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for port forwarding. This will be one of [`tcp`/`udp`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> str:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> str:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class GetVPCRouterL2tpResult(dict):
    def __init__(__self__, *,
                 pre_shared_secret: str,
                 range_start: str,
                 range_stop: str):
        """
        :param str pre_shared_secret: The pre shared secret for the VPN.
        :param str range_start: The start value of IP address range to assign to PPTP client.
        :param str range_stop: The end value of IP address range to assign to PPTP client.
        """
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> str:
        """
        The pre shared secret for the VPN.
        """
        return pulumi.get(self, "pre_shared_secret")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_stop")


@pulumi.output_type
class GetVPCRouterPortForwardingResult(dict):
    def __init__(__self__, *,
                 description: str,
                 private_ip: str,
                 private_port: int,
                 protocol: str,
                 public_port: int):
        """
        :param str description: The description of the static NAT.
        :param str private_ip: The private IP address used for the static NAT.
        :param int private_port: The destination port number of the port forwarding. This will be a port number on a private network.
        :param str protocol: The protocol used for port forwarding. This will be one of [`tcp`/`udp`].
        :param int public_port: The source port number of the port forwarding. This will be a port number on a public network.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "private_port", private_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_port", public_port)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the static NAT.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address used for the static NAT.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> int:
        """
        The destination port number of the port forwarding. This will be a port number on a private network.
        """
        return pulumi.get(self, "private_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for port forwarding. This will be one of [`tcp`/`udp`].
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> int:
        """
        The source port number of the port forwarding. This will be a port number on a public network.
        """
        return pulumi.get(self, "public_port")


@pulumi.output_type
class GetVPCRouterPptpResult(dict):
    def __init__(__self__, *,
                 range_start: str,
                 range_stop: str):
        """
        :param str range_start: The start value of IP address range to assign to PPTP client.
        :param str range_stop: The end value of IP address range to assign to PPTP client.
        """
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The start value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> str:
        """
        The end value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_stop")


@pulumi.output_type
class GetVPCRouterPrivateNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 index: int,
                 ip_addresses: Sequence[str],
                 netmask: int,
                 switch_id: str,
                 vip: str):
        """
        :param int index: The index of the network interface. This will be between `1`-`7`.
        :param Sequence[str] ip_addresses: The list of the IP address assigned to the VPC Router. This will be only one value when `plan` is `standard`, two values otherwise.
        :param int netmask: The bit length of the subnet assigned to the network interface.
        :param str switch_id: The id of the switch connected from the VPCRouter.
        :param str vip: The virtual IP address of the VPC Router. This is only used when `plan` is not `standard`.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        pulumi.set(__self__, "vip", vip)

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        The index of the network interface. This will be between `1`-`7`.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of the IP address assigned to the VPC Router. This will be only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the network interface.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the VPCRouter.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address of the VPC Router. This is only used when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")


@pulumi.output_type
class GetVPCRouterPublicNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 aliases: Sequence[str],
                 ip_addresses: Sequence[str],
                 switch_id: str,
                 vip: str,
                 vrid: int):
        """
        :param Sequence[str] aliases: A list of ip alias assigned to the VPC Router. This is only used when `plan` is not `standard`.
        :param Sequence[str] ip_addresses: The list of the IP address assigned to the VPC Router. This will be only one value when `plan` is `standard`, two values otherwise.
        :param str switch_id: The id of the switch connected from the VPCRouter.
        :param str vip: The virtual IP address of the VPC Router. This is only used when `plan` is not `standard`.
        :param int vrid: The Virtual Router Identifier. This is only used when `plan` is not `standard`.
        """
        pulumi.set(__self__, "aliases", aliases)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "switch_id", switch_id)
        pulumi.set(__self__, "vip", vip)
        pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter
    def aliases(self) -> Sequence[str]:
        """
        A list of ip alias assigned to the VPC Router. This is only used when `plan` is not `standard`.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        The list of the IP address assigned to the VPC Router. This will be only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the VPCRouter.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def vip(self) -> str:
        """
        The virtual IP address of the VPC Router. This is only used when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")

    @property
    @pulumi.getter
    def vrid(self) -> int:
        """
        The Virtual Router Identifier. This is only used when `plan` is not `standard`.
        """
        return pulumi.get(self, "vrid")


@pulumi.output_type
class GetVPCRouterSiteToSiteVpnResult(dict):
    def __init__(__self__, *,
                 local_prefixes: Sequence[str],
                 peer: str,
                 pre_shared_secret: str,
                 remote_id: str,
                 routes: Sequence[str]):
        """
        :param Sequence[str] local_prefixes: A list of CIDR block of the network under the VPC Router.
        :param str peer: The IP address of the opposing appliance connected to the VPC Router.
        :param str pre_shared_secret: The pre shared secret for the VPN.
        :param str remote_id: The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        :param Sequence[str] routes: A list of CIDR block of VPN connected networks.
        """
        pulumi.set(__self__, "local_prefixes", local_prefixes)
        pulumi.set(__self__, "peer", peer)
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "remote_id", remote_id)
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="localPrefixes")
    def local_prefixes(self) -> Sequence[str]:
        """
        A list of CIDR block of the network under the VPC Router.
        """
        return pulumi.get(self, "local_prefixes")

    @property
    @pulumi.getter
    def peer(self) -> str:
        """
        The IP address of the opposing appliance connected to the VPC Router.
        """
        return pulumi.get(self, "peer")

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> str:
        """
        The pre shared secret for the VPN.
        """
        return pulumi.get(self, "pre_shared_secret")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> str:
        """
        The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        """
        return pulumi.get(self, "remote_id")

    @property
    @pulumi.getter
    def routes(self) -> Sequence[str]:
        """
        A list of CIDR block of VPN connected networks.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class GetVPCRouterStaticNatResult(dict):
    def __init__(__self__, *,
                 description: str,
                 private_ip: str,
                 public_ip: str):
        """
        :param str description: The description of the static NAT.
        :param str private_ip: The private IP address used for the static NAT.
        :param str public_ip: The public IP address used for the static NAT.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the static NAT.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address used for the static NAT.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address used for the static NAT.
        """
        return pulumi.get(self, "public_ip")


@pulumi.output_type
class GetVPCRouterStaticRouteResult(dict):
    def __init__(__self__, *,
                 next_hop: str,
                 prefix: str):
        """
        :param str next_hop: The IP address of the next hop.
        :param str prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetVPCRouterUserResult(dict):
    def __init__(__self__, *,
                 name: str,
                 password: str):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param str password: The password used to authenticate remote access.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password used to authenticate remote access.
        """
        return pulumi.get(self, "password")


