# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['MobileGateway']


class MobileGateway(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 inter_device_communication: Optional[pulumi.Input[bool]] = None,
                 internet_connection: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_network_interface: Optional[pulumi.Input[pulumi.InputType['MobileGatewayPrivateNetworkInterfaceArgs']]] = None,
                 sim_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimRouteArgs']]]]] = None,
                 sims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimArgs']]]]] = None,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewayStaticRouteArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_control: Optional[pulumi.Input[pulumi.InputType['MobileGatewayTrafficControlArgs']]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Mobile Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        zone = sakuracloud.get_zone()
        foobar_switch = sakuracloud.Switch("foobarSwitch")
        foobar_mobile_gateway = sakuracloud.MobileGateway("foobarMobileGateway",
            internet_connection=True,
            dns_servers=zone.dns_servers,
            private_network_interface=sakuracloud.MobileGatewayPrivateNetworkInterfaceArgs(
                switch_id=foobar_switch.id,
                ip_address="192.168.11.101",
                netmask=24,
            ),
            description="description",
            tags=[
                "tag1",
                "tag2",
            ],
            traffic_control=sakuracloud.MobileGatewayTrafficControlArgs(
                quota=256,
                band_width_limit=64,
                enable_email=True,
                enable_slack=True,
                slack_webhook="https://hooks.slack.com/services/xxx/xxx/xxx",
                auto_traffic_shaping=True,
            ),
            static_routes=[
                sakuracloud.MobileGatewayStaticRouteArgs(
                    prefix="192.168.10.0/24",
                    next_hop="192.168.11.1",
                ),
                sakuracloud.MobileGatewayStaticRouteArgs(
                    prefix="192.168.10.0/25",
                    next_hop="192.168.11.2",
                ),
                sakuracloud.MobileGatewayStaticRouteArgs(
                    prefix="192.168.10.0/26",
                    next_hop="192.168.11.3",
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the MobileGateway. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: A list of IP address used by each connected devices.
        :param pulumi.Input[str] icon_id: The icon id to attach to the MobileGateway.
        :param pulumi.Input[bool] inter_device_communication: The flag to allow communication between each connected devices.
        :param pulumi.Input[bool] internet_connection: The flag to enable connect to the Internet.
        :param pulumi.Input[str] name: The name of the MobileGateway. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['MobileGatewayPrivateNetworkInterfaceArgs']] private_network_interface: An `private_network_interface` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimRouteArgs']]]] sim_routes: One or more `sim_route` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimArgs']]]] sims: One or more `sim` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewayStaticRouteArgs']]]] static_routes: One or more `static_route` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the MobileGateway.
        :param pulumi.Input[pulumi.InputType['MobileGatewayTrafficControlArgs']] traffic_control: A `traffic_control` block as defined below.
        :param pulumi.Input[str] zone: The name of zone that the MobileGateway will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if dns_servers is None and not opts.urn:
                raise TypeError("Missing required property 'dns_servers'")
            __props__['dns_servers'] = dns_servers
            __props__['icon_id'] = icon_id
            __props__['inter_device_communication'] = inter_device_communication
            __props__['internet_connection'] = internet_connection
            __props__['name'] = name
            __props__['private_network_interface'] = private_network_interface
            __props__['sim_routes'] = sim_routes
            __props__['sims'] = sims
            __props__['static_routes'] = static_routes
            __props__['tags'] = tags
            __props__['traffic_control'] = traffic_control
            __props__['zone'] = zone
            __props__['public_ip'] = None
            __props__['public_netmask'] = None
        super(MobileGateway, __self__).__init__(
            'sakuracloud:index/mobileGateway:MobileGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            inter_device_communication: Optional[pulumi.Input[bool]] = None,
            internet_connection: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_network_interface: Optional[pulumi.Input[pulumi.InputType['MobileGatewayPrivateNetworkInterfaceArgs']]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            public_netmask: Optional[pulumi.Input[int]] = None,
            sim_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimRouteArgs']]]]] = None,
            sims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimArgs']]]]] = None,
            static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewayStaticRouteArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            traffic_control: Optional[pulumi.Input[pulumi.InputType['MobileGatewayTrafficControlArgs']]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'MobileGateway':
        """
        Get an existing MobileGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the MobileGateway. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: A list of IP address used by each connected devices.
        :param pulumi.Input[str] icon_id: The icon id to attach to the MobileGateway.
        :param pulumi.Input[bool] inter_device_communication: The flag to allow communication between each connected devices.
        :param pulumi.Input[bool] internet_connection: The flag to enable connect to the Internet.
        :param pulumi.Input[str] name: The name of the MobileGateway. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['MobileGatewayPrivateNetworkInterfaceArgs']] private_network_interface: An `private_network_interface` block as defined below.
        :param pulumi.Input[str] public_ip: The public IP address assigned to the MobileGateway.
        :param pulumi.Input[int] public_netmask: The bit length of the subnet assigned to the MobileGateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimRouteArgs']]]] sim_routes: One or more `sim_route` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewaySimArgs']]]] sims: One or more `sim` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MobileGatewayStaticRouteArgs']]]] static_routes: One or more `static_route` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the MobileGateway.
        :param pulumi.Input[pulumi.InputType['MobileGatewayTrafficControlArgs']] traffic_control: A `traffic_control` block as defined below.
        :param pulumi.Input[str] zone: The name of zone that the MobileGateway will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["dns_servers"] = dns_servers
        __props__["icon_id"] = icon_id
        __props__["inter_device_communication"] = inter_device_communication
        __props__["internet_connection"] = internet_connection
        __props__["name"] = name
        __props__["private_network_interface"] = private_network_interface
        __props__["public_ip"] = public_ip
        __props__["public_netmask"] = public_netmask
        __props__["sim_routes"] = sim_routes
        __props__["sims"] = sims
        __props__["static_routes"] = static_routes
        __props__["tags"] = tags
        __props__["traffic_control"] = traffic_control
        __props__["zone"] = zone
        return MobileGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the MobileGateway. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IP address used by each connected devices.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the MobileGateway.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="interDeviceCommunication")
    def inter_device_communication(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to allow communication between each connected devices.
        """
        return pulumi.get(self, "inter_device_communication")

    @property
    @pulumi.getter(name="internetConnection")
    def internet_connection(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable connect to the Internet.
        """
        return pulumi.get(self, "internet_connection")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the MobileGateway. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateNetworkInterface")
    def private_network_interface(self) -> pulumi.Output[Optional['outputs.MobileGatewayPrivateNetworkInterface']]:
        """
        An `private_network_interface` block as defined below.
        """
        return pulumi.get(self, "private_network_interface")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public IP address assigned to the MobileGateway.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicNetmask")
    def public_netmask(self) -> pulumi.Output[int]:
        """
        The bit length of the subnet assigned to the MobileGateway.
        """
        return pulumi.get(self, "public_netmask")

    @property
    @pulumi.getter(name="simRoutes")
    def sim_routes(self) -> pulumi.Output[Optional[Sequence['outputs.MobileGatewaySimRoute']]]:
        """
        One or more `sim_route` blocks as defined below.
        """
        return pulumi.get(self, "sim_routes")

    @property
    @pulumi.getter
    def sims(self) -> pulumi.Output[Optional[Sequence['outputs.MobileGatewaySim']]]:
        """
        One or more `sim` blocks as defined below.
        """
        return pulumi.get(self, "sims")

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.MobileGatewayStaticRoute']]]:
        """
        One or more `static_route` blocks as defined below.
        """
        return pulumi.get(self, "static_routes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the MobileGateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficControl")
    def traffic_control(self) -> pulumi.Output[Optional['outputs.MobileGatewayTrafficControl']]:
        """
        A `traffic_control` block as defined below.
        """
        return pulumi.get(self, "traffic_control")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the MobileGateway will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

