# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Internet']


class Internet(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 band_width: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Switch+Router.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar = sakuracloud.Internet("foobar",
            band_width=100,
            description="description",
            enable_ipv6=False,
            netmask=28,
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] band_width: The bandwidth of the network connected to the Internet in Mbps. This must be one of [`100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`3500`/`4000`/`4500`/`5000`]. 
               If zone is `tk1b`, the following values can also be specified [`5500`/`6000`/`6500`/`7000`/`7500`/`8000`/`8500`/`9000`/`9500`/`10000`]. Default:`100`.
        :param pulumi.Input[str] description: The description of the Switch+Router. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] enable_ipv6: The flag to enable IPv6.
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch+Router.
        :param pulumi.Input[str] name: The name of the Switch+Router. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[int] netmask: The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`. Changing this forces a new resource to be created. Default:`28`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Switch+Router.
        :param pulumi.Input[str] zone: The name of zone that the Switch+Router will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['band_width'] = band_width
            __props__['description'] = description
            __props__['enable_ipv6'] = enable_ipv6
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['netmask'] = netmask
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['gateway'] = None
            __props__['ip_addresses'] = None
            __props__['ipv6_network_address'] = None
            __props__['ipv6_prefix'] = None
            __props__['ipv6_prefix_len'] = None
            __props__['max_ip_address'] = None
            __props__['min_ip_address'] = None
            __props__['network_address'] = None
            __props__['server_ids'] = None
            __props__['switch_id'] = None
        super(Internet, __self__).__init__(
            'sakuracloud:index/internet:Internet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            band_width: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_ipv6: Optional[pulumi.Input[bool]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv6_network_address: Optional[pulumi.Input[str]] = None,
            ipv6_prefix: Optional[pulumi.Input[str]] = None,
            ipv6_prefix_len: Optional[pulumi.Input[int]] = None,
            max_ip_address: Optional[pulumi.Input[str]] = None,
            min_ip_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            netmask: Optional[pulumi.Input[int]] = None,
            network_address: Optional[pulumi.Input[str]] = None,
            server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            switch_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Internet':
        """
        Get an existing Internet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] band_width: The bandwidth of the network connected to the Internet in Mbps. This must be one of [`100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`3500`/`4000`/`4500`/`5000`]. 
               If zone is `tk1b`, the following values can also be specified [`5500`/`6000`/`6500`/`7000`/`7500`/`8000`/`8500`/`9000`/`9500`/`10000`]. Default:`100`.
        :param pulumi.Input[str] description: The description of the Switch+Router. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] enable_ipv6: The flag to enable IPv6.
        :param pulumi.Input[str] gateway: The IP address of the gateway used by the Switch+Router.
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch+Router.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: A list of assigned global address to the Switch+Router.
        :param pulumi.Input[str] ipv6_network_address: The IPv6 network address assigned to the Switch+Router.
        :param pulumi.Input[str] ipv6_prefix: The network prefix of assigned IPv6 addresses to the Switch+Router.
        :param pulumi.Input[int] ipv6_prefix_len: The bit length of IPv6 network prefix.
        :param pulumi.Input[str] max_ip_address: Maximum IP address in assigned global addresses to the Switch+Router.
        :param pulumi.Input[str] min_ip_address: Minimum IP address in assigned global addresses to the Switch+Router.
        :param pulumi.Input[str] name: The name of the Switch+Router. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[int] netmask: The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`. Changing this forces a new resource to be created. Default:`28`.
        :param pulumi.Input[str] network_address: The IPv4 network address assigned to the Switch+Router.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_ids: A list of the ID of Servers connected to the Switch+Router.
        :param pulumi.Input[str] switch_id: The id of the switch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Switch+Router.
        :param pulumi.Input[str] zone: The name of zone that the Switch+Router will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["band_width"] = band_width
        __props__["description"] = description
        __props__["enable_ipv6"] = enable_ipv6
        __props__["gateway"] = gateway
        __props__["icon_id"] = icon_id
        __props__["ip_addresses"] = ip_addresses
        __props__["ipv6_network_address"] = ipv6_network_address
        __props__["ipv6_prefix"] = ipv6_prefix
        __props__["ipv6_prefix_len"] = ipv6_prefix_len
        __props__["max_ip_address"] = max_ip_address
        __props__["min_ip_address"] = min_ip_address
        __props__["name"] = name
        __props__["netmask"] = netmask
        __props__["network_address"] = network_address
        __props__["server_ids"] = server_ids
        __props__["switch_id"] = switch_id
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Internet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> pulumi.Output[Optional[int]]:
        """
        The bandwidth of the network connected to the Internet in Mbps. This must be one of [`100`/`250`/`500`/`1000`/`1500`/`2000`/`2500`/`3000`/`3500`/`4000`/`4500`/`5000`]. 
        If zone is `tk1b`, the following values can also be specified [`5500`/`6000`/`6500`/`7000`/`7500`/`8000`/`8500`/`9000`/`9500`/`10000`]. Default:`100`.
        """
        return pulumi.get(self, "band_width")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Switch+Router. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to enable IPv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        """
        The IP address of the gateway used by the Switch+Router.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the Switch+Router.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of assigned global address to the Switch+Router.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="ipv6NetworkAddress")
    def ipv6_network_address(self) -> pulumi.Output[str]:
        """
        The IPv6 network address assigned to the Switch+Router.
        """
        return pulumi.get(self, "ipv6_network_address")

    @property
    @pulumi.getter(name="ipv6Prefix")
    def ipv6_prefix(self) -> pulumi.Output[str]:
        """
        The network prefix of assigned IPv6 addresses to the Switch+Router.
        """
        return pulumi.get(self, "ipv6_prefix")

    @property
    @pulumi.getter(name="ipv6PrefixLen")
    def ipv6_prefix_len(self) -> pulumi.Output[int]:
        """
        The bit length of IPv6 network prefix.
        """
        return pulumi.get(self, "ipv6_prefix_len")

    @property
    @pulumi.getter(name="maxIpAddress")
    def max_ip_address(self) -> pulumi.Output[str]:
        """
        Maximum IP address in assigned global addresses to the Switch+Router.
        """
        return pulumi.get(self, "max_ip_address")

    @property
    @pulumi.getter(name="minIpAddress")
    def min_ip_address(self) -> pulumi.Output[str]:
        """
        Minimum IP address in assigned global addresses to the Switch+Router.
        """
        return pulumi.get(self, "min_ip_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Switch+Router. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[Optional[int]]:
        """
        The bit length of the subnet assigned to the Switch+Router. `26`/`27`/`28`. Changing this forces a new resource to be created. Default:`28`.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> pulumi.Output[str]:
        """
        The IPv4 network address assigned to the Switch+Router.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the ID of Servers connected to the Switch+Router.
        """
        return pulumi.get(self, "server_ids")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Output[str]:
        """
        The id of the switch.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the Switch+Router.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the Switch+Router will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

