# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['IPv4Ptr']


class IPv4Ptr(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 retry_max: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud IPv4 PTR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        server = sakuracloud.Server("server", network_interfaces=[sakuracloud.ServerNetworkInterfaceArgs(
            upstream="shared",
        )])
        foobar = sakuracloud.IPv4Ptr("foobar",
            ip_address=server.ip_address,
            hostname="www.example.com",
            retry_max=30,
            retry_interval=10)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__['hostname'] = hostname
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__['ip_address'] = ip_address
            __props__['retry_interval'] = retry_interval
            __props__['retry_max'] = retry_max
            __props__['zone'] = zone
        super(IPv4Ptr, __self__).__init__(
            'sakuracloud:index/iPv4Ptr:IPv4Ptr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            retry_interval: Optional[pulumi.Input[int]] = None,
            retry_max: Optional[pulumi.Input[int]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'IPv4Ptr':
        """
        Get an existing IPv4Ptr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] hostname: The value of the PTR record. This must be FQDN.
        :param pulumi.Input[str] ip_address: The IP address to which the PTR record is set.
        :param pulumi.Input[int] retry_interval: The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        :param pulumi.Input[int] retry_max: The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        :param pulumi.Input[str] zone: The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["hostname"] = hostname
        __props__["ip_address"] = ip_address
        __props__["retry_interval"] = retry_interval
        __props__["retry_max"] = retry_max
        __props__["zone"] = zone
        return IPv4Ptr(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The value of the PTR record. This must be FQDN.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address to which the PTR record is set.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The wait interval(in seconds) for retrying API call used when SakuraCloud API returns any errors. Default:`10`.
        """
        return pulumi.get(self, "retry_interval")

    @property
    @pulumi.getter(name="retryMax")
    def retry_max(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of API call retries used when SakuraCloud API returns any errors. Default:`30`.
        """
        return pulumi.get(self, "retry_max")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the IPv4 PTR will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

