# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetSwitchResult',
    'AwaitableGetSwitchResult',
    'get_switch',
]

@pulumi.output_type
class GetSwitchResult:
    """
    A collection of values returned by getSwitch.
    """
    def __init__(__self__, bridge_id=None, description=None, filter=None, icon_id=None, id=None, name=None, server_ids=None, tags=None, zone=None):
        if bridge_id and not isinstance(bridge_id, str):
            raise TypeError("Expected argument 'bridge_id' to be a str")
        pulumi.set(__self__, "bridge_id", bridge_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if server_ids and not isinstance(server_ids, list):
            raise TypeError("Expected argument 'server_ids' to be a list")
        pulumi.set(__self__, "server_ids", server_ids)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="bridgeId")
    def bridge_id(self) -> str:
        """
        The bridge id attached to the Switch.
        """
        return pulumi.get(self, "bridge_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Switch.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetSwitchFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the Switch.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Switch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Sequence[str]:
        """
        A list of server id connected to the Switch.
        """
        return pulumi.get(self, "server_ids")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the Switch.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetSwitchResult(GetSwitchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwitchResult(
            bridge_id=self.bridge_id,
            description=self.description,
            filter=self.filter,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            server_ids=self.server_ids,
            tags=self.tags,
            zone=self.zone)


def get_switch(filter: Optional[pulumi.InputType['GetSwitchFilterArgs']] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwitchResult:
    """
    Get information about an existing Switch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_switch(filter=sakuracloud.GetSwitchFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetSwitchFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Switch is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getSwitch:getSwitch', __args__, opts=opts, typ=GetSwitchResult).value

    return AwaitableGetSwitchResult(
        bridge_id=__ret__.bridge_id,
        description=__ret__.description,
        filter=__ret__.filter,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        server_ids=__ret__.server_ids,
        tags=__ret__.tags,
        zone=__ret__.zone)
