# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'GetSubnetResult',
    'AwaitableGetSubnetResult',
    'get_subnet',
]

@pulumi.output_type
class GetSubnetResult:
    """
    A collection of values returned by getSubnet.
    """
    def __init__(__self__, id=None, index=None, internet_id=None, ip_addresses=None, max_ip_address=None, min_ip_address=None, netmask=None, network_address=None, next_hop=None, switch_id=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index and not isinstance(index, int):
            raise TypeError("Expected argument 'index' to be a int")
        pulumi.set(__self__, "index", index)
        if internet_id and not isinstance(internet_id, str):
            raise TypeError("Expected argument 'internet_id' to be a str")
        pulumi.set(__self__, "internet_id", internet_id)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if max_ip_address and not isinstance(max_ip_address, str):
            raise TypeError("Expected argument 'max_ip_address' to be a str")
        pulumi.set(__self__, "max_ip_address", max_ip_address)
        if min_ip_address and not isinstance(min_ip_address, str):
            raise TypeError("Expected argument 'min_ip_address' to be a str")
        pulumi.set(__self__, "min_ip_address", min_ip_address)
        if netmask and not isinstance(netmask, int):
            raise TypeError("Expected argument 'netmask' to be a int")
        pulumi.set(__self__, "netmask", netmask)
        if network_address and not isinstance(network_address, str):
            raise TypeError("Expected argument 'network_address' to be a str")
        pulumi.set(__self__, "network_address", network_address)
        if next_hop and not isinstance(next_hop, str):
            raise TypeError("Expected argument 'next_hop' to be a str")
        pulumi.set(__self__, "next_hop", next_hop)
        if switch_id and not isinstance(switch_id, str):
            raise TypeError("Expected argument 'switch_id' to be a str")
        pulumi.set(__self__, "switch_id", switch_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def index(self) -> int:
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="internetId")
    def internet_id(self) -> str:
        return pulumi.get(self, "internet_id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        A list of assigned global address to the Subnet.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="maxIpAddress")
    def max_ip_address(self) -> str:
        """
        Maximum IP address in assigned global addresses to the Subnet.
        """
        return pulumi.get(self, "max_ip_address")

    @property
    @pulumi.getter(name="minIpAddress")
    def min_ip_address(self) -> str:
        """
        Minimum IP address in assigned global addresses to the Subnet.
        """
        return pulumi.get(self, "min_ip_address")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the Subnet.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        The IPv4 network address assigned to the Subnet.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The ip address of the next-hop at the Subnet.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the Subnet.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetSubnetResult(GetSubnetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetResult(
            id=self.id,
            index=self.index,
            internet_id=self.internet_id,
            ip_addresses=self.ip_addresses,
            max_ip_address=self.max_ip_address,
            min_ip_address=self.min_ip_address,
            netmask=self.netmask,
            network_address=self.network_address,
            next_hop=self.next_hop,
            switch_id=self.switch_id,
            zone=self.zone)


def get_subnet(index: Optional[int] = None,
               internet_id: Optional[str] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetResult:
    """
    Get information about an existing Subnet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    config = pulumi.Config()
    internet_id = config.require_object("internetId")
    foobar = sakuracloud.get_subnet(internet_id=internet_id,
        index=1)
    ```


    :param int index: The index of the subnet in assigned to the Switch+Router. Changing this forces a new resource to be created.
    :param str internet_id: The id of the switch+router resource that the Subnet belongs. Changing this forces a new resource to be created.
    :param str zone: The name of zone that the Subnet is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['index'] = index
    __args__['internetId'] = internet_id
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getSubnet:getSubnet', __args__, opts=opts, typ=GetSubnetResult).value

    return AwaitableGetSubnetResult(
        id=__ret__.id,
        index=__ret__.index,
        internet_id=__ret__.internet_id,
        ip_addresses=__ret__.ip_addresses,
        max_ip_address=__ret__.max_ip_address,
        min_ip_address=__ret__.min_ip_address,
        netmask=__ret__.netmask,
        network_address=__ret__.network_address,
        next_hop=__ret__.next_hop,
        switch_id=__ret__.switch_id,
        zone=__ret__.zone)
