# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetSimpleMonitorResult',
    'AwaitableGetSimpleMonitorResult',
    'get_simple_monitor',
]

@pulumi.output_type
class GetSimpleMonitorResult:
    """
    A collection of values returned by getSimpleMonitor.
    """
    def __init__(__self__, delay_loop=None, description=None, enabled=None, filter=None, health_checks=None, icon_id=None, id=None, notify_email_enabled=None, notify_email_html=None, notify_interval=None, notify_slack_enabled=None, notify_slack_webhook=None, tags=None, target=None):
        if delay_loop and not isinstance(delay_loop, int):
            raise TypeError("Expected argument 'delay_loop' to be a int")
        pulumi.set(__self__, "delay_loop", delay_loop)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if health_checks and not isinstance(health_checks, list):
            raise TypeError("Expected argument 'health_checks' to be a list")
        pulumi.set(__self__, "health_checks", health_checks)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if notify_email_enabled and not isinstance(notify_email_enabled, bool):
            raise TypeError("Expected argument 'notify_email_enabled' to be a bool")
        pulumi.set(__self__, "notify_email_enabled", notify_email_enabled)
        if notify_email_html and not isinstance(notify_email_html, bool):
            raise TypeError("Expected argument 'notify_email_html' to be a bool")
        pulumi.set(__self__, "notify_email_html", notify_email_html)
        if notify_interval and not isinstance(notify_interval, int):
            raise TypeError("Expected argument 'notify_interval' to be a int")
        pulumi.set(__self__, "notify_interval", notify_interval)
        if notify_slack_enabled and not isinstance(notify_slack_enabled, bool):
            raise TypeError("Expected argument 'notify_slack_enabled' to be a bool")
        pulumi.set(__self__, "notify_slack_enabled", notify_slack_enabled)
        if notify_slack_webhook and not isinstance(notify_slack_webhook, str):
            raise TypeError("Expected argument 'notify_slack_webhook' to be a str")
        pulumi.set(__self__, "notify_slack_webhook", notify_slack_webhook)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> int:
        """
        The interval in seconds between checks.
        """
        return pulumi.get(self, "delay_loop")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the SimpleMonitor.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The flag to enable monitoring by the simple monitor.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetSimpleMonitorFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetSimpleMonitorHealthCheckResult']:
        """
        A list of `health_check` blocks as defined below.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the SimpleMonitor.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="notifyEmailEnabled")
    def notify_email_enabled(self) -> bool:
        """
        The flag to enable notification by email.
        """
        return pulumi.get(self, "notify_email_enabled")

    @property
    @pulumi.getter(name="notifyEmailHtml")
    def notify_email_html(self) -> bool:
        """
        The flag to enable HTML format instead of text format.
        """
        return pulumi.get(self, "notify_email_html")

    @property
    @pulumi.getter(name="notifyInterval")
    def notify_interval(self) -> int:
        """
        The interval in hours between notification.
        """
        return pulumi.get(self, "notify_interval")

    @property
    @pulumi.getter(name="notifySlackEnabled")
    def notify_slack_enabled(self) -> bool:
        """
        The flag to enable notification by slack/discord.
        """
        return pulumi.get(self, "notify_slack_enabled")

    @property
    @pulumi.getter(name="notifySlackWebhook")
    def notify_slack_webhook(self) -> str:
        """
        The webhook URL for sending notification by slack/discord.
        """
        return pulumi.get(self, "notify_slack_webhook")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the SimpleMonitor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The monitoring target of the simple monitor. This will be IP address or FQDN.
        """
        return pulumi.get(self, "target")


class AwaitableGetSimpleMonitorResult(GetSimpleMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSimpleMonitorResult(
            delay_loop=self.delay_loop,
            description=self.description,
            enabled=self.enabled,
            filter=self.filter,
            health_checks=self.health_checks,
            icon_id=self.icon_id,
            id=self.id,
            notify_email_enabled=self.notify_email_enabled,
            notify_email_html=self.notify_email_html,
            notify_interval=self.notify_interval,
            notify_slack_enabled=self.notify_slack_enabled,
            notify_slack_webhook=self.notify_slack_webhook,
            tags=self.tags,
            target=self.target)


def get_simple_monitor(filter: Optional[pulumi.InputType['GetSimpleMonitorFilterArgs']] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSimpleMonitorResult:
    """
    Get information about an existing Simple Monitor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_simple_monitor(filter=sakuracloud.GetSimpleMonitorFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetSimpleMonitorFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    __args__ = dict()
    __args__['filter'] = filter
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getSimpleMonitor:getSimpleMonitor', __args__, opts=opts, typ=GetSimpleMonitorResult).value

    return AwaitableGetSimpleMonitorResult(
        delay_loop=__ret__.delay_loop,
        description=__ret__.description,
        enabled=__ret__.enabled,
        filter=__ret__.filter,
        health_checks=__ret__.health_checks,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        notify_email_enabled=__ret__.notify_email_enabled,
        notify_email_html=__ret__.notify_email_html,
        notify_interval=__ret__.notify_interval,
        notify_slack_enabled=__ret__.notify_slack_enabled,
        notify_slack_webhook=__ret__.notify_slack_webhook,
        tags=__ret__.tags,
        target=__ret__.target)
