# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'GetServerVNCInfoResult',
    'AwaitableGetServerVNCInfoResult',
    'get_server_vnc_info',
]

@pulumi.output_type
class GetServerVNCInfoResult:
    """
    A collection of values returned by getServerVNCInfo.
    """
    def __init__(__self__, host=None, id=None, password=None, port=None, server_id=None, zone=None):
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The host name for connecting by VNC.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for connecting by VNC.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number for connecting by VNC.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetServerVNCInfoResult(GetServerVNCInfoResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerVNCInfoResult(
            host=self.host,
            id=self.id,
            password=self.password,
            port=self.port,
            server_id=self.server_id,
            zone=self.zone)


def get_server_vnc_info(server_id: Optional[str] = None,
                        zone: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerVNCInfoResult:
    """
    Get information about VNC for connecting to an existing Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_server_vnc_info(server_id=sakuracloud_server["foobar"]["id"])
    ```


    :param str server_id: The id of the Server.
    :param str zone: The name of zone that the Server is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['serverId'] = server_id
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getServerVNCInfo:getServerVNCInfo', __args__, opts=opts, typ=GetServerVNCInfoResult).value

    return AwaitableGetServerVNCInfoResult(
        host=__ret__.host,
        id=__ret__.id,
        password=__ret__.password,
        port=__ret__.port,
        server_id=__ret__.server_id,
        zone=__ret__.zone)
