# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateHostResult',
    'AwaitableGetPrivateHostResult',
    'get_private_host',
]

@pulumi.output_type
class GetPrivateHostResult:
    """
    A collection of values returned by getPrivateHost.
    """
    def __init__(__self__, assigned_core=None, assigned_memory=None, class_=None, description=None, filter=None, hostname=None, icon_id=None, id=None, name=None, tags=None, zone=None):
        if assigned_core and not isinstance(assigned_core, int):
            raise TypeError("Expected argument 'assigned_core' to be a int")
        pulumi.set(__self__, "assigned_core", assigned_core)
        if assigned_memory and not isinstance(assigned_memory, int):
            raise TypeError("Expected argument 'assigned_memory' to be a int")
        pulumi.set(__self__, "assigned_memory", assigned_memory)
        if class_ and not isinstance(class_, str):
            raise TypeError("Expected argument 'class_' to be a str")
        pulumi.set(__self__, "class_", class_)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="assignedCore")
    def assigned_core(self) -> int:
        """
        The total number of CPUs assigned to servers on the private host.
        """
        return pulumi.get(self, "assigned_core")

    @property
    @pulumi.getter(name="assignedMemory")
    def assigned_memory(self) -> int:
        """
        The total size of memory assigned to servers on the private host.
        """
        return pulumi.get(self, "assigned_memory")

    @property
    @pulumi.getter(name="class")
    def class_(self) -> str:
        """
        The class of the PrivateHost. This will be one of [`dynamic`/`ms_windows`].
        """
        return pulumi.get(self, "class_")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the PrivateHost.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetPrivateHostFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of the private host.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the PrivateHost.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the PrivateHost.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the PrivateHost.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetPrivateHostResult(GetPrivateHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateHostResult(
            assigned_core=self.assigned_core,
            assigned_memory=self.assigned_memory,
            class_=self.class_,
            description=self.description,
            filter=self.filter,
            hostname=self.hostname,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            tags=self.tags,
            zone=self.zone)


def get_private_host(filter: Optional[pulumi.InputType['GetPrivateHostFilterArgs']] = None,
                     zone: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateHostResult:
    """
    Get information about an existing Private Host.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_private_host(filter=sakuracloud.GetPrivateHostFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetPrivateHostFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the PrivateHost is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getPrivateHost:getPrivateHost', __args__, opts=opts, typ=GetPrivateHostResult).value

    return AwaitableGetPrivateHostResult(
        assigned_core=__ret__.assigned_core,
        assigned_memory=__ret__.assigned_memory,
        class_=__ret__.class_,
        description=__ret__.description,
        filter=__ret__.filter,
        hostname=__ret__.hostname,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        tags=__ret__.tags,
        zone=__ret__.zone)
