# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerRegistryResult',
    'AwaitableGetContainerRegistryResult',
    'get_container_registry',
]

@pulumi.output_type
class GetContainerRegistryResult:
    """
    A collection of values returned by getContainerRegistry.
    """
    def __init__(__self__, access_level=None, description=None, filter=None, fqdn=None, icon_id=None, id=None, name=None, subdomain_label=None, tags=None, users=None, virtual_domain=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if subdomain_label and not isinstance(subdomain_label, str):
            raise TypeError("Expected argument 'subdomain_label' to be a str")
        pulumi.set(__self__, "subdomain_label", subdomain_label)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if virtual_domain and not isinstance(virtual_domain, str):
            raise TypeError("Expected argument 'virtual_domain' to be a str")
        pulumi.set(__self__, "virtual_domain", virtual_domain)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        The level of access that allow to users. This will be one of [`readwrite`/`readonly`/`none`].
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the ContainerRegistry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetContainerRegistryFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The FQDN for accessing the container registry. FQDN is built from `subdomain_label` + `.sakuracr.jp`.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the ContainerRegistry.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user name used to authenticate remote access.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subdomainLabel")
    def subdomain_label(self) -> str:
        """
        The label at the lowest of the FQDN used when be accessed from users.
        """
        return pulumi.get(self, "subdomain_label")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the ContainerRegistry.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetContainerRegistryUserResult']:
        """
        A list of `user` blocks as defined below.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter(name="virtualDomain")
    def virtual_domain(self) -> str:
        """
        The alias for accessing the container registry.
        """
        return pulumi.get(self, "virtual_domain")


class AwaitableGetContainerRegistryResult(GetContainerRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryResult(
            access_level=self.access_level,
            description=self.description,
            filter=self.filter,
            fqdn=self.fqdn,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            subdomain_label=self.subdomain_label,
            tags=self.tags,
            users=self.users,
            virtual_domain=self.virtual_domain)


def get_container_registry(filter: Optional[pulumi.InputType['GetContainerRegistryFilterArgs']] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryResult:
    """
    Get information about an existing Container Registry.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_container_registry(filter=sakuracloud.GetContainerRegistryFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetContainerRegistryFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    __args__ = dict()
    __args__['filter'] = filter
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts, typ=GetContainerRegistryResult).value

    return AwaitableGetContainerRegistryResult(
        access_level=__ret__.access_level,
        description=__ret__.description,
        filter=__ret__.filter,
        fqdn=__ret__.fqdn,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        subdomain_label=__ret__.subdomain_label,
        tags=__ret__.tags,
        users=__ret__.users,
        virtual_domain=__ret__.virtual_domain)
