# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'GetBucketObjectResult',
    'AwaitableGetBucketObjectResult',
    'get_bucket_object',
]

@pulumi.output_type
class GetBucketObjectResult:
    """
    A collection of values returned by getBucketObject.
    """
    def __init__(__self__, access_key=None, body=None, bucket=None, content_type=None, etag=None, http_cache_url=None, http_path_url=None, http_url=None, https_cache_url=None, https_path_url=None, https_url=None, id=None, key=None, last_modified=None, secret_key=None, size=None):
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if http_cache_url and not isinstance(http_cache_url, str):
            raise TypeError("Expected argument 'http_cache_url' to be a str")
        pulumi.set(__self__, "http_cache_url", http_cache_url)
        if http_path_url and not isinstance(http_path_url, str):
            raise TypeError("Expected argument 'http_path_url' to be a str")
        pulumi.set(__self__, "http_path_url", http_path_url)
        if http_url and not isinstance(http_url, str):
            raise TypeError("Expected argument 'http_url' to be a str")
        pulumi.set(__self__, "http_url", http_url)
        if https_cache_url and not isinstance(https_cache_url, str):
            raise TypeError("Expected argument 'https_cache_url' to be a str")
        pulumi.set(__self__, "https_cache_url", https_cache_url)
        if https_path_url and not isinstance(https_path_url, str):
            raise TypeError("Expected argument 'https_path_url' to be a str")
        pulumi.set(__self__, "https_path_url", https_path_url)
        if https_url and not isinstance(https_url, str):
            raise TypeError("Expected argument 'https_url' to be a str")
        pulumi.set(__self__, "https_url", https_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if secret_key and not isinstance(secret_key, str):
            raise TypeError("Expected argument 'secret_key' to be a str")
        pulumi.set(__self__, "secret_key", secret_key)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The body of the BucketObject.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the BucketObject.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The etag of the BucketObject.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="httpCacheUrl")
    def http_cache_url(self) -> str:
        """
        The URL for cached access to the BucketObject via HTTP.
        """
        return pulumi.get(self, "http_cache_url")

    @property
    @pulumi.getter(name="httpPathUrl")
    def http_path_url(self) -> str:
        """
        The URL with path-format for accessing the BucketObject via HTTP.
        """
        return pulumi.get(self, "http_path_url")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> str:
        """
        The URL for accessing the BucketObject via HTTP.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="httpsCacheUrl")
    def https_cache_url(self) -> str:
        """
        The URL for cached access to the BucketObject via HTTPS.
        """
        return pulumi.get(self, "https_cache_url")

    @property
    @pulumi.getter(name="httpsPathUrl")
    def https_path_url(self) -> str:
        """
        The URL with path-format for accessing the BucketObject via HTTPS.
        """
        return pulumi.get(self, "https_path_url")

    @property
    @pulumi.getter(name="httpsUrl")
    def https_url(self) -> str:
        """
        The URL for accessing the BucketObject via HTTPS.
        """
        return pulumi.get(self, "https_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        The time when the BucketObject last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the BucketObject in bytes.
        """
        return pulumi.get(self, "size")


class AwaitableGetBucketObjectResult(GetBucketObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketObjectResult(
            access_key=self.access_key,
            body=self.body,
            bucket=self.bucket,
            content_type=self.content_type,
            etag=self.etag,
            http_cache_url=self.http_cache_url,
            http_path_url=self.http_path_url,
            http_url=self.http_url,
            https_cache_url=self.https_cache_url,
            https_path_url=self.https_path_url,
            https_url=self.https_url,
            id=self.id,
            key=self.key,
            last_modified=self.last_modified,
            secret_key=self.secret_key,
            size=self.size)


def get_bucket_object(access_key: Optional[str] = None,
                      bucket: Optional[str] = None,
                      key: Optional[str] = None,
                      secret_key: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketObjectResult:
    """
    Get information about an existing Bucket Object.


    :param str access_key: The access key for using SakuraCloud Object Storage API.
    :param str bucket: The name of bucket.
    :param str key: The name of the BucketObject.
    :param str secret_key: The secret key for using SakuraCloud Object Storage API.
    """
    __args__ = dict()
    __args__['accessKey'] = access_key
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['secretKey'] = secret_key
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getBucketObject:getBucketObject', __args__, opts=opts, typ=GetBucketObjectResult).value

    return AwaitableGetBucketObjectResult(
        access_key=__ret__.access_key,
        body=__ret__.body,
        bucket=__ret__.bucket,
        content_type=__ret__.content_type,
        etag=__ret__.etag,
        http_cache_url=__ret__.http_cache_url,
        http_path_url=__ret__.http_path_url,
        http_url=__ret__.http_url,
        https_cache_url=__ret__.https_cache_url,
        https_path_url=__ret__.https_path_url,
        https_url=__ret__.https_url,
        id=__ret__.id,
        key=__ret__.key,
        last_modified=__ret__.last_modified,
        secret_key=__ret__.secret_key,
        size=__ret__.size)
