# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetBridgeResult',
    'AwaitableGetBridgeResult',
    'get_bridge',
]

@pulumi.output_type
class GetBridgeResult:
    """
    A collection of values returned by getBridge.
    """
    def __init__(__self__, description=None, filter=None, id=None, name=None, zone=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Bridge.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetBridgeFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Bridge.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetBridgeResult(GetBridgeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBridgeResult(
            description=self.description,
            filter=self.filter,
            id=self.id,
            name=self.name,
            zone=self.zone)


def get_bridge(filter: Optional[pulumi.InputType['GetBridgeFilterArgs']] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBridgeResult:
    """
    Get information about an existing Bridge.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_bridge(filter=sakuracloud.GetBridgeFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetBridgeFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Bridge is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getBridge:getBridge', __args__, opts=opts, typ=GetBridgeResult).value

    return AwaitableGetBridgeResult(
        description=__ret__.description,
        filter=__ret__.filter,
        id=__ret__.id,
        name=__ret__.name,
        zone=__ret__.zone)
