# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['DatabaseReadReplica']


class DatabaseReadReplica(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 master_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaNetworkInterfaceArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Database Read Replica.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        master = sakuracloud.get_database(filter=sakuracloud.GetDatabaseFilterArgs(
            names=["master-database-name"],
        ))
        foobar = sakuracloud.DatabaseReadReplica("foobar",
            master_id=master.id,
            network_interface=sakuracloud.DatabaseReadReplicaNetworkInterfaceArgs(
                ip_address="192.168.11.111",
            ),
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the read-replica database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the read-replica database.
        :param pulumi.Input[str] master_id: The id of the replication master database. Changing this forces a new resource to be created.
        :param pulumi.Input[str] name: The name of the read-replica database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the read-replica database.
        :param pulumi.Input[str] zone: The name of zone that the read-replica database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['icon_id'] = icon_id
            if master_id is None and not opts.urn:
                raise TypeError("Missing required property 'master_id'")
            __props__['master_id'] = master_id
            __props__['name'] = name
            if network_interface is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface'")
            __props__['network_interface'] = network_interface
            __props__['tags'] = tags
            __props__['zone'] = zone
        super(DatabaseReadReplica, __self__).__init__(
            'sakuracloud:index/databaseReadReplica:DatabaseReadReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            master_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaNetworkInterfaceArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'DatabaseReadReplica':
        """
        Get an existing DatabaseReadReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the read-replica database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the read-replica database.
        :param pulumi.Input[str] master_id: The id of the replication master database. Changing this forces a new resource to be created.
        :param pulumi.Input[str] name: The name of the read-replica database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the read-replica database.
        :param pulumi.Input[str] zone: The name of zone that the read-replica database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["icon_id"] = icon_id
        __props__["master_id"] = master_id
        __props__["name"] = name
        __props__["network_interface"] = network_interface
        __props__["tags"] = tags
        __props__["zone"] = zone
        return DatabaseReadReplica(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the read-replica database. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the read-replica database.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter(name="masterId")
    def master_id(self) -> pulumi.Output[str]:
        """
        The id of the replication master database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "master_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the read-replica database. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Output['outputs.DatabaseReadReplicaNetworkInterface']:
        """
        An `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the read-replica database.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the read-replica database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

