# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Database']


class Database(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['DatabaseBackupArgs']]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 replica_password: Optional[pulumi.Input[str]] = None,
                 replica_user: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        config = pulumi.Config()
        username = config.require_object("username")
        password = config.require_object("password")
        replica_password = config.require_object("replicaPassword")
        foobar_switch = sakuracloud.Switch("foobarSwitch")
        foobar_database = sakuracloud.Database("foobarDatabase",
            database_type="mariadb",
            plan="30g",
            username=username,
            password=password,
            replica_password=replica_password,
            network_interface=sakuracloud.DatabaseNetworkInterfaceArgs(
                switch_id=foobar_switch.id,
                ip_address="192.168.11.11",
                netmask=24,
                gateway="192.168.11.1",
                port=3306,
                source_ranges=[
                    "192.168.11.0/24",
                    "192.168.12.0/24",
                ],
            ),
            backup=sakuracloud.DatabaseBackupArgs(
                time="00:00",
                weekdays=[
                    "mon",
                    "tue",
                ],
            ),
            parameters={
                "max_connections": "100",
            },
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseBackupArgs']] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['backup'] = backup
            __props__['database_type'] = database_type
            __props__['description'] = description
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            if network_interface is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface'")
            __props__['network_interface'] = network_interface
            __props__['parameters'] = parameters
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__['password'] = password
            __props__['plan'] = plan
            __props__['replica_password'] = replica_password
            __props__['replica_user'] = replica_user
            __props__['tags'] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['zone'] = zone
        super(Database, __self__).__init__(
            'sakuracloud:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup: Optional[pulumi.Input[pulumi.InputType['DatabaseBackupArgs']]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            replica_password: Optional[pulumi.Input[str]] = None,
            replica_user: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseBackupArgs']] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backup"] = backup
        __props__["database_type"] = database_type
        __props__["description"] = description
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["network_interface"] = network_interface
        __props__["parameters"] = parameters
        __props__["password"] = password
        __props__["plan"] = plan
        __props__["replica_password"] = replica_password
        __props__["replica_user"] = replica_user
        __props__["tags"] = tags
        __props__["username"] = username
        __props__["zone"] = zone
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.DatabaseBackup']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Database. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the Database.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Database. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Output['outputs.DatabaseNetworkInterface']:
        """
        An `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password of default user on the database.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="replicaPassword")
    def replica_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of user that processing a replication.
        """
        return pulumi.get(self, "replica_password")

    @property
    @pulumi.getter(name="replicaUser")
    def replica_user(self) -> pulumi.Output[Optional[str]]:
        """
        The name of user that processing a replication. Default:`replica`.
        """
        return pulumi.get(self, "replica_user")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the Database.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

