# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['BucketObject']


class BucketObject(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a SakuraCloud Bucket Object.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar = sakuracloud.BucketObject("foobar",
            bucket="foobar",
            key="example.txt",
            content=(lambda path: open(path).read())("example.txt"))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key for using SakuraCloud Object Storage API.
        :param pulumi.Input[str] bucket: The name of the bucket. Changing this forces a new resource to be created.
        :param pulumi.Input[str] content: The content to upload to as the bucket object. This conflicts with [`source`].
        :param pulumi.Input[str] content_type: The content-type of the bucket object.
        :param pulumi.Input[str] etag: The etag of the bucket object.
        :param pulumi.Input[str] key: The name of the bucket object. Changing this forces a new resource to be created.
        :param pulumi.Input[str] secret_key: The secret key for using SakuraCloud Object Storage API.
        :param pulumi.Input[str] source: The file path to upload to as the bucket object. This conflicts with [`content`].
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__['access_key'] = access_key
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__['bucket'] = bucket
            __props__['content'] = content
            __props__['content_type'] = content_type
            __props__['etag'] = etag
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__['key'] = key
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__['secret_key'] = secret_key
            __props__['source'] = source
            __props__['http_cache_url'] = None
            __props__['http_path_url'] = None
            __props__['http_url'] = None
            __props__['https_cache_url'] = None
            __props__['https_path_url'] = None
            __props__['https_url'] = None
            __props__['last_modified'] = None
            __props__['size'] = None
        super(BucketObject, __self__).__init__(
            'sakuracloud:index/bucketObject:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            http_cache_url: Optional[pulumi.Input[str]] = None,
            http_path_url: Optional[pulumi.Input[str]] = None,
            http_url: Optional[pulumi.Input[str]] = None,
            https_cache_url: Optional[pulumi.Input[str]] = None,
            https_path_url: Optional[pulumi.Input[str]] = None,
            https_url: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            secret_key: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'BucketObject':
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key for using SakuraCloud Object Storage API.
        :param pulumi.Input[str] bucket: The name of the bucket. Changing this forces a new resource to be created.
        :param pulumi.Input[str] content: The content to upload to as the bucket object. This conflicts with [`source`].
        :param pulumi.Input[str] content_type: The content-type of the bucket object.
        :param pulumi.Input[str] etag: The etag of the bucket object.
        :param pulumi.Input[str] http_cache_url: The URL for cached access to the bucket object via HTTP.
        :param pulumi.Input[str] http_path_url: The URL with path-format for accessing the bucket object via HTTP.
        :param pulumi.Input[str] http_url: The URL for accessing the bucket object via HTTP.
        :param pulumi.Input[str] https_cache_url: The URL for cached access to the bucket object via HTTPS.
        :param pulumi.Input[str] https_path_url: The URL with path-format for accessing the bucket object via HTTPS.
        :param pulumi.Input[str] https_url: The URL for accessing the bucket object via HTTPS.
        :param pulumi.Input[str] key: The name of the bucket object. Changing this forces a new resource to be created.
        :param pulumi.Input[str] last_modified: The time when the bucket object last modified.
        :param pulumi.Input[str] secret_key: The secret key for using SakuraCloud Object Storage API.
        :param pulumi.Input[int] size: The size of the bucket object in bytes.
        :param pulumi.Input[str] source: The file path to upload to as the bucket object. This conflicts with [`content`].
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_key"] = access_key
        __props__["bucket"] = bucket
        __props__["content"] = content
        __props__["content_type"] = content_type
        __props__["etag"] = etag
        __props__["http_cache_url"] = http_cache_url
        __props__["http_path_url"] = http_path_url
        __props__["http_url"] = http_url
        __props__["https_cache_url"] = https_cache_url
        __props__["https_path_url"] = https_path_url
        __props__["https_url"] = https_url
        __props__["key"] = key
        __props__["last_modified"] = last_modified
        __props__["secret_key"] = secret_key
        __props__["size"] = size
        __props__["source"] = source
        return BucketObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[str]:
        """
        The access key for using SakuraCloud Object Storage API.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[str]]:
        """
        The content to upload to as the bucket object. This conflicts with [`source`].
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        The content-type of the bucket object.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The etag of the bucket object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="httpCacheUrl")
    def http_cache_url(self) -> pulumi.Output[str]:
        """
        The URL for cached access to the bucket object via HTTP.
        """
        return pulumi.get(self, "http_cache_url")

    @property
    @pulumi.getter(name="httpPathUrl")
    def http_path_url(self) -> pulumi.Output[str]:
        """
        The URL with path-format for accessing the bucket object via HTTP.
        """
        return pulumi.get(self, "http_path_url")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> pulumi.Output[str]:
        """
        The URL for accessing the bucket object via HTTP.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="httpsCacheUrl")
    def https_cache_url(self) -> pulumi.Output[str]:
        """
        The URL for cached access to the bucket object via HTTPS.
        """
        return pulumi.get(self, "https_cache_url")

    @property
    @pulumi.getter(name="httpsPathUrl")
    def https_path_url(self) -> pulumi.Output[str]:
        """
        The URL with path-format for accessing the bucket object via HTTPS.
        """
        return pulumi.get(self, "https_path_url")

    @property
    @pulumi.getter(name="httpsUrl")
    def https_url(self) -> pulumi.Output[str]:
        """
        The URL for accessing the bucket object via HTTPS.
        """
        return pulumi.get(self, "https_url")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The name of the bucket object. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        The time when the bucket object last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[str]:
        """
        The secret key for using SakuraCloud Object Storage API.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of the bucket object in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[str]]:
        """
        The file path to upload to as the bucket object. This conflicts with [`content`].
        """
        return pulumi.get(self, "source")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

