# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'ContainerRegistryUserArgs',
    'DNSRecordArgs',
    'DatabaseBackupArgs',
    'DatabaseNetworkInterfaceArgs',
    'DatabaseReadReplicaNetworkInterfaceArgs',
    'GSLBHealthCheckArgs',
    'GSLBServerArgs',
    'LoadBalancerNetworkInterfaceArgs',
    'LoadBalancerVipArgs',
    'LoadBalancerVipServerArgs',
    'LocalRouterNetworkInterfaceArgs',
    'LocalRouterPeerArgs',
    'LocalRouterStaticRouteArgs',
    'LocalRouterSwitchArgs',
    'MobileGatewayPrivateNetworkInterfaceArgs',
    'MobileGatewaySimArgs',
    'MobileGatewaySimRouteArgs',
    'MobileGatewayStaticRouteArgs',
    'MobileGatewayTrafficControlArgs',
    'NFSNetworkInterfaceArgs',
    'PacketFilterExpressionArgs',
    'PacketFilterRuleExpressionArgs',
    'ProxyLBACMECertificateArgs',
    'ProxyLBACMECertificateAdditionalCertificateArgs',
    'ProxyLBBindPortArgs',
    'ProxyLBBindPortResponseHeaderArgs',
    'ProxyLBCertificateArgs',
    'ProxyLBCertificateAdditionalCertificateArgs',
    'ProxyLBHealthCheckArgs',
    'ProxyLBRuleArgs',
    'ProxyLBServerArgs',
    'ProxyLBSorryServerArgs',
    'ServerDiskEditParameterArgs',
    'ServerDiskEditParameterNoteArgs',
    'ServerNetworkInterfaceArgs',
    'SimpleMonitorHealthCheckArgs',
    'VPCRouterDhcpServerArgs',
    'VPCRouterDhcpStaticMappingArgs',
    'VPCRouterFirewallArgs',
    'VPCRouterFirewallExpressionArgs',
    'VPCRouterL2tpArgs',
    'VPCRouterPortForwardingArgs',
    'VPCRouterPptpArgs',
    'VPCRouterPrivateNetworkInterfaceArgs',
    'VPCRouterPublicNetworkInterfaceArgs',
    'VPCRouterSiteToSiteVpnArgs',
    'VPCRouterStaticNatArgs',
    'VPCRouterStaticRouteArgs',
    'VPCRouterUserArgs',
    'GetArchiveFilterArgs',
    'GetArchiveFilterConditionArgs',
    'GetBridgeFilterArgs',
    'GetBridgeFilterConditionArgs',
    'GetCDROMFilterArgs',
    'GetCDROMFilterConditionArgs',
    'GetContainerRegistryFilterArgs',
    'GetContainerRegistryFilterConditionArgs',
    'GetDNSFilterArgs',
    'GetDNSFilterConditionArgs',
    'GetDatabaseFilterArgs',
    'GetDatabaseFilterConditionArgs',
    'GetDiskFilterArgs',
    'GetDiskFilterConditionArgs',
    'GetESMEFilterArgs',
    'GetESMEFilterConditionArgs',
    'GetGSLBFilterArgs',
    'GetGSLBFilterConditionArgs',
    'GetIconFilterArgs',
    'GetIconFilterConditionArgs',
    'GetInternetFilterArgs',
    'GetInternetFilterConditionArgs',
    'GetLoadBalancerFilterArgs',
    'GetLoadBalancerFilterConditionArgs',
    'GetLocalRouterFilterArgs',
    'GetLocalRouterFilterConditionArgs',
    'GetNFSFilterArgs',
    'GetNFSFilterConditionArgs',
    'GetNoteFilterArgs',
    'GetNoteFilterConditionArgs',
    'GetPacketFilterFilterArgs',
    'GetPacketFilterFilterConditionArgs',
    'GetPrivateHostFilterArgs',
    'GetPrivateHostFilterConditionArgs',
    'GetProxyLBFilterArgs',
    'GetProxyLBFilterConditionArgs',
    'GetSSHKeyFilterArgs',
    'GetSSHKeyFilterConditionArgs',
    'GetServerFilterArgs',
    'GetServerFilterConditionArgs',
    'GetSimpleMonitorFilterArgs',
    'GetSimpleMonitorFilterConditionArgs',
    'GetSwitchFilterArgs',
    'GetSwitchFilterConditionArgs',
    'GetVPCRouterFilterArgs',
    'GetVPCRouterFilterConditionArgs',
]

@pulumi.input_type
class ContainerRegistryUserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 permission: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The user name used to authenticate remote access.
        :param pulumi.Input[str] password: The password used to authenticate remote access.
        :param pulumi.Input[str] permission: The level of access that allow to the user. This must be one of [`all`/`readwrite`/`readonly`].
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The user name used to authenticate remote access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password used to authenticate remote access.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[str]:
        """
        The level of access that allow to the user. This must be one of [`all`/`readwrite`/`readonly`].
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission", value)


@pulumi.input_type
class DNSRecordArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: The name of the DNS Record. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] type: The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        :param pulumi.Input[str] value: The value of the DNS Record.
        :param pulumi.Input[int] port: The number of port. This must be in the range [`1`-`65535`].
        :param pulumi.Input[int] priority: The priority of target DNS Record. This must be in the range [`0`-`65535`].
        :param pulumi.Input[int] ttl: The number of the TTL.
        :param pulumi.Input[int] weight: The weight of target DNS Record. This must be in the range [`0`-`65535`].
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the DNS Record. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`].
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the DNS Record.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The number of port. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of target DNS Record. This must be in the range [`0`-`65535`].
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight of target DNS Record. This must be in the range [`0`-`65535`].
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class DatabaseBackupArgs:
    def __init__(__self__, *,
                 time: Optional[pulumi.Input[str]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] time: The time to take backup. This must be formatted with `HH:mm`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] weekdays: A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        The time to take backup. This must be formatted with `HH:mm`.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`].
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "weekdays", value)


@pulumi.input_type
class DatabaseNetworkInterfaceArgs:
    def __init__(__self__, *,
                 gateway: pulumi.Input[str],
                 ip_address: pulumi.Input[str],
                 netmask: pulumi.Input[int],
                 switch_id: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] gateway: The IP address of the gateway used by Database.
        :param pulumi.Input[str] ip_address: The IP address to assign to the Database.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the Database. This must be in the range [`8`-`29`].
        :param pulumi.Input[str] switch_id: The id of the switch to which the Database connects.
        :param pulumi.Input[int] port: The number of the listening port. This must be in the range [`1024`-`65535`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The range of source IP addresses that allow to access to the Database via network.
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        """
        The IP address of the gateway used by Database.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to assign to the Database.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet to assign to the Database. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Input[str]:
        """
        The id of the switch to which the Database connects.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "switch_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the listening port. This must be in the range [`1024`-`65535`].
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The range of source IP addresses that allow to access to the Database via network.
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ranges", value)


@pulumi.input_type
class DatabaseReadReplicaNetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 gateway: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[int]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address to assign to the read-replica database.
        :param pulumi.Input[str] gateway: The IP address of the gateway used by read-replica database. If `gateway` isn't specified, it will be set to the same value of the master database.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the read-replica database. This must be in the range [`8`-`29`]. If `netmask` isn't specified, it will be set to the same value of the master database.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ranges: The range of source IP addresses that allow to access to the read-replica database via network.
        :param pulumi.Input[str] switch_id: The id of the switch to which the read-replica database connects. If `switch_id` isn't specified, it will be set to the same value of the master database.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to assign to the read-replica database.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the gateway used by read-replica database. If `gateway` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The bit length of the subnet to assign to the read-replica database. This must be in the range [`8`-`29`]. If `netmask` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The range of source IP addresses that allow to access to the read-replica database via network.
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ranges", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the switch to which the read-replica database connects. If `switch_id` isn't specified, it will be set to the same value of the master database.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_id", value)


@pulumi.input_type
class GSLBHealthCheckArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 delay_loop: Optional[pulumi.Input[int]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] protocol: The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        :param pulumi.Input[int] delay_loop: The interval in seconds between checks. This must be in the range [`10`-`60`].
        :param pulumi.Input[str] host_header: The value of host header send when checking by HTTP/HTTPS.
        :param pulumi.Input[str] path: The path used when checking by HTTP/HTTPS.
        :param pulumi.Input[int] port: The port number used when checking by TCP.
        :param pulumi.Input[str] status: The response-code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "protocol", protocol)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`60`].
        """
        return pulumi.get(self, "delay_loop")

    @delay_loop.setter
    def delay_loop(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_loop", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number used when checking by TCP.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class GSLBServerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address of the server.
        :param pulumi.Input[bool] enabled: The flag to enable as destination of load balancing.
        :param pulumi.Input[int] weight: The weight used when weighted load balancing is enabled. This must be in the range [`1`-`10000`].
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the server.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight used when weighted load balancing is enabled. This must be in the range [`1`-`10000`].
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class LoadBalancerNetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 netmask: pulumi.Input[int],
                 switch_id: pulumi.Input[str],
                 vrid: pulumi.Input[int],
                 gateway: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: A list of IP address to assign to the LoadBalancer. .
        :param pulumi.Input[int] netmask: The bit length of the subnet assigned to the LoadBalancer. This must be in the range [`8`-`29`].
        :param pulumi.Input[str] switch_id: The id of the switch to which the LoadBalancer connects.
        :param pulumi.Input[int] vrid: The Virtual Router Identifier.
        :param pulumi.Input[str] gateway: The IP address of the gateway used by LoadBalancer.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        pulumi.set(__self__, "vrid", vrid)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of IP address to assign to the LoadBalancer. .
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet assigned to the LoadBalancer. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Input[str]:
        """
        The id of the switch to which the LoadBalancer connects.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "switch_id", value)

    @property
    @pulumi.getter
    def vrid(self) -> pulumi.Input[int]:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")

    @vrid.setter
    def vrid(self, value: pulumi.Input[int]):
        pulumi.set(self, "vrid", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the gateway used by LoadBalancer.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)


@pulumi.input_type
class LoadBalancerVipArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 vip: pulumi.Input[str],
                 delay_loop: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerVipServerArgs']]]] = None,
                 sorry_server: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: The target port number for load-balancing. This must be in the range [`1`-`65535`].
        :param pulumi.Input[str] vip: The virtual IP address.
        :param pulumi.Input[int] delay_loop: The interval in seconds between checks. This must be in the range [`10`-`2147483647`].
        :param pulumi.Input[str] description: The description of the VIP. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerVipServerArgs']]] servers: One or more `server` blocks as defined below.
        :param pulumi.Input[str] sorry_server: The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vip", vip)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if sorry_server is not None:
            pulumi.set(__self__, "sorry_server", sorry_server)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The target port number for load-balancing. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def vip(self) -> pulumi.Input[str]:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")

    @vip.setter
    def vip(self, value: pulumi.Input[str]):
        pulumi.set(self, "vip", value)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`2147483647`].
        """
        return pulumi.get(self, "delay_loop")

    @delay_loop.setter
    def delay_loop(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_loop", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the VIP. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerVipServerArgs']]]]:
        """
        One or more `server` blocks as defined below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerVipServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="sorryServer")
    def sorry_server(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the SorryServer. This will be used when all servers under this VIP are down.
        """
        return pulumi.get(self, "sorry_server")

    @sorry_server.setter
    def sorry_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sorry_server", value)


@pulumi.input_type
class LoadBalancerVipServerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address of the destination server.
        :param pulumi.Input[str] protocol: The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        :param pulumi.Input[bool] enabled: The flag to enable as destination of load balancing.
        :param pulumi.Input[str] path: The path used when checking by HTTP/HTTPS.
        :param pulumi.Input[str] status: The response code to expect when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "protocol", protocol)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the destination server.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`tcp`/`ping`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The response code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class LocalRouterNetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 netmask: pulumi.Input[int],
                 vip: pulumi.Input[str],
                 vrid: pulumi.Input[int]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: A list of IP address to assign to the LocalRouter.
        :param pulumi.Input[int] netmask: The bit length of the subnet assigned to the LocalRouter. This must be in the range [`8`-`29`].
        :param pulumi.Input[str] vip: The virtual IP address.
        :param pulumi.Input[int] vrid: The Virtual Router Identifier.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "vip", vip)
        pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of IP address to assign to the LocalRouter.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet assigned to the LocalRouter. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter
    def vip(self) -> pulumi.Input[str]:
        """
        The virtual IP address.
        """
        return pulumi.get(self, "vip")

    @vip.setter
    def vip(self, value: pulumi.Input[str]):
        pulumi.set(self, "vip", value)

    @property
    @pulumi.getter
    def vrid(self) -> pulumi.Input[int]:
        """
        The Virtual Router Identifier.
        """
        return pulumi.get(self, "vrid")

    @vrid.setter
    def vrid(self, value: pulumi.Input[int]):
        pulumi.set(self, "vrid", value)


@pulumi.input_type
class LocalRouterPeerArgs:
    def __init__(__self__, *,
                 peer_id: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] peer_id: The ID of the peer LocalRouter.
        :param pulumi.Input[str] secret_key: The secret key of the peer LocalRouter.
        :param pulumi.Input[str] description: The description of the LocalRouter. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[bool] enabled: The flag to enable the LocalRouter.
        """
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "secret_key", secret_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> pulumi.Input[str]:
        """
        The ID of the peer LocalRouter.
        """
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_id", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        The secret key of the peer LocalRouter.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the LocalRouter. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable the LocalRouter.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class LocalRouterStaticRouteArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[str],
                 prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] next_hop: The IP address of the next hop.
        :param pulumi.Input[str] prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[str]:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class LocalRouterSwitchArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 category: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] code: The resource ID of the Switch.
        :param pulumi.Input[str] zone_id: The id of the Zone.
        :param pulumi.Input[str] category: The category name of connected services (e.g. `cloud`, `vps`).
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "zone_id", zone_id)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[str]:
        """
        The resource ID of the Switch.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[str]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The category name of connected services (e.g. `cloud`, `vps`).
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)


@pulumi.input_type
class MobileGatewayPrivateNetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 netmask: pulumi.Input[int],
                 switch_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] ip_address: The IP address to assign to the MobileGateway.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the MobileGateway. This must be in the range [`8`-`29`].
        :param pulumi.Input[str] switch_id: The id of the switch to which the MobileGateway connects.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to assign to the MobileGateway.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet to assign to the MobileGateway. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Input[str]:
        """
        The id of the switch to which the MobileGateway connects.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "switch_id", value)


@pulumi.input_type
class MobileGatewaySimArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 sim_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] ip_address: The IP address to assign to the SIM.
        :param pulumi.Input[str] sim_id: The id of the Switch connected to the MobileGateway.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "sim_id", sim_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to assign to the SIM.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="simId")
    def sim_id(self) -> pulumi.Input[str]:
        """
        The id of the Switch connected to the MobileGateway.
        """
        return pulumi.get(self, "sim_id")

    @sim_id.setter
    def sim_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sim_id", value)


@pulumi.input_type
class MobileGatewaySimRouteArgs:
    def __init__(__self__, *,
                 prefix: pulumi.Input[str],
                 sim_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] prefix: The destination network prefix used by the sim routing. This must be specified by CIDR block formatted string.
        :param pulumi.Input[str] sim_id: The id of the routing destination SIM.
        """
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "sim_id", sim_id)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        The destination network prefix used by the sim routing. This must be specified by CIDR block formatted string.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="simId")
    def sim_id(self) -> pulumi.Input[str]:
        """
        The id of the routing destination SIM.
        """
        return pulumi.get(self, "sim_id")

    @sim_id.setter
    def sim_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sim_id", value)


@pulumi.input_type
class MobileGatewayStaticRouteArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[str],
                 prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] next_hop: The IP address of next hop.
        :param pulumi.Input[str] prefix: The destination network prefix used by static routing. This must be specified by CIDR block formatted string.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[str]:
        """
        The IP address of next hop.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        The destination network prefix used by static routing. This must be specified by CIDR block formatted string.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class MobileGatewayTrafficControlArgs:
    def __init__(__self__, *,
                 quota: pulumi.Input[int],
                 auto_traffic_shaping: Optional[pulumi.Input[bool]] = None,
                 band_width_limit: Optional[pulumi.Input[int]] = None,
                 enable_email: Optional[pulumi.Input[bool]] = None,
                 enable_slack: Optional[pulumi.Input[bool]] = None,
                 slack_webhook: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] quota: The threshold of monthly traffic usage to enable to the traffic shaping.
        :param pulumi.Input[bool] auto_traffic_shaping: The flag to enable the traffic shaping.
        :param pulumi.Input[int] band_width_limit: The bandwidth allowed when the traffic shaping is enabled.
        :param pulumi.Input[bool] enable_email: The flag to enable email notification when the traffic shaping is enabled.
        :param pulumi.Input[bool] enable_slack: The flag to enable slack notification when the traffic shaping is enabled.
        :param pulumi.Input[str] slack_webhook: The webhook URL used when sends notification. It will only used when `enable_slack` is set `true`.
        """
        pulumi.set(__self__, "quota", quota)
        if auto_traffic_shaping is not None:
            pulumi.set(__self__, "auto_traffic_shaping", auto_traffic_shaping)
        if band_width_limit is not None:
            pulumi.set(__self__, "band_width_limit", band_width_limit)
        if enable_email is not None:
            pulumi.set(__self__, "enable_email", enable_email)
        if enable_slack is not None:
            pulumi.set(__self__, "enable_slack", enable_slack)
        if slack_webhook is not None:
            pulumi.set(__self__, "slack_webhook", slack_webhook)

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Input[int]:
        """
        The threshold of monthly traffic usage to enable to the traffic shaping.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: pulumi.Input[int]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="autoTrafficShaping")
    def auto_traffic_shaping(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable the traffic shaping.
        """
        return pulumi.get(self, "auto_traffic_shaping")

    @auto_traffic_shaping.setter
    def auto_traffic_shaping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_traffic_shaping", value)

    @property
    @pulumi.getter(name="bandWidthLimit")
    def band_width_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth allowed when the traffic shaping is enabled.
        """
        return pulumi.get(self, "band_width_limit")

    @band_width_limit.setter
    def band_width_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "band_width_limit", value)

    @property
    @pulumi.getter(name="enableEmail")
    def enable_email(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable email notification when the traffic shaping is enabled.
        """
        return pulumi.get(self, "enable_email")

    @enable_email.setter
    def enable_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_email", value)

    @property
    @pulumi.getter(name="enableSlack")
    def enable_slack(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable slack notification when the traffic shaping is enabled.
        """
        return pulumi.get(self, "enable_slack")

    @enable_slack.setter
    def enable_slack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_slack", value)

    @property
    @pulumi.getter(name="slackWebhook")
    def slack_webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The webhook URL used when sends notification. It will only used when `enable_slack` is set `true`.
        """
        return pulumi.get(self, "slack_webhook")

    @slack_webhook.setter
    def slack_webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slack_webhook", value)


@pulumi.input_type
class NFSNetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 netmask: pulumi.Input[int],
                 switch_id: pulumi.Input[str],
                 gateway: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address to assign to the NFS.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the NFS. This must be in the range [`8`-`29`].
        :param pulumi.Input[str] switch_id: The id of the switch to which the NFS connects.
        :param pulumi.Input[str] gateway: The IP address of the gateway used by NFS.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address to assign to the NFS.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet to assign to the NFS. This must be in the range [`8`-`29`].
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Input[str]:
        """
        The id of the switch to which the NFS connects.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "switch_id", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the gateway used by NFS.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)


@pulumi.input_type
class PacketFilterExpressionArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 allow: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 source_network: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] protocol: The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        :param pulumi.Input[bool] allow: The flag to allow the packet through the filter.
        :param pulumi.Input[str] description: The description of the packetFilter. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        :param pulumi.Input[str] source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param pulumi.Input[str] source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        pulumi.set(__self__, "protocol", protocol)
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the packetFilter. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[str]]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[pulumi.Input[str]]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @source_network.setter
    def source_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_network", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[str]]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class PacketFilterRuleExpressionArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 allow: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 source_network: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] protocol: The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        :param pulumi.Input[bool] allow: The flag to allow the packet through the filter.
        :param pulumi.Input[str] description: The description of the expression.
        :param pulumi.Input[str] destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        :param pulumi.Input[str] source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param pulumi.Input[str] source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        pulumi.set(__self__, "protocol", protocol)
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for filtering. This must be one of [`http`/`https`/`tcp`/`udp`/`icmp`/`fragment`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the expression.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[str]]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[pulumi.Input[str]]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @source_network.setter
    def source_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_network", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[str]]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`).
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class ProxyLBACMECertificateArgs:
    def __init__(__self__, *,
                 additional_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateAdditionalCertificateArgs']]]] = None,
                 intermediate_cert: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateAdditionalCertificateArgs']]] additional_certificates: A list of `additional_certificate` blocks as defined below.
        :param pulumi.Input[str] intermediate_cert: The intermediate certificate for a server.
        :param pulumi.Input[str] private_key: The private key for a server.
        :param pulumi.Input[str] server_cert: The certificate for a server.
        """
        if additional_certificates is not None:
            pulumi.set(__self__, "additional_certificates", additional_certificates)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="additionalCertificates")
    def additional_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateAdditionalCertificateArgs']]]]:
        """
        A list of `additional_certificate` blocks as defined below.
        """
        return pulumi.get(self, "additional_certificates")

    @additional_certificates.setter
    def additional_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBACMECertificateAdditionalCertificateArgs']]]]):
        pulumi.set(self, "additional_certificates", value)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @intermediate_cert.setter
    def intermediate_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intermediate_cert", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)


@pulumi.input_type
class ProxyLBACMECertificateAdditionalCertificateArgs:
    def __init__(__self__, *,
                 intermediate_cert: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] intermediate_cert: The intermediate certificate for a server.
        :param pulumi.Input[str] private_key: The private key for a server.
        :param pulumi.Input[str] server_cert: The certificate for a server.
        """
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @intermediate_cert.setter
    def intermediate_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intermediate_cert", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)


@pulumi.input_type
class ProxyLBBindPortArgs:
    def __init__(__self__, *,
                 proxy_mode: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 redirect_to_https: Optional[pulumi.Input[bool]] = None,
                 response_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBBindPortResponseHeaderArgs']]]] = None,
                 support_http2: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] proxy_mode: The proxy mode. This must be one of [`http`/`https`/`tcp`].
        :param pulumi.Input[int] port: The number of listening port.
        :param pulumi.Input[bool] redirect_to_https: The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        :param pulumi.Input[Sequence[pulumi.Input['ProxyLBBindPortResponseHeaderArgs']]] response_headers: One or more `response_header` blocks as defined below.
        :param pulumi.Input[bool] support_http2: The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        pulumi.set(__self__, "proxy_mode", proxy_mode)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if redirect_to_https is not None:
            pulumi.set(__self__, "redirect_to_https", redirect_to_https)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)
        if support_http2 is not None:
            pulumi.set(__self__, "support_http2", support_http2)

    @property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Input[str]:
        """
        The proxy mode. This must be one of [`http`/`https`/`tcp`].
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxy_mode", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The number of listening port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="redirectToHttps")
    def redirect_to_https(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable redirection from http to https. This flag is used only when `proxy_mode` is `http`.
        """
        return pulumi.get(self, "redirect_to_https")

    @redirect_to_https.setter
    def redirect_to_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redirect_to_https", value)

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBBindPortResponseHeaderArgs']]]]:
        """
        One or more `response_header` blocks as defined below.
        """
        return pulumi.get(self, "response_headers")

    @response_headers.setter
    def response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBBindPortResponseHeaderArgs']]]]):
        pulumi.set(self, "response_headers", value)

    @property
    @pulumi.getter(name="supportHttp2")
    def support_http2(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable HTTP/2. This flag is used only when `proxy_mode` is `https`.
        """
        return pulumi.get(self, "support_http2")

    @support_http2.setter
    def support_http2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "support_http2", value)


@pulumi.input_type
class ProxyLBBindPortResponseHeaderArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] header: The field name of HTTP header added to response by the ProxyLB.
        :param pulumi.Input[str] value: The field value of HTTP header added to response by the ProxyLB.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> pulumi.Input[str]:
        """
        The field name of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[str]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The field value of HTTP header added to response by the ProxyLB.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ProxyLBCertificateArgs:
    def __init__(__self__, *,
                 additional_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBCertificateAdditionalCertificateArgs']]]] = None,
                 intermediate_cert: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProxyLBCertificateAdditionalCertificateArgs']]] additional_certificates: One or more `additional_certificate` blocks as defined below.
        :param pulumi.Input[str] intermediate_cert: The intermediate certificate for a server.
        :param pulumi.Input[str] private_key: The private key for a server.
        :param pulumi.Input[str] server_cert: The certificate for a server.
        """
        if additional_certificates is not None:
            pulumi.set(__self__, "additional_certificates", additional_certificates)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)

    @property
    @pulumi.getter(name="additionalCertificates")
    def additional_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBCertificateAdditionalCertificateArgs']]]]:
        """
        One or more `additional_certificate` blocks as defined below.
        """
        return pulumi.get(self, "additional_certificates")

    @additional_certificates.setter
    def additional_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProxyLBCertificateAdditionalCertificateArgs']]]]):
        pulumi.set(self, "additional_certificates", value)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @intermediate_cert.setter
    def intermediate_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intermediate_cert", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)


@pulumi.input_type
class ProxyLBCertificateAdditionalCertificateArgs:
    def __init__(__self__, *,
                 private_key: pulumi.Input[str],
                 server_cert: pulumi.Input[str],
                 intermediate_cert: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_key: The private key for a server.
        :param pulumi.Input[str] server_cert: The certificate for a server.
        :param pulumi.Input[str] intermediate_cert: The intermediate certificate for a server.
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "server_cert", server_cert)
        if intermediate_cert is not None:
            pulumi.set(__self__, "intermediate_cert", intermediate_cert)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        The private key for a server.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Input[str]:
        """
        The certificate for a server.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_cert", value)

    @property
    @pulumi.getter(name="intermediateCert")
    def intermediate_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate certificate for a server.
        """
        return pulumi.get(self, "intermediate_cert")

    @intermediate_cert.setter
    def intermediate_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intermediate_cert", value)


@pulumi.input_type
class ProxyLBHealthCheckArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 delay_loop: Optional[pulumi.Input[int]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] protocol: The protocol used for health checks. This must be one of [`http`/`tcp`].
        :param pulumi.Input[int] delay_loop: The interval in seconds between checks. This must be in the range [`10`-`60`].
        :param pulumi.Input[str] host_header: The value of host header send when checking by HTTP.
        :param pulumi.Input[str] path: The path used when checking by HTTP.
        :param pulumi.Input[int] port: The port number used when checking by TCP.
        """
        pulumi.set(__self__, "protocol", protocol)
        if delay_loop is not None:
            pulumi.set(__self__, "delay_loop", delay_loop)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for health checks. This must be one of [`http`/`tcp`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="delayLoop")
    def delay_loop(self) -> Optional[pulumi.Input[int]]:
        """
        The interval in seconds between checks. This must be in the range [`10`-`60`].
        """
        return pulumi.get(self, "delay_loop")

    @delay_loop.setter
    def delay_loop(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_loop", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value of host header send when checking by HTTP.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path used when checking by HTTP.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number used when checking by TCP.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ProxyLBRuleArgs:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] group: The name of load balancing group. When proxyLB received request which matched to `host` and `path`, proxyLB forwards the request to servers that having same group name. The length of this value must be in the range [`1`-`10`].
        :param pulumi.Input[str] host: The value of HTTP host header that is used as condition of rule-based balancing.
        :param pulumi.Input[str] path: The request path that is used as condition of rule-based balancing.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of load balancing group. When proxyLB received request which matched to `host` and `path`, proxyLB forwards the request to servers that having same group name. The length of this value must be in the range [`1`-`10`].
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The value of HTTP host header that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path that is used as condition of rule-based balancing.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ProxyLBServerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 port: pulumi.Input[int],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address of the destination server.
        :param pulumi.Input[int] port: The port number of the destination server. This must be in the range [`1`-`65535`].
        :param pulumi.Input[bool] enabled: The flag to enable as destination of load balancing.
        :param pulumi.Input[str] group: The name of load balancing group. This is used when using rule-based load balancing. The length of this value must be in the range [`1`-`10`].
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group is not None:
            pulumi.set(__self__, "group", group)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the destination server.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port number of the destination server. This must be in the range [`1`-`65535`].
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable as destination of load balancing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of load balancing group. This is used when using rule-based load balancing. The length of this value must be in the range [`1`-`10`].
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)


@pulumi.input_type
class ProxyLBSorryServerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] ip_address: The IP address of the SorryServer. This will be used when all servers are down.
        :param pulumi.Input[int] port: The port number of the SorryServer. This will be used when all servers are down.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number of the SorryServer. This will be used when all servers are down.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ServerDiskEditParameterArgs:
    def __init__(__self__, *,
                 change_partition_uuid: Optional[pulumi.Input[bool]] = None,
                 disable_pw_auth: Optional[pulumi.Input[bool]] = None,
                 enable_dhcp: Optional[pulumi.Input[bool]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[int]] = None,
                 note_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 notes: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDiskEditParameterNoteArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] change_partition_uuid: The flag to change partition uuid.
        :param pulumi.Input[bool] disable_pw_auth: The flag to disable password authentication.
        :param pulumi.Input[bool] enable_dhcp: The flag to enable DHCP client.
        :param pulumi.Input[str] gateway: The gateway address used by the Server.
        :param pulumi.Input[str] hostname: The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] ip_address: The IP address to assign to the Server.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the Server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] note_ids: A list of the Note id.  
               Note: **The `note_ids` will be removed in a future version. Please use the `note` instead**
        :param pulumi.Input[Sequence[pulumi.Input['ServerDiskEditParameterNoteArgs']]] notes: A list of the `note` block as defined below.
        :param pulumi.Input[str] password: The password of default user. The length of this value must be in the range [`8`-`64`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: A list of the SSHKey id.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: A list of the SSHKey text.
        """
        if change_partition_uuid is not None:
            pulumi.set(__self__, "change_partition_uuid", change_partition_uuid)
        if disable_pw_auth is not None:
            pulumi.set(__self__, "disable_pw_auth", disable_pw_auth)
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if note_ids is not None:
            warnings.warn("""The note_ids field will be removed in a future version. Please use the note field instead""", DeprecationWarning)
            pulumi.log.warn("""note_ids is deprecated: The note_ids field will be removed in a future version. Please use the note field instead""")
        if note_ids is not None:
            pulumi.set(__self__, "note_ids", note_ids)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)

    @property
    @pulumi.getter(name="changePartitionUuid")
    def change_partition_uuid(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to change partition uuid.
        """
        return pulumi.get(self, "change_partition_uuid")

    @change_partition_uuid.setter
    def change_partition_uuid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "change_partition_uuid", value)

    @property
    @pulumi.getter(name="disablePwAuth")
    def disable_pw_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to disable password authentication.
        """
        return pulumi.get(self, "disable_pw_auth")

    @disable_pw_auth.setter
    def disable_pw_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_pw_auth", value)

    @property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable DHCP client.
        """
        return pulumi.get(self, "enable_dhcp")

    @enable_dhcp.setter
    def enable_dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dhcp", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway address used by the Server.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the Server. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address to assign to the Server.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[int]]:
        """
        The bit length of the subnet to assign to the Server.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="noteIds")
    def note_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the Note id.  
        Note: **The `note_ids` will be removed in a future version. Please use the `note` instead**
        """
        return pulumi.get(self, "note_ids")

    @note_ids.setter
    def note_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "note_ids", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerDiskEditParameterNoteArgs']]]]:
        """
        A list of the `note` block as defined below.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerDiskEditParameterNoteArgs']]]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of default user. The length of this value must be in the range [`8`-`64`].
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the SSHKey id.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the SSHKey text.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_keys", value)


@pulumi.input_type
class ServerDiskEditParameterNoteArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 api_key_id: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] id: The id of the Note/StartupScript.
        :param pulumi.Input[str] api_key_id: The id of the API key to be injected into the Note/StartupScript when editing the disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: The value of the variable that be injected into the Note/StartupScript when editing the disk.
        """
        pulumi.set(__self__, "id", id)
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The id of the Note/StartupScript.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the API key to be injected into the Note/StartupScript when editing the disk.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key_id", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The value of the variable that be injected into the Note/StartupScript when editing the disk.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class ServerNetworkInterfaceArgs:
    def __init__(__self__, *,
                 upstream: pulumi.Input[str],
                 mac_address: Optional[pulumi.Input[str]] = None,
                 packet_filter_id: Optional[pulumi.Input[str]] = None,
                 user_ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] upstream: The upstream type or upstream switch id. This must be one of [`shared`/`disconnect`/`<switch id>`].
        :param pulumi.Input[str] mac_address: The MAC address.
        :param pulumi.Input[str] packet_filter_id: The id of the packet filter to attach to the network interface.
        :param pulumi.Input[str] user_ip_address: The IP address for only display. This value doesn't affect actual NIC settings.
        """
        pulumi.set(__self__, "upstream", upstream)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if packet_filter_id is not None:
            pulumi.set(__self__, "packet_filter_id", packet_filter_id)
        if user_ip_address is not None:
            pulumi.set(__self__, "user_ip_address", user_ip_address)

    @property
    @pulumi.getter
    def upstream(self) -> pulumi.Input[str]:
        """
        The upstream type or upstream switch id. This must be one of [`shared`/`disconnect`/`<switch id>`].
        """
        return pulumi.get(self, "upstream")

    @upstream.setter
    def upstream(self, value: pulumi.Input[str]):
        pulumi.set(self, "upstream", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="packetFilterId")
    def packet_filter_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the packet filter to attach to the network interface.
        """
        return pulumi.get(self, "packet_filter_id")

    @packet_filter_id.setter
    def packet_filter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packet_filter_id", value)

    @property
    @pulumi.getter(name="userIpAddress")
    def user_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for only display. This value doesn't affect actual NIC settings.
        """
        return pulumi.get(self, "user_ip_address")

    @user_ip_address.setter
    def user_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_ip_address", value)


@pulumi.input_type
class SimpleMonitorHealthCheckArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 community: Optional[pulumi.Input[str]] = None,
                 contains_string: Optional[pulumi.Input[str]] = None,
                 excepcted_data: Optional[pulumi.Input[str]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 http2: Optional[pulumi.Input[bool]] = None,
                 oid: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 qname: Optional[pulumi.Input[str]] = None,
                 remaining_days: Optional[pulumi.Input[int]] = None,
                 sni: Optional[pulumi.Input[bool]] = None,
                 snmp_version: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] protocol: The protocol used for health checks. This must be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        :param pulumi.Input[str] community: The SNMP community string used when checking by SNMP.
        :param pulumi.Input[str] contains_string: The string that should be included in the response body when checking for HTTP/HTTPS.
        :param pulumi.Input[str] excepcted_data: The expected value used when checking by DNS.
        :param pulumi.Input[str] host_header: The value of host header send when checking by HTTP/HTTPS.
        :param pulumi.Input[bool] http2: The flag to enable HTTP/2 when checking by HTTPS.
        :param pulumi.Input[str] oid: The SNMP OID used when checking by SNMP.
        :param pulumi.Input[str] password: The password for basic auth used when checking by HTTP/HTTPS.
        :param pulumi.Input[str] path: The path used when checking by HTTP/HTTPS.
        :param pulumi.Input[int] port: The target port number.
        :param pulumi.Input[str] qname: The FQDN used when checking by DNS.
        :param pulumi.Input[int] remaining_days: The number of remaining days until certificate expiration used when checking SSL certificates. This must be in the range [`1`-`9999`].
        :param pulumi.Input[bool] sni: The flag to enable SNI when checking by HTTP/HTTPS.
        :param pulumi.Input[str] snmp_version: The SNMP version used when checking by SNMP. This must be one of `1`/`2c`.
        :param pulumi.Input[int] status: The response-code to expect when checking by HTTP/HTTPS.
        :param pulumi.Input[str] username: The user name for basic auth used when checking by HTTP/HTTPS.
        """
        pulumi.set(__self__, "protocol", protocol)
        if community is not None:
            pulumi.set(__self__, "community", community)
        if contains_string is not None:
            pulumi.set(__self__, "contains_string", contains_string)
        if excepcted_data is not None:
            pulumi.set(__self__, "excepcted_data", excepcted_data)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http2 is not None:
            pulumi.set(__self__, "http2", http2)
        if oid is not None:
            pulumi.set(__self__, "oid", oid)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if qname is not None:
            pulumi.set(__self__, "qname", qname)
        if remaining_days is not None:
            pulumi.set(__self__, "remaining_days", remaining_days)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)
        if snmp_version is not None:
            pulumi.set(__self__, "snmp_version", snmp_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for health checks. This must be one of [`http`/`https`/`ping`/`tcp`/`dns`/`ssh`/`smtp`/`pop3`/`snmp`/`sslcertificate`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def community(self) -> Optional[pulumi.Input[str]]:
        """
        The SNMP community string used when checking by SNMP.
        """
        return pulumi.get(self, "community")

    @community.setter
    def community(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "community", value)

    @property
    @pulumi.getter(name="containsString")
    def contains_string(self) -> Optional[pulumi.Input[str]]:
        """
        The string that should be included in the response body when checking for HTTP/HTTPS.
        """
        return pulumi.get(self, "contains_string")

    @contains_string.setter
    def contains_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contains_string", value)

    @property
    @pulumi.getter(name="excepctedData")
    def excepcted_data(self) -> Optional[pulumi.Input[str]]:
        """
        The expected value used when checking by DNS.
        """
        return pulumi.get(self, "excepcted_data")

    @excepcted_data.setter
    def excepcted_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "excepcted_data", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value of host header send when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter
    def http2(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable HTTP/2 when checking by HTTPS.
        """
        return pulumi.get(self, "http2")

    @http2.setter
    def http2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2", value)

    @property
    @pulumi.getter
    def oid(self) -> Optional[pulumi.Input[str]]:
        """
        The SNMP OID used when checking by SNMP.
        """
        return pulumi.get(self, "oid")

    @oid.setter
    def oid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oid", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The target port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def qname(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN used when checking by DNS.
        """
        return pulumi.get(self, "qname")

    @qname.setter
    def qname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qname", value)

    @property
    @pulumi.getter(name="remainingDays")
    def remaining_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of remaining days until certificate expiration used when checking SSL certificates. This must be in the range [`1`-`9999`].
        """
        return pulumi.get(self, "remaining_days")

    @remaining_days.setter
    def remaining_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remaining_days", value)

    @property
    @pulumi.getter
    def sni(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable SNI when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "sni")

    @sni.setter
    def sni(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sni", value)

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> Optional[pulumi.Input[str]]:
        """
        The SNMP version used when checking by SNMP. This must be one of `1`/`2c`.
        """
        return pulumi.get(self, "snmp_version")

    @snmp_version.setter
    def snmp_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snmp_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The response-code to expect when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for basic auth used when checking by HTTP/HTTPS.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VPCRouterDhcpServerArgs:
    def __init__(__self__, *,
                 interface_index: pulumi.Input[int],
                 range_start: pulumi.Input[str],
                 range_stop: pulumi.Input[str],
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] interface_index: The index of the network interface on which to enable the DHCP service. This must be in the range [`1`-`7`].
        :param pulumi.Input[str] range_start: The start value of IP address range to assign to DHCP client.
        :param pulumi.Input[str] range_stop: The end value of IP address range to assign to DHCP client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: A list of IP address of DNS server to assign to DHCP client.
        """
        pulumi.set(__self__, "interface_index", interface_index)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> pulumi.Input[int]:
        """
        The index of the network interface on which to enable the DHCP service. This must be in the range [`1`-`7`].
        """
        return pulumi.get(self, "interface_index")

    @interface_index.setter
    def interface_index(self, value: pulumi.Input[int]):
        pulumi.set(self, "interface_index", value)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> pulumi.Input[str]:
        """
        The start value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_start")

    @range_start.setter
    def range_start(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_start", value)

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> pulumi.Input[str]:
        """
        The end value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_stop")

    @range_stop.setter
    def range_stop(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_stop", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IP address of DNS server to assign to DHCP client.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)


@pulumi.input_type
class VPCRouterDhcpStaticMappingArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 mac_address: pulumi.Input[str]):
        """
        :param pulumi.Input[str] ip_address: The static IP address to assign to DHCP client.
        :param pulumi.Input[str] mac_address: The source MAC address of static mapping.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The static IP address to assign to DHCP client.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Input[str]:
        """
        The source MAC address of static mapping.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "mac_address", value)


@pulumi.input_type
class VPCRouterFirewallArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[str],
                 expressions: pulumi.Input[Sequence[pulumi.Input['VPCRouterFirewallExpressionArgs']]],
                 interface_index: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] direction: The direction to apply the firewall. This must be one of [`send`/`receive`].
        :param pulumi.Input[Sequence[pulumi.Input['VPCRouterFirewallExpressionArgs']]] expressions: One or more `expression` blocks as defined below.
        :param pulumi.Input[int] interface_index: The index of the network interface on which to enable filtering. This must be in the range [`0`-`7`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "expressions", expressions)
        if interface_index is not None:
            pulumi.set(__self__, "interface_index", interface_index)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        The direction to apply the firewall. This must be one of [`send`/`receive`].
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def expressions(self) -> pulumi.Input[Sequence[pulumi.Input['VPCRouterFirewallExpressionArgs']]]:
        """
        One or more `expression` blocks as defined below.
        """
        return pulumi.get(self, "expressions")

    @expressions.setter
    def expressions(self, value: pulumi.Input[Sequence[pulumi.Input['VPCRouterFirewallExpressionArgs']]]):
        pulumi.set(self, "expressions", value)

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the network interface on which to enable filtering. This must be in the range [`0`-`7`].
        """
        return pulumi.get(self, "interface_index")

    @interface_index.setter
    def interface_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interface_index", value)


@pulumi.input_type
class VPCRouterFirewallExpressionArgs:
    def __init__(__self__, *,
                 allow: pulumi.Input[bool],
                 protocol: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 destination_network: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[bool]] = None,
                 source_network: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow: The flag to allow the packet through the filter.
        :param pulumi.Input[str] protocol: The protocol used for filtering. This must be one of [`tcp`/`udp`/`icmp`/`ip`].
        :param pulumi.Input[str] description: The description of the expression. The length of this value must be in the range [`0`-`512`].
        :param pulumi.Input[str] destination_network: A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param pulumi.Input[str] destination_port: A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        :param pulumi.Input[bool] logging: The flag to enable packet logging when matching the expression.
        :param pulumi.Input[str] source_network: A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        :param pulumi.Input[str] source_port: A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        pulumi.set(__self__, "allow", allow)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_network is not None:
            pulumi.set(__self__, "destination_network", destination_network)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if source_network is not None:
            pulumi.set(__self__, "source_network", source_network)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def allow(self) -> pulumi.Input[bool]:
        """
        The flag to allow the packet through the filter.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for filtering. This must be one of [`tcp`/`udp`/`icmp`/`ip`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the expression. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationNetwork")
    def destination_network(self) -> Optional[pulumi.Input[str]]:
        """
        A destination IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "destination_network")

    @destination_network.setter
    def destination_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_network", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[str]]:
        """
        A destination port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to enable packet logging when matching the expression.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="sourceNetwork")
    def source_network(self) -> Optional[pulumi.Input[str]]:
        """
        A source IP address or CIDR block used for filtering (e.g. `192.0.2.1`, `192.0.2.0/24`).
        """
        return pulumi.get(self, "source_network")

    @source_network.setter
    def source_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_network", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[str]]:
        """
        A source port number or port range used for filtering (e.g. `1024`, `1024-2048`). This is only used when `protocol` is `tcp` or `udp`.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class VPCRouterL2tpArgs:
    def __init__(__self__, *,
                 pre_shared_secret: pulumi.Input[str],
                 range_start: pulumi.Input[str],
                 range_stop: pulumi.Input[str]):
        """
        :param pulumi.Input[str] pre_shared_secret: The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        :param pulumi.Input[str] range_start: The start value of IP address range to assign to DHCP client.
        :param pulumi.Input[str] range_stop: The end value of IP address range to assign to DHCP client.
        """
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> pulumi.Input[str]:
        """
        The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        """
        return pulumi.get(self, "pre_shared_secret")

    @pre_shared_secret.setter
    def pre_shared_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "pre_shared_secret", value)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> pulumi.Input[str]:
        """
        The start value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_start")

    @range_start.setter
    def range_start(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_start", value)

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> pulumi.Input[str]:
        """
        The end value of IP address range to assign to DHCP client.
        """
        return pulumi.get(self, "range_stop")

    @range_stop.setter
    def range_stop(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_stop", value)


@pulumi.input_type
class VPCRouterPortForwardingArgs:
    def __init__(__self__, *,
                 private_ip: pulumi.Input[str],
                 private_port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 public_port: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_ip: The destination ip address of the port forwarding.
        :param pulumi.Input[int] private_port: The destination port number of the port forwarding. This will be a port number on a private network.
        :param pulumi.Input[str] protocol: The protocol used for port forwarding. This must be one of [`tcp`/`udp`].
        :param pulumi.Input[int] public_port: The source port number of the port forwarding. This must be a port number on a public network.
        :param pulumi.Input[str] description: The description of the port forwarding. The length of this value must be in the range [`0`-`512`].
        """
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "private_port", private_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "public_port", public_port)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Input[str]:
        """
        The destination ip address of the port forwarding.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> pulumi.Input[int]:
        """
        The destination port number of the port forwarding. This will be a port number on a private network.
        """
        return pulumi.get(self, "private_port")

    @private_port.setter
    def private_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "private_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for port forwarding. This must be one of [`tcp`/`udp`].
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> pulumi.Input[int]:
        """
        The source port number of the port forwarding. This must be a port number on a public network.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "public_port", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the port forwarding. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class VPCRouterPptpArgs:
    def __init__(__self__, *,
                 range_start: pulumi.Input[str],
                 range_stop: pulumi.Input[str]):
        """
        :param pulumi.Input[str] range_start: The start value of IP address range to assign to PPTP client.
        :param pulumi.Input[str] range_stop: The end value of IP address range to assign to PPTP client.
        """
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "range_stop", range_stop)

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> pulumi.Input[str]:
        """
        The start value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_start")

    @range_start.setter
    def range_start(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_start", value)

    @property
    @pulumi.getter(name="rangeStop")
    def range_stop(self) -> pulumi.Input[str]:
        """
        The end value of IP address range to assign to PPTP client.
        """
        return pulumi.get(self, "range_stop")

    @range_stop.setter
    def range_stop(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_stop", value)


@pulumi.input_type
class VPCRouterPrivateNetworkInterfaceArgs:
    def __init__(__self__, *,
                 index: pulumi.Input[int],
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 netmask: pulumi.Input[int],
                 switch_id: pulumi.Input[str],
                 vip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] index: The index of the network interface. This must be in the range [`1`-`7`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: A list of ip address to assign to the network interface. This is required only one value when `plan` is `standard`, two values otherwise.
        :param pulumi.Input[int] netmask: The bit length of the subnet to assign to the network interface.
        :param pulumi.Input[str] switch_id: The id of the connected switch.
        :param pulumi.Input[str] vip: The virtual IP address to assign to the network interface. This is only required when `plan` is not `standard`.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "switch_id", switch_id)
        if vip is not None:
            pulumi.set(__self__, "vip", vip)

    @property
    @pulumi.getter
    def index(self) -> pulumi.Input[int]:
        """
        The index of the network interface. This must be in the range [`1`-`7`].
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[int]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of ip address to assign to the network interface. This is required only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[int]:
        """
        The bit length of the subnet to assign to the network interface.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[int]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> pulumi.Input[str]:
        """
        The id of the connected switch.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "switch_id", value)

    @property
    @pulumi.getter
    def vip(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual IP address to assign to the network interface. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")

    @vip.setter
    def vip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip", value)


@pulumi.input_type
class VPCRouterPublicNetworkInterfaceArgs:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_id: Optional[pulumi.Input[str]] = None,
                 vip: Optional[pulumi.Input[str]] = None,
                 vrid: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: A list of ip alias to assign to the VPC Router. This can only be specified if `plan` is not `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: The list of the IP address to assign to the VPC Router. This is required only one value when `plan` is `standard`, two values otherwise.
        :param pulumi.Input[str] switch_id: The id of the switch to connect. This is only required when when `plan` is not `standard`.
        :param pulumi.Input[str] vip: The virtual IP address of the VPC Router. This is only required when `plan` is not `standard`.
        :param pulumi.Input[int] vrid: The Virtual Router Identifier. This is only required when `plan` is not `standard`.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if switch_id is not None:
            pulumi.set(__self__, "switch_id", switch_id)
        if vip is not None:
            pulumi.set(__self__, "vip", vip)
        if vrid is not None:
            pulumi.set(__self__, "vrid", vrid)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ip alias to assign to the VPC Router. This can only be specified if `plan` is not `standard`.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the IP address to assign to the VPC Router. This is required only one value when `plan` is `standard`, two values otherwise.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the switch to connect. This is only required when when `plan` is not `standard`.
        """
        return pulumi.get(self, "switch_id")

    @switch_id.setter
    def switch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_id", value)

    @property
    @pulumi.getter
    def vip(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual IP address of the VPC Router. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vip")

    @vip.setter
    def vip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip", value)

    @property
    @pulumi.getter
    def vrid(self) -> Optional[pulumi.Input[int]]:
        """
        The Virtual Router Identifier. This is only required when `plan` is not `standard`.
        """
        return pulumi.get(self, "vrid")

    @vrid.setter
    def vrid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vrid", value)


@pulumi.input_type
class VPCRouterSiteToSiteVpnArgs:
    def __init__(__self__, *,
                 local_prefixes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 peer: pulumi.Input[str],
                 pre_shared_secret: pulumi.Input[str],
                 remote_id: pulumi.Input[str],
                 routes: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_prefixes: A list of CIDR block of the network under the VPC Router.
        :param pulumi.Input[str] peer: The IP address of the opposing appliance connected to the VPC Router.
        :param pulumi.Input[str] pre_shared_secret: The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        :param pulumi.Input[str] remote_id: The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] routes: A list of CIDR block of VPN connected networks.
        """
        pulumi.set(__self__, "local_prefixes", local_prefixes)
        pulumi.set(__self__, "peer", peer)
        pulumi.set(__self__, "pre_shared_secret", pre_shared_secret)
        pulumi.set(__self__, "remote_id", remote_id)
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="localPrefixes")
    def local_prefixes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of CIDR block of the network under the VPC Router.
        """
        return pulumi.get(self, "local_prefixes")

    @local_prefixes.setter
    def local_prefixes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "local_prefixes", value)

    @property
    @pulumi.getter
    def peer(self) -> pulumi.Input[str]:
        """
        The IP address of the opposing appliance connected to the VPC Router.
        """
        return pulumi.get(self, "peer")

    @peer.setter
    def peer(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer", value)

    @property
    @pulumi.getter(name="preSharedSecret")
    def pre_shared_secret(self) -> pulumi.Input[str]:
        """
        The pre shared secret for the VPN. The length of this value must be in the range [`0`-`40`].
        """
        return pulumi.get(self, "pre_shared_secret")

    @pre_shared_secret.setter
    def pre_shared_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "pre_shared_secret", value)

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> pulumi.Input[str]:
        """
        The id of the opposing appliance connected to the VPC Router. This is typically set same as value of `peer`.
        """
        return pulumi.get(self, "remote_id")

    @remote_id.setter
    def remote_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_id", value)

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of CIDR block of VPN connected networks.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class VPCRouterStaticNatArgs:
    def __init__(__self__, *,
                 private_ip: pulumi.Input[str],
                 public_ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] private_ip: The private IP address used for the static NAT.
        :param pulumi.Input[str] public_ip: The public IP address used for the static NAT.
        :param pulumi.Input[str] description: The description of the static nat. The length of this value must be in the range [`0`-`512`].
        """
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Input[str]:
        """
        The private IP address used for the static NAT.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Input[str]:
        """
        The public IP address used for the static NAT.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the static nat. The length of this value must be in the range [`0`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class VPCRouterStaticRouteArgs:
    def __init__(__self__, *,
                 next_hop: pulumi.Input[str],
                 prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] next_hop: The IP address of the next hop.
        :param pulumi.Input[str] prefix: The CIDR block of destination.
        """
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[str]:
        """
        The IP address of the next hop.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_hop", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        The CIDR block of destination.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class VPCRouterUserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 password: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The user name used to authenticate remote access.
        :param pulumi.Input[str] password: The password used to authenticate remote access.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The user name used to authenticate remote access.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password used to authenticate remote access.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class GetArchiveFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetArchiveFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetArchiveFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetArchiveFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetArchiveFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetArchiveFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetBridgeFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetBridgeFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetBridgeFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetBridgeFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetBridgeFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class GetBridgeFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetCDROMFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetCDROMFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetCDROMFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetCDROMFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetCDROMFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetCDROMFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetContainerRegistryFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetContainerRegistryFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetContainerRegistryFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetContainerRegistryFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetContainerRegistryFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetContainerRegistryFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetDNSFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetDNSFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDNSFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetDNSFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetDNSFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetDNSFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetDatabaseFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetDatabaseFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDatabaseFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetDatabaseFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetDatabaseFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetDatabaseFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetDiskFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetDiskFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetDiskFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetDiskFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetDiskFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetDiskFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetESMEFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetESMEFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetESMEFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetESMEFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetESMEFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetESMEFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetGSLBFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetGSLBFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetGSLBFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetGSLBFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetGSLBFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetGSLBFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetIconFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetIconFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetIconFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetIconFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetIconFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetIconFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetInternetFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetInternetFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetInternetFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetInternetFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetInternetFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetInternetFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetLoadBalancerFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetLoadBalancerFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetLoadBalancerFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetLoadBalancerFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetLoadBalancerFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetLoadBalancerFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetLocalRouterFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetLocalRouterFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetLocalRouterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetLocalRouterFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetLocalRouterFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetLocalRouterFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetNFSFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetNFSFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetNFSFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetNFSFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetNFSFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetNFSFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetNoteFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetNoteFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetNoteFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetNoteFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetNoteFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetNoteFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetPacketFilterFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetPacketFilterFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetPacketFilterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetPacketFilterFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetPacketFilterFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class GetPacketFilterFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetPrivateHostFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetPrivateHostFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetPrivateHostFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetPrivateHostFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetPrivateHostFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetPrivateHostFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetProxyLBFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetProxyLBFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetProxyLBFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetProxyLBFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetProxyLBFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetProxyLBFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetSSHKeyFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetSSHKeyFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSSHKeyFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetSSHKeyFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetSSHKeyFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class GetSSHKeyFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetServerFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetServerFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetServerFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetServerFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetServerFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetServerFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetSimpleMonitorFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetSimpleMonitorFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSimpleMonitorFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetSimpleMonitorFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetSimpleMonitorFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetSimpleMonitorFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetSwitchFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetSwitchFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetSwitchFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetSwitchFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetSwitchFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetSwitchFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetVPCRouterFilterArgs:
    def __init__(__self__, *,
                 conditions: Optional[Sequence['GetVPCRouterFilterConditionArgs']] = None,
                 id: Optional[str] = None,
                 names: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param Sequence['GetVPCRouterFilterConditionArgs'] conditions: One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        :param str id: The resource id on SakuraCloud used for filtering.
        :param Sequence[str] names: The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        :param Sequence[str] tags: The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['GetVPCRouterFilterConditionArgs']]:
        """
        One or more name/values pairs used for filtering. There are several valid keys, for a full reference, check out finding section in the [SakuraCloud API reference](https://developer.sakura.ad.jp/cloud/api/1.1/).
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[Sequence['GetVPCRouterFilterConditionArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id on SakuraCloud used for filtering.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The resource names on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        The resource tags on SakuraCloud used for filtering. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class GetVPCRouterFilterConditionArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the target field. This value is case-sensitive.
        :param Sequence[str] values: The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the target field. This value is case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The values of the condition. If multiple values ​​are specified, they combined as AND condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


