# flake8: noqa
"""
Copyright (c) 2016, Maarten Everts
All rights reserved.

This source code has been ported from https://github.com/privacybydesign/gabi
The authors of this file are not -in any way- affiliated with the original authors or organizations.
"""

import time

import asynctest

from .....attestation.wallet.irmaexact.gabi.keys import CLSignature, PublicKey
from .....attestation.wallet.irmaexact.gabi.proofs import ProofD, ProofS, ProofU


class TestProofs(asynctest.TestCase):

    def setUp(self):
        n = 96063359353814070257464989369098573470645843347358957127875426328487326540633303185702306359400766259130239226832166456957259123554826741975265634464478609571816663003684533868318795865194004795637221226902067194633407757767792795252414073029114153019362701793292862118990912516058858923030408920700061749321
        S = 68460510129747727135744503403370273952956360997532594630007762045745171031173231339034881007977792852962667675924510408558639859602742661846943843432940752427075903037429735029814040501385798095836297700111333573975220392538916785564158079116348699773855815825029476864341585033111676283214405517983188761136
        Z = 44579327840225837958738167571392618381868336415293109834301264408385784355849790902532728798897199236650711385876328647206143271336410651651791998475869027595051047904885044274040212624547595999947339956165755500019260290516022753290814461070607850420459840370288988976468437318992206695361417725670417150636
        R = [
                75350858539899247205099195870657569095662997908054835686827949842616918065279527697469302927032348256512990413925385972530386004430200361722733856287145745926519366823425418198189091190950415327471076288381822950611094023093577973125683837586451857056904547886289627214081538422503416179373023552964235386251,
                16493273636283143082718769278943934592373185321248797185217530224336539646051357956879850630049668377952487166494198481474513387080523771033539152347804895674103957881435528189990601782516572803731501616717599698546778915053348741763191226960285553875185038507959763576845070849066881303186850782357485430766,
                13291821743359694134120958420057403279203178581231329375341327975072292378295782785938004910295078955941500173834360776477803543971319031484244018438746973179992753654070994560440903251579649890648424366061116003693414594252721504213975050604848134539324290387019471337306533127861703270017452296444985692840,
                86332479314886130384736453625287798589955409703988059270766965934046079318379171635950761546707334446554224830120982622431968575935564538920183267389540869023066259053290969633312602549379541830869908306681500988364676409365226731817777230916908909465129739617379202974851959354453994729819170838277127986187,
                68324072803453545276056785581824677993048307928855083683600441649711633245772441948750253858697288489650767258385115035336890900077233825843691912005645623751469455288422721175655533702255940160761555155932357171848703103682096382578327888079229101354304202688749783292577993444026613580092677609916964914513,
                65082646756773276491139955747051924146096222587013375084161255582716233287172212541454173762000144048198663356249316446342046266181487801411025319914616581971563024493732489885161913779988624732795125008562587549337253757085766106881836850538709151996387829026336509064994632876911986826959512297657067426387
        ]
        self.testPubK = PublicKey(n, Z, S, R, 0, time.time() + 365 * 24 * 3600)

    def test_proofu(self):
        """
        Test ProofU verification.
        """
        context = 34911926065354700717429826907189165808787187263593066036316982805908526740809
        nonce1 = 724811585564063105609243
        c = 4184045431748299802782143929438273256345760339041229271411466459902660986200
        U = 53941714038323323772993715692602421894514053229231925255570480167011458936488064431963770862062871590815370913733046166911453850329862473697478794938988248741580237664467927006089054091941563143176094050444799012171081539721321786755307076274602717003792794453593019124224828904640592766190733869209960398955
        vPrimeResponse = 930401833442556048954810956066821001094106683380918922610147216724718347679854246682690061274042716015957693675615113399347898060611144526167949042936228868420203309360695585386210327439216083389841383395698722832808268885873389302262079691644125050748391319832394519920382663304621540520277648619992590872190274152359156399474623649137315708728792245711389032617438368799004840694779408839779419604877135070624376537994035936
        sResponse = 59776396667523329313292302350278517468587673934875085337674938789292900859071752886820910103285722288747559744087880906618151651690169988337871960870439882357345503256963847251

        proofU = ProofU(U, c, vPrimeResponse, sResponse)

        self.assertTrue(proofU.Verify(self.testPubK, context, nonce1))

    def test_proofs(self):
        """
        Test ProofS verification.
        """
        context = 34911926065354700717429826907189165808787187263593066036316982805908526740809
        n2 = 1424916368173409716606

        A = 66389313221915836241271893803869162372470096003861448260498566798077037255866372791540928160267561756794143545532118654736979223658343806335872047371607436291528588343320128898584874264796312130159695427439025355009934986408160536404163490935544221152821545871675088845781351195696518382628790514628112517886
        e = 259344723055062059907025491480697571938277889515152306249728583105665800713306759149981690559193987143012367913206299323899696942213235956742930207251663943512715842083759814664217
        v = 32427566863312925183262683355749521096160753564085736927716798279834745436154181827687524960554513739692930154573915901486008843583586162755818099731448281905764117842382407835789897633042765641230655956290191876265377547222981221260311549695231999461733778383779100992221748503727598149536948999564401095816377323412637286891625085960745712119714441272446053177642615033258689648568679017384011895908901362352242970432640019866501367925956123252426587516554347912178721773507440862343752105273189184247444400383

        c = 60359393410007276721785600209946099643760005142374188599509762410975853354415
        eResponse = 1139627737042307991725447845798004742853435356249558932466535799661640630812910641126155269500348608443317861800376689024557774460643901450316279085276256524076388421890909312661873221470626068394945683125859434135652717426417681918932528613003921792075852313319584079881881807505760375270399908999784672094

        sig = CLSignature(A, e, v)
        proof = ProofS(c, eResponse)

        self.assertTrue(proof.Verify(self.testPubK, sig, context, n2))

    def test_proofd(self):
        """
        Test ProofD verification.
        """
        nonce1 = 356168310758183945030882
        context = 59317469690166962413036802769129097120995929488116634148207386064523180296869

        c = 92405256824458923934294175762399873039847432841647909261385804859937404075570
        A = 66467922530801909191099602528137141713616048447732479189179865050384832390931230033112445547628606292639430708552418462959456337530534055700746138057512598497120682196611341962749384189596253759402224308748002860890211498962735924481685975488607793795169788837476493253297353146422154392391732925567178805607
        eResponse = 44022597110989879399510333540268555303613344906583879371531630680320900347240418258690335759375210734514869637566864349585531295946323809
        vResponse = 26326301830460880582628741955953428491879823201714737915103888193625032953131902593859116395461541557845953939714765660366793552012359281854190756504190064959818584175057775414324351414234450208391534497565506441579960808534266557458251190151268682500197950418141493586125049371381626638554299245282498637246703583102656876690825544275995631773170789236920674341621008537679924624747222821679128060382072191284077393034573357698475000667180794116538132628586533009732462826119381931507809052573496513689222244701991737191273263148163121236326525677935993049602389899306007664212328515456044738278420

        aResponses = {0: 55247823867049193571627241180110605447453053126985891402640532123848293918217459966028364637387399903283634100097425890971508590427350301193682412170041146212137866279677802531}

        aDisclosed = {
            1: 1100598411265,
            2: 43098508374675488371040117572049064979183030441504364,
            3: 4919409929397552454,
        }

        proof1 = ProofD(c, A, eResponse, vResponse, aResponses, aDisclosed)

        self.assertTrue(proof1.Verify(self.testPubK, context, nonce1, False))

        aDisclosed[1] = 123
        proof2 = ProofD(c, A, eResponse, vResponse, aResponses, aDisclosed)
        self.assertFalse(proof2.Verify(self.testPubK, context, nonce1, False))
