from autosteper import XTB_Optimizer


an_optimizer = XTB_Optimizer(opt_para={
    'cmd_list': [r'/home/mkliu/anaconda3/envs/env001/bin/xtb', '--opt', 'tight', '--cycle 15'],
    'out_list': ['xtbopt.xyz', 'xtbopt.log'],
    'deal_wrong_mode': 'Complete',

    'mach_para': {
        'batch_type': "Torque",
        'context_type': "SSHContext",
        'remote_root': '/home/mkliu/test_dpdispatcher',
        'remote_profile': {
            "hostname": "219.245.39.76",
            "username": "mkliu",
            "password": "mkliu123",
            "port": 22,
            "timeout": 10
        }
    },
    'resrc_para': {
        'number_node': 5,
        'cpu_per_node': 6,
        'gpu_per_node': 0,
        'group_size': 3,
        'queue_name': "batch",
        'envs': {
            "OMP_STACKSIZE": "4G",
            "OMP_NUM_THREADS": "3,1",
            "OMP_MAX_ACTIVE_LEVELS": "1",
            "MKL_NUM_THREADS": "3"
        },
        'sub_batch_size': 11,
        'wrong_rcs_para': [[2, 6], [1, 1]]
    },
})

# raw folder is pre-defined
# 4oq44dc402ii49v.xyz is a structure (C76Cl30) randomly generated by AutoSteper,
# it will not converged under keyword --cycles 15, Recursive will download unaffected jobs,
# see dpdispatcher.log in this root.
an_optimizer.set_folders()
opt_status = an_optimizer.opt()
assert opt_status == 1
