#!/usr/bin/env python

from setuptools import setup


# Modified from http://stackoverflow.com/questions/2058802/
# how-can-i-get-the-version-defined-in-setup-py-setuptools-in-my-package
def version():
    import os
    import re

    init = os.path.join('sars2seq', '__init__.py')
    with open(init) as fp:
        initData = fp.read()
    match = re.search(r"^__version__ = ['\"]([^'\"]+)['\"]",
                      initData, re.M)
    if match:
        return match.group(1)
    else:
        raise RuntimeError('Unable to find version string in %r.' % init)


setup(name='sars2seq',
      version=version(),
      packages=['sars2seq'],
      url='https://github.com/virologycharite/sars2seq',
      download_url='https://github.com/virologycharite/sars2seq',
      author='Terry Jones',
      author_email='terry@jon.es',
      keywords=['SARS-CoV-2', 'genetic sequences'],
      classifiers=[
          'Programming Language :: Python :: 3.5',
          'Programming Language :: Python :: 3.6',
          'Programming Language :: Python :: 3.7',
          'Programming Language :: Python :: 3.8',
          'Development Status :: 4 - Beta',
          'Intended Audience :: Developers',
          'License :: OSI Approved :: MIT License',
          'Operating System :: OS Independent',
          'Topic :: Software Development :: Libraries :: Python Modules',
      ],
      description=('Python library and scripts for working with SARS-CoV-2 '
                   'sequences.'),
      long_description=(
          'See https://github.com/virologycharite/sars2seq for details.'),
      license='MIT',
      install_requires=['dark-matter>=3.1.82'])
