"""
********************************************************************************
rapid_clay_formations_fab
********************************************************************************

.. currentmodule:: rapid_clay_formations_fab

python module for MAS DFAB project Rapid Clay Formations
"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from os import path

HERE = path.dirname(__file__)
HOME = path.abspath(path.join(HERE, "../.."))
DOCKER_COMPOSE_DIR = path.join(HERE, "_compose_files")


def _get_version():
    # from https://smarie.github.io/python-getversion/#package-versioning-best-practices
    # and setuptools_scm docs
    try:
        # import from _version.py generated by setuptools_scm during release
        from ._version import version

        return version
    except ImportError:
        from importlib.metadata import version, PackageNotFoundError

        try:
            return version("rapid-clay-formations-fab")
        except PackageNotFoundError:
            # package is not installed
            pass

    return "src"


__author__ = "Anton T Johansson"
__copyright__ = "MAS DFAB 1920 students and tutors"
__license__ = "MIT License"
__email__ = "anton@tetov.se"
__version__ = _get_version()
