"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * (experimental) Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @experimental
 */
class FargateCluster extends cluster_1.Cluster {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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