import { Construct } from 'constructs';
import { Cluster, ClusterOptions } from './cluster';
import { FargateProfileOptions } from './fargate-profile';
/**
 * (experimental) Configuration props for EKS Fargate.
 *
 * @experimental
 */
export interface FargateClusterProps extends ClusterOptions {
    /**
     * (experimental) Fargate Profile to create along with the cluster.
     *
     * @default - A profile called "default" with 'default' and 'kube-system'
     *   selectors will be created if this is left undefined.
     * @experimental
     */
    readonly defaultProfile?: FargateProfileOptions;
}
/**
 * (experimental) Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @experimental
 */
export declare class FargateCluster extends Cluster {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FargateClusterProps);
}
