# BGM Toolkit – Labour v0.1.2

[![CI](https://github.com/ArturoNGR/bgm-toolkit-labour/actions/workflows/ci.yml/badge.svg)](https://github.com/ArturoNGR/bgm-toolkit-labour/actions/workflows/ci.yml)

Config-driven Bourdieu-inspired gravity model for labour markets: worker↔job matching, distance variants, elasticities, capacity & reports.

## Quick start

python3 -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
export PYTHONPATH="$PWD"
python -m pip install -e .
bgm-labour --help

or:

bgm-labour --config configs/run.yaml

## Inputs
- `workers.csv` (E,C,S)
- `jobs.csv` (E,C,S, capacity)

## Outputs (in `outputs/`)
- `H_matrix.csv`, `shares.csv`, `top_choices.csv`
- `elasticities.json`, `expected_demand.csv`, `capacity_utilization.csv`
- `report_excel.xlsx`, `report_html.html`

## Demos
https://arturongr.github.io/demos/

